/**************************************************************************************
* @file         : NavMiddlewareStartup.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include "HMIModelIncludes.h"
//#include "PopupUtils.h"
#include "HMIModelDefines.h"
#include "NavMiddlewareStartup.h"
#include "EnvironmentUtils.h"
//#include "ConfigurationUtils.h"
#include "App/datapool/NaviDataPoolConfig.h"

#if defined(HALL_TO_MDW_COM)

/** compatible middleware version */
const int NAV_MIDDLEWARE_MAJOR_VERSION = 422;
const int NAV_MIDDLEWARE_MINOR_VERSION = 0;

/** time to stay in the navigation limited mode */
const int TIME_TO_STAY_IN_NAVIGATION_LIMITED_MODE = 5000; // 5s

using namespace navmiddleware;

/** timer to be used to deactivate limited mode after startup */
Util::Timer* gNavigationLimitedModeTimer = NULL; // @Todo: Check to switch to a trigger from LCM to make it more robust

bool initializeMiddleware(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
{
   ConfigurationInfos configurationInfos;
   setMiddlewareConfigurationInformation(infoStore, configurationInfos);   //Call to set the configuration information to middleware.

   return navMiddleware.initialize(configurationInfos);
}


bool reinitializeMiddleware(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
{
   ConfigurationInfos configurationInfos;
   setMiddlewareConfigurationInformation(infoStore, configurationInfos);   //Call to set the configuration information to middleware.

   navMiddleware.restart(configurationInfos);   //Void function: hence assumption is that the function will always be successful.
   return true;
}


void setMiddlewareConfigurationInformation(InfoStore& infoStore, navmiddleware::ConfigurationInfos& configurationInfos)
{
   //configurationInfos.setNavigationUnitIdentifier(infoStore.getNavigationUnitId());
   navmiddleware::ConfigurationInfos::DisplayAspectRatio displayAspectRatio = navmiddleware::ConfigurationInfos::DISPLAY_ASPECT_RATIO__15_9;
   //if (InfoStoreBase::DISPLAY_ASPECT_RATIO_17_BY_9 == infoStore.getDisplayAspectRatio())
   //{
   //   displayAspectRatio = navmiddleware::ConfigurationInfos::DISPLAY_ASPECT_RATIO__17_9;
   //}

   configurationInfos.setScreenSize(ConfigurationInfos::ScreenDimensions(infoStore.getScreenWidth(), infoStore.getScreenHeight(), navmiddleware::ConfigurationInfos::DISPLAY_ASPECT_RATIO__15_9,        navmiddleware::ConfigurationInfos::DISPLAY_RESOLUTION__SVGA));

   configurationInfos.setHMILanguage(infoStore.getSystemLanguageISOCode(), (navmiddleware::LanguageCode)infoStore.getSystemLanguageIndex());
   configurationInfos.setSDSLanguage(infoStore.getSDSLanguageISOCode(), (navmiddleware::LanguageCode)infoStore.getSDSLanguageIndex());
   configurationInfos.setTrafficTextLanguage(infoStore.getTrafficTextISOCode(), (navmiddleware::LanguageCode)infoStore.getTrafficTextLanguageIndex());
   configurationInfos.setClusterLanguage(infoStore.getClusterLanguageISOCode(), (navmiddleware::LanguageCode)infoStore.getClusterLanguageIndex());
   configurationInfos.setDistanceUnitSystem((navmiddleware::DistanceUnitSystem)infoStore.getDistanceUnitSystem());
   configurationInfos.setRegionType((navmiddleware::RegionType)infoStore.getRegionType());
   configurationInfos.setDefaultVehicleProfile(infoStore.getDefaultVehicleProfile());

//   navMiddleware.setLanguage("en_US", navmiddleware::LANGUAGE_CODE__ENGLISH_US, "en_US", navmiddleware::LANGUAGE_CODE__ENGLISH_US, "en_US", navmiddleware::LANGUAGE_CODE__ENGLISH_US, "en_US", navmiddleware::LANGUAGE_CODE__ENGLISH_US);
   // Allocate the User Profile to NavMiddleware for the persistency
   configurationInfos.setUserProfile(navmiddleware::ConfigurationInfos::USER_PROFILE__1);
   const PosHeadingWGS84<float>& posHeadingWGS84 = infoStore.getDefaultPosition();
   configurationInfos.setDefaultPosition(
      navmiddleware::GeoCoordinateDegree(
         static_cast<double>(posHeadingWGS84._pos._latitude),
         static_cast<double>(posHeadingWGS84._pos._longitude)));
   configurationInfos.setDefaultPositionHeading(posHeadingWGS84._heading);
   //configurationInfos.setGenericConfiguration(ConfigurationUtils::constructGenericConfiguration(infoStore.getRegionType()));
   // request MAP_DISPLAY only while the limited feature mode for navigation is active to speed up the system start
   if (getEnvVarAsBool(ENV_HMI_CFG_LIMITED_MODE_ENABLED, true))
   {
      ::std::set<RequiredFeatures> requiredFeatures;
      requiredFeatures.insert(navmiddleware::RequiredFeatures__MAP_DISPLAY);
      navmiddleware::LimitedFeatureMode limitedFeatureMode(requiredFeatures);
      configurationInfos.setLimitedFeatureMode(limitedFeatureMode);
   }

   configurationInfos.setSoftwareVariant(navmiddleware::ConfigurationInfos::SOFTWAREVARIANT_RIVI);

   configurationInfos.setDisplayTimeOffset(infoStore.getLocalTimeOffset());
   configurationInfos.setLightMode((navmiddleware::ConfigurationInfos::LightMode)infoStore.getLightMode());
   if (infoStore.isClockAutoMode())
   {
      configurationInfos.setTimeZoneAndDSTConsideration(navmiddleware::ConfigurationInfos::TIMEZONE_AND_DST_OFFSET_CONSIDERATION__REQUIRED);
   }
   else
   {
      configurationInfos.setTimeZoneAndDSTConsideration(navmiddleware::ConfigurationInfos::TIMEZONE_AND_DST_OFFSET_CONSIDERATION__NOT_REQUIRED);
   }

   if(true == infoStore.getIsBlackListValid())
   {
      navmiddleware::ResidentialOrLocalMode residentialOrLocalMode(infoStore.getBlackListCountries());
      configurationInfos.setResidentialOrLocalMode(residentialOrLocalMode);
   }
}


bool checkNavMiddlewareVersion(navmiddleware::NavMiddleware& navMiddleware)
{
   bool startMiddleware = true;

   int majorVersion = navMiddleware.getMajorVersion();

   if (majorVersion != NAV_MIDDLEWARE_MAJOR_VERSION)
   {
      startMiddleware = false;
   }

   return startMiddleware;
}


void deactivateNavigationLimitedMode(navmiddleware::NavMiddleware& navMiddleware)
{
   navMiddleware.deactivateLimitedMode();
}


void startNavigationLimitedModeTimer()
{
   if (getEnvVarAsBool(ENV_HMI_CFG_LIMITED_MODE_ENABLED, true))
   {
      if (gNavigationLimitedModeTimer == NULL)
      {
         gNavigationLimitedModeTimer = new Util::Timer();
      }
      if (gNavigationLimitedModeTimer->running())
      {
         gNavigationLimitedModeTimer->restart();
      }
      else
      {
         gNavigationLimitedModeTimer->setTimeout(0, TIME_TO_STAY_IN_NAVIGATION_LIMITED_MODE, COURIER_MESSAGE_NEW(DeactivateLimitedModeReqMsg)());
         gNavigationLimitedModeTimer->start();
      }
   }
}


#endif // HALL_TO_MDW_COM
