/**************************************************************************************
* @file         : NavMiddlewarePropertyUpdateConsumer.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef NAV_MIDDLEWARE_PROPERTY_UPDATE_CONSUMER_H
#define NAV_MIDDLEWARE_PROPERTY_UPDATE_CONSUMER_H

#include "HMIModelIncludes.h"
#include "InfoStore.h"
#include "HMIModelDefines.h"

#if defined(HALL_TO_MDW_COM)

/**
* Base class for property update from middleware
*/
class NavMiddlewarePropertyUpdateConsumer : public navmiddleware::PropertyUpdateCallback
{
   public:
      NavMiddlewarePropertyUpdateConsumer(navmiddleware::NavMiddleware& navMiddleware);
      virtual ~NavMiddlewarePropertyUpdateConsumer();

   protected:
      /** NavMiddleware reference */
      navmiddleware::NavMiddleware& _navMiddleware;

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(NavMiddlewarePropertyUpdateConsumer);
};


#endif // HALL_TO_MDW_COM
#endif // NAV_MIDDLEWARE_PROPERTY_UPDATE_CONSUMER_H
