/**************************************************************************************
* @file         : InfoStoreCallbackManager.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "gui_std_if.h"
#include <algorithm>
#include <functional>
#include "HMIModelBase.h"
#include "InfoStoreCallbackManager.h"
#include "InfoStorePropertyUpdateCallback.h"

InfoStoreCallbackManager::InfoStoreCallbackManager()
{
}


InfoStoreCallbackManager::~InfoStoreCallbackManager()
{
}


void InfoStoreCallbackManager::registerDataPropertyUpdateCallback(InfoStorePropertyUpdateCallback& elem)
{
   _infoStoreCallbackVector.push_back(&elem);
}


void InfoStoreCallbackManager::unregisterDataPropertyUpdateCallback(InfoStorePropertyUpdateCallback& elem)
{
   _infoStoreCallbackVector.erase(std::remove(_infoStoreCallbackVector.begin(), _infoStoreCallbackVector.end(), &elem), _infoStoreCallbackVector.end());
}


void InfoStoreCallbackManager::notify(const InfoStorePropertyIdentifier propertyIdentifier)
{
   for (InfoStoreCallbackVector::const_iterator iter = _infoStoreCallbackVector.begin(); iter != _infoStoreCallbackVector.end(); ++iter)
   {
      if (*iter)
      {
         (*iter)->onPropertyUpdate(propertyIdentifier);
      }
   }
}
