/**************************************************************************************
* @file         : InfoStore.h
* @author       : ECG5-Atchuta Sashank Kappagantu
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef INFO_STORE_H
#define INFO_STORE_H

#include "HMIModelDefines.h"
#include "InfoStoreBase.h"
#include "AppHmi_NavigationStateMachine.h"

class InfoStore : public InfoStoreBase
{
   public:
      InfoStore();
      virtual ~InfoStore();

      void initialize();
      void deinitialize();
      void loadPersistencyFromDataPool();
      void notifyDataUpdatesFromDataPool();
      void savePersistencyToDataPool() const;
      void notifyDataUpdates();
      void notifyDataUpdatesRecovery();
      unsigned int getCarsorHeadingIndex() const;
      void setCarsorHeadingIndex(unsigned int headingIndex);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE_NOTRACE(LanguageRelevantForNavigationUpdateMsg)
      ON_COURIER_MESSAGE_NOTRACE(UnitSettingsStatusUpdateMsg)
      ON_COURIER_MESSAGE_NOTRACE(SpeedLockStatusUpdateMsg)
      ON_COURIER_MESSAGE_NOTRACE(SpeedLimitStatusUpdateMsg)
      ON_COURIER_MESSAGE_NOTRACE(DimmingModeStatusUpdateMsg)
      ON_COURIER_MESSAGE_NOTRACE(BTActiveDeviceUpdateMsg)
      ON_COURIER_MESSAGE_NOTRACE(BTConnectedDeviceUpdateMsg)
      ON_COURIER_MESSAGE_NOTRACE(GuidanceVolumeUpdateMsg)
      ON_COURIER_MESSAGE_NOTRACE(DateFormatChangeReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(TimeFormatChangeReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(LocalTimeOffsetInfoUpdMsg)
      ON_COURIER_MESSAGE_NOTRACE(LocalTimeChangeReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(MapDownloadLockStateChangedUpdMsg)
      ON_COURIER_MESSAGE_NOTRACE(ResetFactoryReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(SpmSystemStateChangedUpdMsg)
      ON_COURIER_MESSAGE_NOTRACE(CountryCodeUpdateMsg)
      COURIER_MSG_MAP_END()

      bool onCourierMessage(const LanguageRelevantForNavigationUpdateMsg& oMsg);
      bool onCourierMessage(const UnitSettingsStatusUpdateMsg& oMsg);
      bool onCourierMessage(const SpeedLockStatusUpdateMsg& oMsg);
      bool onCourierMessage(const SpeedLimitStatusUpdateMsg& oMsg);
      bool onCourierMessage(const DimmingModeStatusUpdateMsg& oMsg);
      bool onCourierMessage(const BTActiveDeviceUpdateMsg& oMsg);
      bool onCourierMessage(const BTConnectedDeviceUpdateMsg& oMsg);
      bool onCourierMessage(const GuidanceVolumeUpdateMsg& oMsg);
      bool onCourierMessage(const DateFormatChangeReqMsg& oMsg);
      bool onCourierMessage(const TimeFormatChangeReqMsg& oMsg);
      bool onCourierMessage(const LocalTimeOffsetInfoUpdMsg& oMsg);
      bool onCourierMessage(const LocalTimeChangeReqMsg& oMsg);
      bool onCourierMessage(const MapDownloadLockStateChangedUpdMsg& oMsg);
      bool onCourierMessage(const ResetFactoryReqMsg& oMsg);
      bool onCourierMessage(const SpmSystemStateChangedUpdMsg& oMsg);
      bool onCourierMessage(const CountryCodeUpdateMsg& oMsg);

      const bool isNarRegion() const;
      const bool isEurRegion() const;
      const bool isTruckType() const;
      const bool isNo3D_TypeSelected() const;
      const bool isNonNaviVariant() const;
      unsigned int tripCount;

   private:
      unsigned int carsorHeadingIndex;
      void updateDefaultVehicleProfile();
      void updateBlackListCountries();
};


#endif // INFO_STORE_H
