/**************************************************************************************
* @file         : ImageUtils.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <fstream>
#include "ImageUtils.h"

#if defined(HALL_TO_MDW_COM)

#ifdef _MSC_VER
#define path "images"
#else
#define path "/var/opt/bosch/dynamic/images"
#endif


//#define PRINT_IMAGE_CACHE_HITRATE


Candera::MemoryManagement::SharedPointer<Candera::BitmapImage2D> loadImage(const char* data, size_t dataSize, bool cacheImage)
{
   static ImageCache imageCache;
   FeatStd::MemoryManagement::SharedPointer<Candera::BitmapImage2D> image = FeatStd::MemoryManagement::SharedPointer<Candera::BitmapImage2D>();

   if (data && dataSize)
   {
      // check if we have the image in the cache
      if (!(cacheImage && imageCache.findImage((int)data, dataSize, image)))
      {
#if defined (PRINT_IMAGE_CACHE_HITRATE)
         printf("loadImage() data: %d, dataSize: %d, image\n", (int)data, dataSize);
#endif

         // if we don't have it in the cache, decode the image
         Candera::Bitmap::SharedPointer bitmap = ImageLoader::loadBitmapData(data, dataSize);
         if (bitmap != NULL)
         {
            image = ImageLoader::createImage(bitmap);
         }

         // if the image should be cached, add it to the cache
         if (cacheImage)
         {
            imageCache.addImage((int)data, dataSize, image);
         }
      }
#if defined (PRINT_IMAGE_CACHE_HITRATE)
      else
      {
         printf("loadImage() data: %d, dataSize: %d, image cached\n", (int)data, dataSize);
      }
#endif
   }

   return image;
}


void dumpImageToDisk(const char* data, size_t dataSize)
{
   static int pngNumber = 0;
   ::std::stringstream imagePathAndName;

   imagePathAndName << path << "/" << pngNumber << ".png";
   ++pngNumber;

   std::ofstream imgout(imagePathAndName.str().c_str(), std::ofstream::binary);
   imgout.write(data, dataSize);
   imgout.close();
}


Courier::Platform::CriticalSection& ImageCache::ScopedCriticalSection::getCriticalSection()
{
   static Courier::Platform::CriticalSection sCriticalSection;
   return sCriticalSection;
}


#endif // HALL_TO_MDW_COM
