/**************************************************************************************
* @file         : HMIModelDefines.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#if !defined(_HMI_MODEL_DEFINES_H)
#define _HMI_MODEL_DEFINES_H

#if defined(_MSC_VER)
/** route tracing to stdout */
#define WIN32_DEBUG_TO_STDOUT

/** deactivate warnings on windows */
#pragma warning(disable : 4005)

#endif

#if defined(NAV_MIDDLEWARE_AVAILABLE) || defined(GEN3ARM) || defined(GEN3X86)
/** activate hall to middleware communication */
#define HALL_TO_MDW_COM
#include "NavMiddleware.h"
#include "NavMiddlewareUtils.h"
#endif

#if defined(GEN3ARM) || defined(GEN3X86)
/** activate hall navigation service */
#define HALL_NAVIGATION_SERVICE
#define HALL_NAVIGATION_SDS_SERVICE
#define HALL_NAVIGATION_DATAUPDATE_SERVICE
///** activate MapUpdate partition lock */
#define MAPUPDATE_PARTITION_LOCK_FEATURE
#endif


/** Activate E2EHandler */
//#define HALL_E2E_COM
//#if defined(GEN3ARM) || defined(GEN3X86)
/** Activate E2E BT support */
//#define HALL_E2E_BTMIDW_SERVICE
//#endif


/** delegate only if the passed condition is true */
#define COURIER_MSG_DELEGATE_TO_REF_IF_TRUE(x, y) \
   if (y) { if (x.OnMessage(Msg)) return true; }

/** delegate to ref and unlock middleware in addition */
#define COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(x, _NAVMIDDLEWARE_) \
   if (x.OnMessage(Msg)) { _NAVMIDDLEWARE_.unlock(); return true; }

/** call delegate start and lock middleware in addition */
#define COURIER_MSG_MAP_DELEGATE_START_AND_LOCK(_NAVMIDDLEWARE_) \
   COURIER_MSG_MAP_DELEGATE_START() \
   _NAVMIDDLEWARE_.lock();

/** call delegate end and unlock middleware in addition */
#define COURIER_MSG_MAP_DELEGATE_END_AND_UNLOCK(_NAVMIDDLEWARE_) \
   _NAVMIDDLEWARE_.unlock(); \
   COURIER_MSG_MAP_DELEGATE_END()

/** For converting enum */
#define ENUM_CONVERT_DECLARE(_func,_inType,_outType) _outType _func(_inType inVal)
#define ENUM_CONVERT_START(_func,_inType,_outType) _outType _func(_inType inVal){switch(inVal){
#define ENUM_CONVERT_ENTRY(x,y) case x: return y;
#define ENUM_CONVERT_END(y) default: return y; }}

#endif // _HMI_MODEL_DEFINES_H
