/**************************************************************************************
* @file         : EnvironmentUtils.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef ENVIRONMENTUTILS_H
#define ENVIRONMENTUTILS_H 1

#include "HMIModelDefines.h"

#define ENV_HMI_ASSET_NAME "HMI_ASSET_NAME"
#define ENV_HMI_ASSET_RESOURCE1_NAME "HMI_ASSET_RESOURCE1_NAME"
#define ENV_HMI_ASSET_RESOURCE2_NAME "HMI_ASSET_RESOURCE2_NAME"
#define ENV_HMI_ASSET_LANGUAGES_NAME "HMI_ASSET_LANGUAGES_NAME"
#define ENV_HMI_ASSET_TEXTSTYLE_NAME "HMI_ASSET_TEXTSTYLE_NAME"

#define ENV_HMI_CFG_HAS_EXTERNAL_NAVIGATION "HMI_CFG_HAS_EXTERNAL_NAVIGATION"
#define ENV_HMI_CFG_FREEZE_MAP_ALLOWED "HMI_CFG_FREEZE_MAP_ALLOWED"
#define ENV_HMI_CFG_SHOW_EXPERIMENTAL_FEATURES "HMI_CFG_SHOW_EXPERIMENTAL_FEATURES"
#define ENV_HMI_CFG_DISABLE_SPEEDLOCK "HMI_CFG_DISABLE_SPEEDLOCK"
#define ENV_HMI_CFG_LIMITED_MODE_ENABLED "HMI_CFG_LIMITED_MODE_ENABLED"
#define ENV_HMI_CFG_SURFACE_SYNCHRONIZATION_ENABLED "HMI_CFG_SURFACE_SYNCHRONIZATION_ENABLED"

#define ENV_HMI_DP_REGION_TYPE "HMI_DP_REGION_TYPE"
#define ENV_HMI_DP_VEHICLE_TYPE "HMI_DP_VEHICLE_TYPE"

#define ENV_HMI_DP_DEFAULT_POSITION_LON "HMI_DP_DEFAULT_POSITION_LON"
#define ENV_HMI_DP_DEFAULT_POSITION_LAT "HMI_DP_DEFAULT_POSITION_LAT"
#define ENV_HMI_DP_DEFAULT_POSITION_HEADING "HMI_DP_DEFAULT_POSITION_HEADING"

#define ENV_HMI_DP_NAVIGATION_UNIT_ID "HMI_DP_NAVIGATION_UNIT_ID"

#define ENV_HMI_DP_LANGUAGE_INDEX_SYSTEM "HMI_DP_LANGUAGE_INDEX_SYSTEM"
#define ENV_HMI_DP_LANGUAGE_ISOCODE_SYSTEM "HMI_DP_LANGUAGE_ISOCODE_SYSTEM"
#define ENV_HMI_DP_LANGUAGE_INDEX_SDS "HMI_DP_LANGUAGE_INDEX_SDS"
#define ENV_HMI_DP_LANGUAGE_ISOCODE_SDS "HMI_DP_LANGUAGE_ISOCODE_SDS"
#define ENV_HMI_DP_LANGUAGE_INDEX_CLUSTER "HMI_DP_LANGUAGE_INDEX_CLUSTER"
#define ENV_HMI_DP_LANGUAGE_ISOCODE_CLUSTER "HMI_DP_LANGUAGE_ISOCODE_CLUSTER"
#define ENV_HMI_DP_LANGUAGE_INDEX_TRAFFICTEXT "HMI_DP_LANGUAGE_INDEX_TRAFFICTEXT"
#define ENV_HMI_DP_LANGUAGE_ISOCODE_TRAFFICTEXT "HMI_DP_LANGUAGE_ISOCODE_TRAFFICTEXT"

#define ENV_HMI_DP_LIGHT_MODE "HMI_DP_LIGHT_MODE"
#define ENV_HMI_DP_DATE_FORMAT "HMI_DP_DATE_FORMAT"
#define ENV_HMI_DP_TIME_FORMAT "HMI_DP_TIME_FORMAT"
#define ENV_HMI_DP_LOCALTIME_OFFSET "HMI_DP_LOCALTIME_OFFSET"
#define ENV_HMI_DP_CLOCK_AUTOMODE_ON "HMI_DP_CLOCK_AUTOMODE_ON"
#define ENV_HMI_DP_ECODRIVEREPORT_AVAILABLE "HMI_DP_ECODRIVEREPORT_AVAILABLE"

#define ENV_HMI_DP_DISTANCEUNITSYSTEM "HMI_DP_DISTANCEUNITSYSTEM"

#define ENV_HMI_DP_GUIDANCE_ACTIVE "HMI_DP_GUIDANCE_ACTIVE"

#define ENV_HMI_DP_DISPLAY_ORIENTATION "HMI_DP_DISPLAY_ORIENTATION"

bool getEnvVarAsBool(const char* environmentVariableString, bool defaultValue);
int getEnvVarAsInt(const char* environmentVariableString, int defaultValue);
float getEnvVarAsFloat(const char* environmentVariableString, float defaultValue);
char getEnvVarAsChar(const char* environmentVariableString, char defaultValue);
std::string getEnvVarAsString(const char* environmentVariableString, const std::string& defaultValue);

#endif // ENVIRONMENTUTILS_H
