/**************************************************************************************
* @file         : EnvironmentUtils.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <stdlib.h>
#include "EnvironmentUtils.h"

bool getEnvVarAsBool(const char* environmentVariableString, bool defaultValue)
{
   char* value = getenv(environmentVariableString);
   if (value)
   {
      return (atoi(value) > 0) ? true : false;
   }
   return defaultValue;
}


int getEnvVarAsInt(const char* environmentVariableString, int defaultValue)
{
   char* value = getenv(environmentVariableString);
   if (value)
   {
      return (int)atoi(value);
   }
   return defaultValue;
}


float getEnvVarAsFloat(const char* environmentVariableString, float defaultValue)
{
   char* value = getenv(environmentVariableString);
   if (value)
   {
      return (float)atof(value);
   }
   return defaultValue;
}


char getEnvVarAsChar(const char* environmentVariableString, char defaultValue)
{
   char* value = getenv(environmentVariableString);
   if (value)
   {
      return value[0];
   }
   return defaultValue;
}


std::string getEnvVarAsString(const char* environmentVariableString, const std::string& defaultValue)
{
   char* value = getenv(environmentVariableString);
   if (value)
   {
      return value;
   }
   return defaultValue;
}
