/**************************************************************************************
* @file         : NavigationServiceUtils.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef _NAVIGATION_SERVICE_UTILS_H
#define _NAVIGATION_SERVICE_UTILS_H
#include "Common/Util/HMIModelIncludes.h"
#if (defined(HALL_NAVIGATION_SERVICE) || defined(HALL_NAVIGATION_SDS_SERVICE) || defined(HALL_NAVIGATION_DATAUPDATE_SERVICE))
#include "org/bosch/cm/navigation/NavigationSDSServiceStub.h"
#include "org/bosch/cm/navigation/NavigationServiceStub.h"
#include "org/bosch/cm/navigation/NavigationDataUpdateServiceStub.h"

#define NAVSERVICE               ::org::bosch::cm::navigation::NavigationService
#define NAVSERVICE_SDS           ::org::bosch::cm::navigation::NavigationSDSService
#define NAVSERVICE_DATAUPDATE    ::org::bosch::cm::navigation::NavigationDataUpdateService

/* NAVIGATION SERVICE UTILS */
int32_t convertZoomLevel(NAVSERVICE::ZoomLevel zoomLevel);

/* NAVIGATION SDS SERVICE UTILS*/

NAVSERVICE_SDS::SDSHandOverScreenId convertNaviSdsHandOverScreenId(enSDSHandoverScreenID screenId);
NAVSERVICE_SDS::PhoneticTranscriptionFormat convertPhoneticTranscriptionFormat(navmiddleware::SdsPhoneticTranscriptionFormat transcriptFormat);
NAVSERVICE_SDS::LocationType convertNaviSdsHandOverLocationType(navmiddleware::LocationSearchScope::Type searchScope);
NAVSERVICE_SDS::DirectionDescription convertNaviSDSDirectionDescription(navmiddleware::DirectionDescription direction);
NAVSERVICE_SDS::RoadClass convertRoadClass(navmiddleware::RoadClass roadClass);
NAVSERVICE_SDS::AddressElementType convertAddressElementType(navmiddleware::SDSAddressElementType type);
navmiddleware::NdsFeatureType convertNDSFeatureType(NAVSERVICE_SDS::NDSFeatureType ndsFeatureType);
navmiddleware::NdsDatasetUser convertNDSDataUser(NAVSERVICE_SDS::NdsDatasetUser ndsDataUser);
NAVSERVICE_SDS::LockType convertLockType(navmiddleware::LockType lockType);
NAVSERVICE_SDS::JournalingMode convertJournalingMode(navmiddleware::JournalingMode journalingMode);
NAVSERVICE_SDS::SharedDataAccess convertSharedDataAccess(navmiddleware::SharedDataAccess sharedDataAccess);

NAVSERVICE_SDS::SDSAddressElementType convertSDSAddressElementType(navmiddleware::SDSAddressElementType middlSDSAddressElementType);
navmiddleware::SDSAddressElementType convertSDSAddressElementType(NAVSERVICE_SDS::SDSAddressElementType serviceSDSAddressElementType);
navmiddleware::NdsDataAccessType convertNDSDataAccessType(NAVSERVICE_SDS::NdsDataAccessType ndsDataAccessType);

NAVSERVICE::JamAheadActivityStatus getJamAheadActivityStatus(navmiddleware::JamAheadListInfo::JamAheadActivityStatus result);
navmiddleware::PredefinedPoiCategory getFixedPOICategory(NAVSERVICE::FixedPOICategory result);

/* NAVIGATION DATA UPDATE SEVICE's UTILs */

NAVSERVICE_DATAUPDATE::NavigationDataUpdateStatus getMappedNavigationDataUpdateStatus(enNavDataUpdate_DiagFullUpdateResult result);
NAVSERVICE_DATAUPDATE::NavigationDataUpdateStatus getMappedNavigationDataUpdateStatus(navmiddleware::NavDataUpdateStatus::DataUpdateStatus status);

NAVSERVICE::DestinationMemoryAddressType getDestinationMemoryAddressType(navmiddleware::LocationAttributeInfos::AddressDetailInfo::AddressInfoType result);
#endif // (defined(HALL_NAVIGATION_SERVICE) || defined(HALL_NAVIGATION_SDS_SERVICE) || defined(HALL_NAVIGATION_DATAUPDATE_SERVICE))
#endif /* _NAVIGATION_SERVICE_UTILS_H */
