/**************************************************************************************
* @file         : NavigationServiceUtils.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "NavigationServiceUtils.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/NavigationServiceUtils.cpp.trc.h"
#endif

#if (defined(HALL_NAVIGATION_SERVICE) || defined(HALL_NAVIGATION_SDS_SERVICE) || defined(HALL_NAVIGATION_DATAUPDATE_SERVICE))
using namespace ::org::bosch::cm::navigation;

/* NAVIGATION SERVICE UTILS */
int32_t convertZoomLevel(NAVSERVICE::ZoomLevel zoomLevel)
{
   int32_t ret = 50;
   switch (zoomLevel)
   {
      case NAVSERVICE::ZoomLevel__ZOOM_50M:
         ret = 50;
         break;
      case NAVSERVICE::ZoomLevel__ZOOM_100M:
         ret = 100;
         break;
      case NAVSERVICE::ZoomLevel__ZOOM_200M:
         ret = 200;
         break;
      case NAVSERVICE::ZoomLevel__ZOOM_500M:
         ret = 500;
         break;
      case NAVSERVICE::ZoomLevel__ZOOM_1000M:
         ret = 1000;
         break;
      case NAVSERVICE::ZoomLevel__ZOOM_2000M:
         ret = 2000;
         break;
      case NAVSERVICE::ZoomLevel__ZOOM_5000M:
         ret = 5000;
         break;
      case NAVSERVICE::ZoomLevel__ZOOM_10000M:
         ret = 10000;
         break;
      default:
         ret = 50;
         break;
   }
   return ret;
}


/* NAVIGATION SDS SERVICE UTILS*/

NavigationSDSService::SDSHandOverScreenId convertNaviSdsHandOverScreenId(enSDSHandoverScreenID screenId)
{
   NavigationSDSService::SDSHandOverScreenId convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_INACTIVE_SCREEN;
   switch (screenId)
   {
      case SDS_HANDOVER_NAVI_FREE_TEXT_SEARCH_ADDRESS:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_FREE_TEXT_SEARCH_ADDRESS;
         break;
      case SDS_HANDOVER_NAVI_FREE_TEXT_SEARCH_POI:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_FREE_TEXT_SEARCH_POI;
         break;
      case SDS_HANDOVER_NAVI_ENTER_COUNTRY:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_ENTER_COUNTRY;
         break;
      case SDS_HANDOVER_NAVI_ENTER_STATE:
      case SDS_HANDOVER_NAVI_ENTER_STATE_MAIN:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_ENTER_STATE;
         break;
      case SDS_HANDOVER_NAVI_HNOFIRST_HNO:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_HNOFIRST_HNO;
         break;
      case SDS_HANDOVER_NAVI_HNOFIRST_STREET:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_HNOFIRST_STREET;
         break;
      case SDS_HANDOVER_NAVI_HNOFIRST_STREET_CITY:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_HNOFIRST_STREET_CITY;
         break;
      case SDS_HANDOVER_NAVI_CITYFIRST_CITY:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_CITYFIRST_CITY;
         break;
      case SDS_HANDOVER_NAVI_CITYFIRST_HNO:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_CITYFIRST_HNO;
         break;
      case SDS_HANDOVER_NAVI_CITYFIRST_HNO_STREET:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_CITYFIRST_HNO_STREET;
         break;
      case SDS_HANDOVER_NAVI_CITYFIRST_STREET_HNO:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_CITYFIRST_STREET_HNO;
         break;
      case SDS_HANDOVER_NAVI_AMBIG_ADDRESS:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_AMBIG_ADDRESS;
         break;
      case  SDS_HANDOVER_NAVI_SETDEST_ADDRESS:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_SETDEST_ADDRESS;
         break;
      case SDS_HANDOVER_NAVI_CITYCENTER_CITY:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_CITYCENTER_CITY;
         break;
      case SDS_HANDOVER_NAVI_CITYCENTER_STATE:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_CITYCENTER_STATE;
         break;
      case SDS_HANDOVER_NAVI_AMBIG_CITYCENTER:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_AMBIG_CITYCENTER;
         break;
      case SDS_HANDOVER_NAVI_SETDEST_CITYCENTER:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_SETDEST_CITYCENTER;
         break;
      case SDS_HANDOVER_NAVI_INTERSECTION_STREET1:
      case SDS_HANDOVER_NAVI_INTERSECTION_STREET1_CANDIDATE_LIST:
      case SDS_HANDOVER_NAVI_INTERSECTION_STREET1_NORMAL_LIST:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_INTERSECTION_STREET1;
         break;
      case SDS_HANDOVER_NAVI_INTERSECTION_STREET2:
      case SDS_HANDOVER_NAVI_INTERSECTION_STREET2_CANDIDATE_LIST:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_INTERSECTION_STREET2;
         break;
      case SDS_HANDOVER_NAVI_INTERSECTION_CITY:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_INTERSECTION_CITY;
         break;
      case SDS_HANDOVER_NAVI_INTERSECTION_STATE:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_INTERSECTION_STATE;
         break;
      case SDS_HANDOVER_NAVI_INTERSECTION_COUNTRY:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_INTERSECTION_COUNTRY;
         break;
      case SDS_HANDOVER_NAVI_INTERSECTION_LIST:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_INTERSECTION_LIST;
         break;
      case SDS_HANDOVER_NAVI_SETDEST_INTERSECTION:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_SETDEST_INTERSECTION;
         break;
      case SDS_HANDOVER_NAVI_POI:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_POI;
         break;
      case SDS_HANDOVER_NAVI_POI_CATEGORY:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_POI_CATEGORY;
         break;
      case SDS_HANDOVER_NAVI_POI_LIST:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_POI_LIST;
         break;
      case SDS_HANDOVER_NAVI_POI_INCITY:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_POI_INCITY;
         break;
      case SDS_ENTRY_NAVI_POI_ENTER_STATE:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_POI_ENTER_STATE;
         break;
      case SDS_ENTRY_NAVI_POI_ENTER_COUNTRY:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_POI_ENTER_COUNTRY;
         break;
      case SDS_HANDOVER_NAVI_SETDEST_POI:
         convertedScreenId = NavigationSDSService::SDSHandOverScreenId__NAVI_SETDEST_POI;
         break;
      case SDS_HANDOVER_NAVI_INACTIVE_SCREEN:
         break;
      default:
         break;
   }
   return convertedScreenId;
}


NavigationSDSService::LocationType convertNaviSdsHandOverLocationType(navmiddleware::LocationSearchScope::Type searchScope)
{
   NavigationSDSService::LocationType ret = NavigationSDSService::LocationType__DEFAULT;
   switch (searchScope)
   {
      case navmiddleware::LocationSearchScope::TYPE__AROUND_CURRENT_VEHICLE_POSITION:
         ret = NavigationSDSService::LocationType__NEAR_CURRENT_LOCATION;
         break;
      case navmiddleware::LocationSearchScope::TYPE__ALONG_ROUTE:
         ret = NavigationSDSService::LocationType__ALONG_ROUTE;
         break;
      case navmiddleware::LocationSearchScope::TYPE__AROUND_WAYPOINT_POSITION:
         ret = NavigationSDSService::LocationType__NEARBY_DESTINATION;
         break;
      default:
         break;
   }
   return ret;
}


org::bosch::cm::navigation::NavigationSDSService::DirectionDescription convertNaviSDSDirectionDescription(navmiddleware::DirectionDescription direction)
{
   org::bosch::cm::navigation::NavigationSDSService::DirectionDescription ret;
   switch (direction)
   {
      case navmiddleware::DIRECTIONDESCRIPTION_NORTH:
         ret = NavigationSDSService::DirectionDescription__NORTH;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_NORTH_NORTH_EAST :
         ret = NavigationSDSService::DirectionDescription__NORTH_NORTH_EAST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_NORTH_EAST:
         ret = NavigationSDSService::DirectionDescription__NORTH_EAST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_EAST_NORTH_EAST:
         ret = NavigationSDSService::DirectionDescription__EAST_NORTH_EAST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_EAST:
         ret = NavigationSDSService::DirectionDescription__EAST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_EAST_SOUTH_EAST:
         ret = NavigationSDSService::DirectionDescription__EAST_SOUTH_EAST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_SOUTH_EAST:
         ret = NavigationSDSService::DirectionDescription__SOUTH_EAST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_SOUTH_SOUTH_EAST:
         ret = NavigationSDSService::DirectionDescription__SOUTH_SOUTH_EAST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_SOUTH:
         ret = NavigationSDSService::DirectionDescription__SOUTH;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_SOUTH_SOUTH_WEST:
         ret = NavigationSDSService::DirectionDescription__SOUTH_SOUTH_WEST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_SOUTH_WEST:
         ret = NavigationSDSService::DirectionDescription__SOUTH_WEST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_WEST_SOUTH_WEST:
         ret = NavigationSDSService::DirectionDescription__WEST_SOUTH_WEST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_WEST:
         ret = NavigationSDSService::DirectionDescription__WEST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_WEST_NORTH_WEST:
         ret = NavigationSDSService::DirectionDescription__WEST_NORTH_WEST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_NORTH_WEST:
         ret = NavigationSDSService::DirectionDescription__NORTH_WEST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_NORTH_NORTH_WEST:
         ret = NavigationSDSService::DirectionDescription__NORTH_NORTH_WEST;
         break;
      case navmiddleware::DIRECTIONDESCRIPTION_SIZE:
         ret = NavigationSDSService::DirectionDescription__INVALID;
         break;
      default:
         ETG_TRACE_USR4(("Default case returning DirectionDescription__INVALID"));
         ret = NavigationSDSService::DirectionDescription__INVALID;
         break;
   }
   return ret;
}


NavigationSDSService::AddressElementType convertAddressElementType(navmiddleware::SDSAddressElementType type)
{
   NavigationSDSService::AddressElementType ret = NavigationSDSService::AddressElementType__COUNTRY;
   switch (type)
   {
      case navmiddleware::SDSADDRESSELEMENTTYPE_COUNTRY:
         ret = NavigationSDSService::AddressElementType__COUNTRY;
         break;
      case navmiddleware::SDSADDRESSELEMENTTYPE_PLACE:
         ret = NavigationSDSService::AddressElementType__PLACE;
         break;
      case navmiddleware::SDSADDRESSELEMENTTYPE_ROAD:
         ret = NavigationSDSService::AddressElementType__ROAD;
         break;
      case navmiddleware::SDSADDRESSELEMENTTYPE_CROSSROAD:
         ret = NavigationSDSService::AddressElementType__CROSSROAD;
         break;
      case navmiddleware::SDSADDRESSELEMENTTYPE_HOUSENUMBER:
         ret = NavigationSDSService::AddressElementType__HOUSENUMBER;
         break;
      case navmiddleware::SDSADDRESSELEMENTTYPE_POSTALDISRICT:
         ret = NavigationSDSService::AddressElementType__POSTALDISTRICT;
         break;
      case navmiddleware::SDSADDRESSELEMENTTYPE_CITYDISTRICT:
         ret = NavigationSDSService::AddressElementType__CITYDESTRICT;
         break;
      case navmiddleware::SDSADDRESSELEMENTTYPE_PLACEREFINEMENT:
         ret = NavigationSDSService::AddressElementType__PLACEREFINEMENT;
         break;
      case navmiddleware::SDSADDRESSELEMENTTYPE_ROADREFINEMENT:
         ret = NavigationSDSService::AddressElementType__ROADREFINEMENT;
         break;
      case navmiddleware::SDSADDRESSELEMENTTYPE_STATE:
         ret = NavigationSDSService::AddressElementType__STATE;
         break;
      default:
         break;
   }
   return ret;
}


NavigationSDSService::PhoneticTranscriptionFormat convertPhoneticTranscriptionFormat(navmiddleware::SdsPhoneticTranscriptionFormat transcriptFormat)
{
   NavigationSDSService::PhoneticTranscriptionFormat ret = NavigationSDSService::PhoneticTranscriptionFormat__TA_IPA;
   switch (transcriptFormat)
   {
      case navmiddleware::SDS_PHONETIC_TRANSCRIPTION_FORMAT__TA_IPA:
         ret = NavigationSDSService::PhoneticTranscriptionFormat__TA_IPA;
         break;
      case navmiddleware::SDS_PHONETIC_TRANSCRIPTION_FORMAT__STARREC_SAMPA:
         ret = NavigationSDSService::PhoneticTranscriptionFormat__STARREC_SAMPA;
         break;
      case navmiddleware::SDS_PHONETIC_TRANSCRIPTION_FORMAT__X_SAMPA:
         ret = NavigationSDSService::PhoneticTranscriptionFormat__X_SAMPA;
         break;
      case navmiddleware::SDS_PHONETIC_TRANSCRIPTION_FORMAT__LH_PLUS:
         ret = NavigationSDSService::PhoneticTranscriptionFormat__LH_PLUS;
         break;
      case navmiddleware::SDS_PHONETIC_TRANSCRIPTION_FORMAT__NT_SAMPA:
         ret = NavigationSDSService::PhoneticTranscriptionFormat__NT_SAMPA;
         break;
      case navmiddleware::SDS_PHONETIC_TRANSCRIPTION_FORMAT__SVOX_PA:
         ret = NavigationSDSService::PhoneticTranscriptionFormat__SVOX_PA;
         break;
      case navmiddleware::SDS_PHONETIC_TRANSCRIPTION_FORMAT__VFA:
         ret = NavigationSDSService::PhoneticTranscriptionFormat__VFA;
         break;
      case navmiddleware::SDS_PHONETIC_TRANSCRIPTION_FORMAT__I_FLYTEC:
         ret = NavigationSDSService::PhoneticTranscriptionFormat__I_FLYTEC;
         break;
      default:
         break;
   }
   return ret;
}


NavigationSDSService::PrerecordedVoiceFormat convertPrerecordedVoiceFormat(navmiddleware::SdsPreRecordedVoiceFormat voiceFormat)
{
   NavigationSDSService::PrerecordedVoiceFormat ret = ((voiceFormat == navmiddleware::SDS_PRE_RECORDED_VOICE_FORMAT__ADPCM) ?
         NavigationSDSService::PrerecordedVoiceFormat__ADPCM : NavigationSDSService::PrerecordedVoiceFormat__MP3);
   return ret;
}


navmiddleware::NdsFeatureType convertNDSFeatureType(NavigationSDSService::NDSFeatureType ndsFeatureType)
{
   navmiddleware::NdsFeatureType ret = navmiddleware::NDS_FEATURE_TYPE__NAMED_OBJECT;;
   switch (ndsFeatureType)
   {
      case NavigationSDSService::NDSFeatureType__NAMEDOBJECT:
         ret = navmiddleware::NDS_FEATURE_TYPE__NAMED_OBJECT;
         break;
      case NavigationSDSService::NDSFeatureType__POI_NAME:
         ret = navmiddleware::NDS_FEATURE_TYPE__POI_NAME;
         break;
      case NavigationSDSService::NDSFeatureType__POI_CATEGORY:
         ret = navmiddleware::NDS_FEATURE_TYPE__POI_CATEGORY;
         break;
      case NavigationSDSService::NDSFeatureType__POI_ATTRIBUTE:
         ret = navmiddleware::NDS_FEATURE_TYPE__POI_ATTRIBUTE;
         break;
      default:
         break;
   }
   return ret;
}


navmiddleware::NdsDatasetUser convertNDSDataUser(NAVSERVICE_SDS::NdsDatasetUser ndsDataUser)
{
   navmiddleware::NdsDatasetUser ret = navmiddleware::NDS_DATASET_USER__UNKNOWN;
   if (ndsDataUser == NavigationSDSService::NdsDatasetUser__NDS_DATASET_USER__SDS)
   {
      ret = navmiddleware::NDS_DATASET_USER__SDS;
   }
   return ret;
}


::org::bosch::cm::navigation::NavigationSDSService::RoadClass convertRoadClass(navmiddleware::RoadClass roadClass)
{
   switch (roadClass)
   {
      case navmiddleware::ROAD_CLASS__NONE:
         return NavigationSDSService::RoadClass__ROAD_CLASS_NONE;
      case navmiddleware::ROAD_CLASS__MOTORWAY:
         return NavigationSDSService::RoadClass__ROAD_CLASS_MOTORWAY;
      case navmiddleware::ROAD_CLASS__FREEWAY:
         return NavigationSDSService::RoadClass__ROAD_CLASS_FREEWAY;
      case navmiddleware::ROAD_CLASS__HIGHWAY:
         return NavigationSDSService::RoadClass__ROAD_CLASS_HIGHWAY;
      case navmiddleware::ROAD_CLASS__ARTERIAL:
         return NavigationSDSService::RoadClass__ROAD_CLASS_ARTERIAL;
      case navmiddleware::ROAD_CLASS__COLLECTOR:
         return NavigationSDSService::RoadClass__ROAD_CLASS_COLLECTOR;
      case navmiddleware::ROAD_CLASS__LOCAL:
         return NavigationSDSService::RoadClass__ROAD_CLASS_LOCAL;
      case navmiddleware::ROAD_CLASS__ADRESSABLESTREET:
         return NavigationSDSService::RoadClass__ROAD_CLASS_ADDRESSABLESTREET;
      case navmiddleware::ROAD_CLASS__TRAIL:
         return NavigationSDSService::RoadClass__ROAD_CLASS_TRAIL;
      default:
         ETG_TRACE_USR4(("Default case returning NavigationSDSService::RoadClass__ROAD_CLASS_NONE"));
         return NavigationSDSService::RoadClass__ROAD_CLASS_NONE;
   }
}


/* convert function for convertNDSDataAccessType*/
ENUM_CONVERT_START(convertNDSDataAccessType, NAVSERVICE_SDS::NdsDataAccessType, navmiddleware::NdsDataAccessType)
ENUM_CONVERT_ENTRY(NAVSERVICE_SDS::NdsDataAccessType__NDS_DATA_ACCESS_TYPE__NOT_SHARED, navmiddleware::NDS_DATA_ACCESS_TYPE__NOT_SHARED)
ENUM_CONVERT_ENTRY(NAVSERVICE_SDS::NdsDataAccessType__NDS_DATA_ACCESS_TYPE__SHARED, navmiddleware::NDS_DATA_ACCESS_TYPE__SHARED)
ENUM_CONVERT_ENTRY(NAVSERVICE_SDS::NdsDataAccessType__NDS_DATA_ACCESS_TYPE__UNKNOWN, navmiddleware::NDS_DATA_ACCESS_TYPE__UNKNOWN)
ENUM_CONVERT_END(navmiddleware::NDS_DATA_ACCESS_TYPE__UNKNOWN)

/* convert function for convertSharedDataAccess */
ENUM_CONVERT_START(convertSharedDataAccess, navmiddleware::SharedDataAccess, NAVSERVICE_SDS::SharedDataAccess)
ENUM_CONVERT_ENTRY(navmiddleware::SHARED_DATA_ACCESS__NOT_REQUIRED, NAVSERVICE_SDS::SharedDataAccess__SHARED_DATA_ACCESS__NOT_REQUIRED)
ENUM_CONVERT_ENTRY(navmiddleware::SHARED_DATA_ACCESS__REQUIRED, NAVSERVICE_SDS::SharedDataAccess__SHARED_DATA_ACCESS__REQUIRED)
ENUM_CONVERT_ENTRY(navmiddleware::SHARED_DATA_ACCESS__ENABLE, NAVSERVICE_SDS::SharedDataAccess__SHARED_DATA_ACCESS__ENABLE)
ENUM_CONVERT_ENTRY(navmiddleware::SHARED_DATA_ACCESS__UNKNOWN, NAVSERVICE_SDS::SharedDataAccess__SHARED_DATA_ACCESS__UNKNOWN)
ENUM_CONVERT_END(NAVSERVICE_SDS::SharedDataAccess__SHARED_DATA_ACCESS__UNKNOWN)

/* convert function for convertJournalingMode */
ENUM_CONVERT_START(convertJournalingMode, navmiddleware::JournalingMode, NAVSERVICE_SDS::JournalingMode)
ENUM_CONVERT_ENTRY(navmiddleware::JOURNALING_MODE__NONE, NAVSERVICE_SDS::JournalingMode__JOURNALING_MODE__NONE)
ENUM_CONVERT_ENTRY(navmiddleware::JOURNALING_MODE__WAL, NAVSERVICE_SDS::JournalingMode__JOURNALING_MODE__WAL)
ENUM_CONVERT_ENTRY(navmiddleware::JOURNALING_MODE__UNKNOWN, NAVSERVICE_SDS::JournalingMode__JOURNALING_MODE__UNKNOWN)
ENUM_CONVERT_END(NAVSERVICE_SDS::JournalingMode__JOURNALING_MODE__UNKNOWN)

/* convert function for convertLockType */
ENUM_CONVERT_START(convertLockType, navmiddleware::LockType, NAVSERVICE_SDS::LockType)
ENUM_CONVERT_ENTRY(navmiddleware::LOCK_TYPE__NONE, NAVSERVICE_SDS::LockType__LOCK_TYPE__NONE)
ENUM_CONVERT_ENTRY(navmiddleware::LOCK_TYPE__NORMAL, NAVSERVICE_SDS::LockType__LOCK_TYPE__NORMAL)
ENUM_CONVERT_ENTRY(navmiddleware::LOCK_TYPE__UNKNOWN, NAVSERVICE_SDS::LockType__LOCK_TYPE__UNKNOWN)
ENUM_CONVERT_END(NAVSERVICE_SDS::LockType__LOCK_TYPE__UNKNOWN)
/* convert function for SDSAddressElementTypeResult */
ENUM_CONVERT_START(convertSDSAddressElementType, navmiddleware::SDSAddressElementType, NAVSERVICE_SDS::SDSAddressElementType)
ENUM_CONVERT_ENTRY(navmiddleware::SDSADDRESSELEMENTTYPE_COUNTRY, NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_COUNTRY)
ENUM_CONVERT_ENTRY(navmiddleware::SDSADDRESSELEMENTTYPE_PLACE, NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_PLACE)
ENUM_CONVERT_ENTRY(navmiddleware::SDSADDRESSELEMENTTYPE_CROSSROAD, NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_CROSSROAD)
ENUM_CONVERT_ENTRY(navmiddleware::SDSADDRESSELEMENTTYPE_HOUSENUMBER, NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_HOUSENUMBER)
ENUM_CONVERT_ENTRY(navmiddleware::SDSADDRESSELEMENTTYPE_POSTALDISRICT, NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_POSTALDISTRICT)
ENUM_CONVERT_ENTRY(navmiddleware::SDSADDRESSELEMENTTYPE_CITYDISTRICT, NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_CITYDESTRICT)
ENUM_CONVERT_ENTRY(navmiddleware::SDSADDRESSELEMENTTYPE_PLACEREFINEMENT, NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_PLACEREFINEMENT)
ENUM_CONVERT_ENTRY(navmiddleware::SDSADDRESSELEMENTTYPE_ROADREFINEMENT, NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_ROADREFINEMENT)
ENUM_CONVERT_ENTRY(navmiddleware::SDSADDRESSELEMENTTYPE_STATE, NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_STATE)
ENUM_CONVERT_END(NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_COUNTRY)


/* convert function for SDSAddressElementTypeResult */
ENUM_CONVERT_START(convertSDSAddressElementType, NAVSERVICE_SDS::SDSAddressElementType, navmiddleware::SDSAddressElementType)
ENUM_CONVERT_ENTRY(NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_COUNTRY, navmiddleware::SDSADDRESSELEMENTTYPE_COUNTRY)
ENUM_CONVERT_ENTRY(NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_PLACE, navmiddleware::SDSADDRESSELEMENTTYPE_PLACE)
ENUM_CONVERT_ENTRY(NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_CROSSROAD, navmiddleware::SDSADDRESSELEMENTTYPE_CROSSROAD)
ENUM_CONVERT_ENTRY(NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_HOUSENUMBER, navmiddleware::SDSADDRESSELEMENTTYPE_HOUSENUMBER)
ENUM_CONVERT_ENTRY(NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_POSTALDISTRICT, navmiddleware::SDSADDRESSELEMENTTYPE_POSTALDISRICT)
ENUM_CONVERT_ENTRY(NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_CITYDESTRICT, navmiddleware::SDSADDRESSELEMENTTYPE_CITYDISTRICT)
ENUM_CONVERT_ENTRY(NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_PLACEREFINEMENT, navmiddleware::SDSADDRESSELEMENTTYPE_PLACEREFINEMENT)
ENUM_CONVERT_ENTRY(NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_ROADREFINEMENT, navmiddleware::SDSADDRESSELEMENTTYPE_ROADREFINEMENT)
ENUM_CONVERT_ENTRY(NAVSERVICE_SDS::SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_STATE, navmiddleware::SDSADDRESSELEMENTTYPE_STATE)
ENUM_CONVERT_END(navmiddleware::SDSADDRESSELEMENTTYPE_COUNTRY)

/* convert function for Jam ahead activity status */
ENUM_CONVERT_START(getJamAheadActivityStatus, navmiddleware::JamAheadListInfo::JamAheadActivityStatus, NAVSERVICE::JamAheadActivityStatus)
ENUM_CONVERT_ENTRY(navmiddleware::JamAheadListInfo::JAM_AHEAD_ACTIVITY_STATUS_INACTIVE, NAVSERVICE::JamAheadActivityStatus__INACTIVE)
ENUM_CONVERT_ENTRY(navmiddleware::JamAheadListInfo::JAM_AHEAD_ACTIVITY_STATUS_ACTIVE, NAVSERVICE::JamAheadActivityStatus__ACTIVE)
ENUM_CONVERT_ENTRY(navmiddleware::JamAheadListInfo::JAM_AHEAD_ACTIVITY_STATUS_NO_DETOUR_POSSIBLE, NAVSERVICE::JamAheadActivityStatus__NO_DETOUR_POSSIBLE)
ENUM_CONVERT_END(NAVSERVICE::JamAheadActivityStatus__NO_DETOUR_POSSIBLE)

/* convert fixed POI category */
ENUM_CONVERT_START(getFixedPOICategory, NAVSERVICE::FixedPOICategory, navmiddleware::PredefinedPoiCategory)
ENUM_CONVERT_ENTRY(NAVSERVICE::FixedPOICategory__UNDEFINED, navmiddleware::PREDEFINED_POI_CATEGORY__UNDEFINED)
ENUM_CONVERT_ENTRY(NAVSERVICE::FixedPOICategory__ATM, navmiddleware::PREDEFINED_POI_CATEGORY__ATM)
ENUM_CONVERT_ENTRY(NAVSERVICE::FixedPOICategory__EV_CHARGING_STATION, navmiddleware::PREDEFINED_POI_CATEGORY__EV_CHARGING_STATION)
ENUM_CONVERT_ENTRY(NAVSERVICE::FixedPOICategory__HOSPITAL, navmiddleware::PREDEFINED_POI_CATEGORY__HOSPITAL)
ENUM_CONVERT_ENTRY(NAVSERVICE::FixedPOICategory__HOTEL_MOTEL, navmiddleware::PREDEFINED_POI_CATEGORY__HOTEL_MOTEL)
ENUM_CONVERT_ENTRY(NAVSERVICE::FixedPOICategory__MOTORWAY_ENTRY, navmiddleware::PREDEFINED_POI_CATEGORY__MOTORWAY_ENTRY)
ENUM_CONVERT_ENTRY(NAVSERVICE::FixedPOICategory__MOTORWAY_EXIT, navmiddleware::PREDEFINED_POI_CATEGORY__MOTORWAY_EXIT)
ENUM_CONVERT_ENTRY(NAVSERVICE::FixedPOICategory__PARKING, navmiddleware::PREDEFINED_POI_CATEGORY__PARKING)
ENUM_CONVERT_ENTRY(NAVSERVICE::FixedPOICategory__PETROL_STATION, navmiddleware::PREDEFINED_POI_CATEGORY__PETROL_STATION)
ENUM_CONVERT_ENTRY(NAVSERVICE::FixedPOICategory__RESTAURANT, navmiddleware::PREDEFINED_POI_CATEGORY__RESTAURANT)
ENUM_CONVERT_ENTRY(NAVSERVICE::FixedPOICategory__VEHICLE_REPAIR, navmiddleware::PREDEFINED_POI_CATEGORY__VEHICLE_REPAIR)
ENUM_CONVERT_END(navmiddleware::PREDEFINED_POI_CATEGORY__VEHICLE_REPAIR)


/* convert function for NavigationDataUpdateResult */
ENUM_CONVERT_START(getMappedNavigationDataUpdateStatus, enNavDataUpdate_DiagFullUpdateResult, NavigationDataUpdateService::NavigationDataUpdateStatus)
ENUM_CONVERT_ENTRY(NAVDATAUPDATE__DIAG_RESULT__FAILED__NO_UPDATES_FOUND, NavigationDataUpdateService::NavigationDataUpdateStatus__FAILED__NO_UPDATES_FOUND)
ENUM_CONVERT_ENTRY(NAVDATAUPDATE__DIAG_RESULT__FAILED__INVALID_USB_DATA, NavigationDataUpdateService::NavigationDataUpdateStatus__FAILED__INVALID_USB_DATA)
ENUM_CONVERT_ENTRY(NAVDATAUPDATE__DIAG_RESULT__FAILED__OTHERS, NavigationDataUpdateService::NavigationDataUpdateStatus__FAILED__OTHERS)
ENUM_CONVERT_ENTRY(NAVDATAUPDATE__DIAG_RESULT__TIMEOUT__NO_USB, NavigationDataUpdateService::NavigationDataUpdateStatus__TIMEOUT__NO_USB)
ENUM_CONVERT_END(NavigationDataUpdateService::NavigationDataUpdateStatus__UNKNOWN)


/* convert funtion for NavigationDataUpdateStatus */
ENUM_CONVERT_START(getMappedNavigationDataUpdateStatus, navmiddleware::NavDataUpdateStatus::DataUpdateStatus, NavigationDataUpdateService::NavigationDataUpdateStatus)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__IDLE, NavigationDataUpdateService::NavigationDataUpdateStatus__IDLE)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__AVAILABLE_UPDATES_STARTED, NavigationDataUpdateService::NavigationDataUpdateStatus__AVAILABLE_UPDATES_STARTED)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__AVAILABLE_UPDATES_IN_PROGRESS, NavigationDataUpdateService::NavigationDataUpdateStatus__AVAILABLE_UPDATES_IN_PROGRESS)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__AVAILABLE_UPDATES_FINISHED, NavigationDataUpdateService::NavigationDataUpdateStatus__AVAILABLE_UPDATES_FINISHED)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__AVAILABLE_UPDATES_ABORTED_BY_ERROR, NavigationDataUpdateService::NavigationDataUpdateStatus__AVAILABLE_UPDATES_ABORTED_BY_ERROR)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__AVAILABLE_UPDATES_ABORTED_BY_USER, NavigationDataUpdateService::NavigationDataUpdateStatus__AVAILABLE_UPDATES_ABORTED_BY_USER)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__DOWNLOAD_STARTED, NavigationDataUpdateService::NavigationDataUpdateStatus__DOWNLOAD_STARTED)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__DOWNLOAD_IN_PROGRESS, NavigationDataUpdateService::NavigationDataUpdateStatus__DOWNLOAD_IN_PROGRESS)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__DOWNLOAD_STOPPED, NavigationDataUpdateService::NavigationDataUpdateStatus__DOWNLOAD_STOPPED)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__DOWNLOAD_FINISHED, NavigationDataUpdateService::NavigationDataUpdateStatus__DOWNLOAD_FINISHED)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__DOWNLOAD_ABORTED_BY_ERROR, NavigationDataUpdateService::NavigationDataUpdateStatus__DOWNLOAD_ABORTED_BY_ERROR)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__DOWNLOAD_ABORTED_BY_USER, NavigationDataUpdateService::NavigationDataUpdateStatus__DOWNLOAD_ABORTED_BY_USER)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__INSTALLATION_STARTED, NavigationDataUpdateService::NavigationDataUpdateStatus__INSTALLATION_STARTED)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__INSTALLATION_IN_PROGRESS, NavigationDataUpdateService::NavigationDataUpdateStatus__INSTALLATION_IN_PROGRESS)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__INSTALLATION_STOPPED, NavigationDataUpdateService::NavigationDataUpdateStatus__INSTALLATION_STOPPED)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__INSTALLATION_FINISHED, NavigationDataUpdateService::NavigationDataUpdateStatus__INSTALLATION_FINISHED)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__INSTALLATION_ABORTED_BY_USER, NavigationDataUpdateService::NavigationDataUpdateStatus__INSTALLATION_ABORTED_BY_USER)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__UPDATE_ABORTED_BY_USER, NavigationDataUpdateService::NavigationDataUpdateStatus__UPDATE_ABORTED_BY_USER)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__DOWNLOAD_UPDATE_SUCCESSFULLY_FINISHED, NavigationDataUpdateService::NavigationDataUpdateStatus__DOWNLOAD_UPDATE_SUCCESSFULLY_FINISHED)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__USB_REMOVED, NavigationDataUpdateService::NavigationDataUpdateStatus__USB_REMOVED)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__UPDATE_SOURCE_ERROR, NavigationDataUpdateService::NavigationDataUpdateStatus__UPDATE_SOURCE_ERROR)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__FULL_UPDATE_REQUIRED, NavigationDataUpdateService::NavigationDataUpdateStatus__FULL_UPDATE_REQUIRED)
ENUM_CONVERT_ENTRY(navmiddleware::NavDataUpdateStatus::DATAUPDATESTATUS__UNKNOWN, NavigationDataUpdateService::NavigationDataUpdateStatus__UNKNOWN)
ENUM_CONVERT_END(NavigationDataUpdateService::NavigationDataUpdateStatus__UNKNOWN)

/* convert AddressDetailInfo */
ENUM_CONVERT_START(getDestinationMemoryAddressType, navmiddleware::LocationAttributeInfos::AddressDetailInfo::AddressInfoType, NAVSERVICE::DestinationMemoryAddressType)
ENUM_CONVERT_ENTRY(navmiddleware::LocationAttributeInfos::AddressDetailInfo::ADDRESS_INFO_TYPE__COUNTRY_NAME, NAVSERVICE::DestinationMemoryAddressType__DESTINATION_MEMORY_COUNTRY)
ENUM_CONVERT_ENTRY(navmiddleware::LocationAttributeInfos::AddressDetailInfo::ADDRESS_INFO_TYPE__COUNTRY_CODE, NAVSERVICE::DestinationMemoryAddressType__DESTINATION_MEMORY_COUNTRY_CODE)
ENUM_CONVERT_ENTRY(navmiddleware::LocationAttributeInfos::AddressDetailInfo::ADDRESS_INFO_TYPE__STATE_NAME, NAVSERVICE::DestinationMemoryAddressType__DESTINATION_MEMORY_STATE)
ENUM_CONVERT_ENTRY(navmiddleware::LocationAttributeInfos::AddressDetailInfo::ADDRESS_INFO_TYPE__CITY_NAME, NAVSERVICE::DestinationMemoryAddressType__DESTINATION_MEMORY_CITY)
ENUM_CONVERT_ENTRY(navmiddleware::LocationAttributeInfos::AddressDetailInfo::ADDRESS_INFO_TYPE__STREET_NAME, NAVSERVICE::DestinationMemoryAddressType__DESTINATION_MEMORY_STREET)
ENUM_CONVERT_ENTRY(navmiddleware::LocationAttributeInfos::AddressDetailInfo::ADDRESS_INFO_TYPE__HOUSE_NUMBER, NAVSERVICE::DestinationMemoryAddressType__DESTINATION_MEMORY_HOUSENO)
ENUM_CONVERT_ENTRY(navmiddleware::LocationAttributeInfos::AddressDetailInfo::ADDRESS_INFO_TYPE__CROSS_STREET_NAME, NAVSERVICE::DestinationMemoryAddressType__DESTINATION_MEMORY_JUNCTION)
ENUM_CONVERT_ENTRY(navmiddleware::LocationAttributeInfos::AddressDetailInfo::ADDRESS_INFO_TYPE__FULL_ADDRESS, NAVSERVICE::DestinationMemoryAddressType__DESTINATION_MEMORY_ADDRESS_DETAIL)
ENUM_CONVERT_END(NAVSERVICE::DestinationMemoryAddressType__DESTINATION_MEMORY_COUNTRY)
#endif // (defined(HALL_NAVIGATION_SERVICE) || defined(HALL_NAVIGATION_SDS_SERVICE) || defined(HALL_NAVIGATION_DATAUPDATE_SERVICE))
