/**************************************************************************************
* @file         : HMIModelNavigationService.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#if !defined(_HMI_MODEL_NAVIGATION_SERVICE_H)
#define _HMI_MODEL_NAVIGATION_SERVICE_H

#include "Common/Util/HMIModelIncludes.h"

#if defined(HALL_TO_MDW_COM)
#if defined(HALL_NAVIGATION_SERVICE)

#include "org/bosch/cm/navigation/NavigationServiceStub.h"

#include "HMIModelNavigationServiceExtended.h"

/**
 * HMIModelNavigationService provides the dbus service for the navigation
 */
class HMIModelNavigationService : public HMIModelBase, public org::bosch::cm::navigation::NavigationService::NavigationServiceStub
{
   public:
      HMIModelNavigationService(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~HMIModelNavigationService();

      virtual void initialize();
      virtual void deinitialize();
      virtual void recoverNavData();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::POSITION_INFO_CHANGED, onPropertyUpdatePositionInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_STATE_CHANGED, onPropertyUpdateGuidanceStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_MANEUVERINFOS_CHANGED, onPropertyUpdateManeuverInfosChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_ARRIVALINFOS_CHANGED, onPropertyUpdateGuidanceArrivalInfosChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::POSITION_STATUS_CHANGED, onPropertyPositionStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::POSITION_SENSORINFO_CHANGED, onPropertySensorInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_DESTINATIONS_CHANGED, onPropertyRouteDestinationChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_SDS_ADDRESS_WITH_OPTIONS_CHANGED, onPropertySdsAddressWithOptionsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_PRESENTATION_MODE_CHANGED, onPropertyMapPresentatioanModeChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_FREE_TEXT_SEARCH_RESULTS_CHANGED, onPropertyUpdateLocationFreeTextSearchResultsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_ADDR_BOOK_LIST_CHANGED, onPropertyUpdateDestinationMemoryAddBookListChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_PERSONAL_EPOI_LIST_CHANGED, onPropertyUpdateDestinationMemoryPersonalEPOIListChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_LAST_DESTINATION_LIST_CHANGED, onPropertyUpdateDestinationMemoryLastDestListChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_LAST_DESTINATION_LIST_STATUS_CHANGED, onPropertyUpdateDestinationMemoryLastDestStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_ADDRESSBOOK_STATUS_CHANGED, onPropertyDestinationMemoryAddBookStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_MANEUVERVIEW_CHANGED, onPropertyUpdateManeuverViewChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_WAYPOINTINFOS_CHANGED, onPropertyUpdateRouteGuidancWaypointInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_WAYPOINT_SKIPPED, onPropertyUpdateGuidanceWaypointSkipped)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_STARTED_ON_PLANNED_ROUTE, onPropertyUpdateGuidanceStartedOnPlannedRoute)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_SPEEDLIMIT_CHANGED, onPropertyUpdateSpeedLimitChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_SDS_ELEMENTS_CHANGED, onPropertyUpdateSdsElementsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_INTERSECTION_MAP_VECTOR_DATA_CHANGED, onPropertyUpdateInterSectionMapVectorDataChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_COORDINATE_RESOLVED, onPropertyUpdateLocationCoordinateChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_CALCULATION_INFO_CHANGED, onPropertyUpdateRouteCalculationInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_STATUS_CHANGED, onPropertyRouteStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_HOME_LIST_CHANGED, onPropertyUpdateDestinationMemoryHomeLocationListChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_WORK_LIST_CHANGED, onPropertyUpdateDestinationMemoryWorkLocationListChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_HOME_ENTRY_REMOVED, onPropertyUpdateHomeLocationDeleted)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_WORK_ENTRY_REMOVED, onPropertyUpdateWorkLocationDeleted)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_COMPATIBILITY_CHANGED, onPropertyUpdateNavDataUpdateCompatibilityChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_SDS_PATTERNS_CHANGED, onPropertyUpdateSdsHouseNumberPatternsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_STORE_ENTRY_STATUS_CHANGED, onPropertyUpdateDestinationMemoryStoreEntryStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_ENTRY_DETAILS_AVAILABLE, onPropertyUpdateDestinationMemoryLocationAddressStored)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::TRAFFICMESSAGE_INFO_LIST_CHANGED, onPropertyUpdateTrafficMessageInfoListChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_SETTINGS_CHANGED, onPropertyUpdateGuidanceSettingsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_ATTRIBUTES_AVAILABLE, onPropertyUpdateLocationAttributesAvailable)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::TRAFFICMESSAGE_RECEPTION_STATUS_CHANGED, onPropertyUpdateTrafficMessagesReceptionStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_VERSION_INFO_CHANGED, onPropertyUpdateNavDataVersionInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_POI_SHORTCUT_INFORMATION_UPDATED, onPropertyUpdateLocationPoiShortcutInformationChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_INTERSECTION_MAP_CARSOR_POSITION_CHANGED, onPropertyUpdateMapIntersectionMapCarsorPositionChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::POSITION_TRIP_REPLAY_STATUS_CHANGED, onPropertyUpdateTripReplayStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LIFECYCLE_NAVDATAUPDATE_STARTED, onPropertyUpdateNavDataUpdateStarted)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LIFECYCLE_NAVDATAUPDATE_FINISHED, onPropertyUpdateNavDataUpdateFinished)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_CALCULATION_STARTED, onPropertyUpdateRouteCalculationStarted)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_SET_MAP_CAMERA_AND_VIEW_MODES_DONE, onPropertyUpdateMapCameraAndViewModesDoneChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::TRAFFICMESSAGE_SETTINGS_CHANGED, onPropertyUpdateTrafficMessageSettingChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ETC_INTERRUPT_OCCURED, onPropertyUpdateEtcInterruptOccured)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ETC_USAGE_DATA_HISTORY_LIST_STATUS_CHANGED, onPropertyUpdateEtcUsageDataHistoryListStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ETC_SETTINGS_CHANGED, onPropertyUpdateEtcSettingsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::VICS_SOURCES_CHANGED, onPropertyVicsSourcesChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_ADDRESS_INFOS_BASED_ON_POSITION_CHANGED, onPropertyLocationAddressInfosOnPositionChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_BASED_SERVICES_SETTINGS_CHANGED, onPropertyLocationBasedServicesSettingsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::POSITION_HOME_POSITION_STATUS_CHANGED, onPropertyHomePositionStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_EV_BATTERY_STATUS_WARNING_SETTINGS_CHANGED, onPropertyEVBatteryStatusWarningSettingsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_JAMAHEADINFO_CHANGED, onPropertyJamAheadInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_POI_ENTRIES_CHANGED, onPropertyPOIEntriesChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_POI_INPUT_INFO_CHANGED, onPropertyPOIInputInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_DESTINATION_REACHED, onPropertyGuidanceDestinationReached)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_CAMERAINFOS_CHANGED, onPropertyUpdateMapCameraInfosChanged)

      PROPERTY_UPDATE_MIDDLEWARE_END()

      bool onPropertyUpdateRouteCalculationStarted();
      bool onPropertyUpdateNavDataUpdateFinished();
      bool onPropertyUpdateNavDataUpdateStarted();
      bool onPropertyUpdatePositionInfoChanged();
      bool onPropertyUpdateManeuverInfosChanged();
      bool onPropertyUpdateGuidanceArrivalInfosChanged();
      bool onPropertyPositionStatusChanged();
      bool onPropertyUpdateGuidanceStatusChanged();
      bool onPropertySensorInfoChanged();
      bool onPropertyRouteDestinationChanged();
      bool onPropertySdsAddressWithOptionsChanged();
      bool onPropertyMapPresentatioanModeChanged();
      bool onPropertyUpdateLocationFreeTextSearchResultsChanged();
      bool onPropertyUpdateDestinationMemoryAddBookListChanged();
      bool onPropertyUpdateDestinationMemoryPersonalEPOIListChanged();
      bool onPropertyUpdateDestinationMemoryLastDestListChanged();
      bool onPropertyUpdateManeuverViewChanged();
      bool onPropertyUpdateRouteGuidancWaypointInfoChanged();
      bool onPropertyUpdateGuidanceWaypointSkipped();
      bool onPropertyUpdateGuidanceStartedOnPlannedRoute();
      bool onPropertyUpdateSpeedLimitChanged();
      bool onPropertyUpdateInterSectionMapVectorDataChanged();
      bool onPropertyUpdateSdsElementsChanged();
      bool onPropertyUpdateDestinationMemoryHomeLocationListChanged();
      bool onPropertyUpdateLocationCoordinateChanged();
      bool onPropertyUpdateDestinationMemoryWorkLocationListChanged();
      bool onPropertyUpdateHomeLocationDeleted();
      bool onPropertyUpdateWorkLocationDeleted();
      bool onPropertyUpdateNavDataUpdateCompatibilityChanged();
      bool onPropertyRouteStatusChanged();
      bool onPropertyUpdateRouteCalculationInfoChanged();
      bool onPropertyUpdateSdsHouseNumberPatternsChanged();
      bool onPropertyUpdateDestinationMemoryLastDestStatusChanged();
      bool onPropertyDestinationMemoryAddBookStatusChanged();
      bool onPropertyUpdateDestinationMemoryStoreEntryStatusChanged();
      bool onPropertyUpdateDestinationMemoryLocationAddressStored();
      bool onPropertyUpdateTrafficMessageSettingChanged();
      bool onPropertyUpdateTrafficMessageInfoListChanged();
      bool onPropertyUpdateGuidanceSettingsChanged();
      bool onPropertyUpdateLocationAttributesAvailable();
      bool onPropertyUpdateTrafficMessagesReceptionStatusChanged();
      bool onPropertyUpdateNavDataVersionInfoChanged();
      bool onPropertyUpdateLocationPoiShortcutInformationChanged();
      bool onPropertyUpdateMapIntersectionMapCarsorPositionChanged();
      bool onPropertyUpdateMapCameraAndViewModesDoneChanged();
      bool onPropertyUpdateTripReplayStatusChanged();
      void onPropertyUpdateEtcInterruptOccured();
      void onPropertyUpdateEtcUsageDataHistoryListStatusChanged();
      void onPropertyUpdateEtcSettingsChanged();
      bool onPropertyUpdateSettingsLowBatteryWarningActive();
      void onPropertyVicsSourcesChanged();
      void onPropertyLocationAddressInfosOnPositionChanged();
      void onPropertyLocationBasedServicesSettingsChanged();
      void onPropertyHomePositionStatusChanged();
      void onPropertyEVBatteryStatusWarningSettingsChanged();
      void onPropertyJamAheadInfoChanged();
      void onPropertyPOIEntriesChanged();
      void onPropertyPOIInputInfoChanged();
      void onPropertyGuidanceDestinationReached();
      bool onPropertyUpdateMapCameraInfosChanged();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_ESTIMATED_TIME_TYPE_MODE_CHANGED, onPropertyUpdateSettingsEstimatedTimeTypeChanged)
      PROPERTY_UPDATE_INFOSTORE_END()

      bool onPropertyUpdateSettingsEstimatedTimeTypeChanged();
      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ShowCityInputAndGetCityAddressResponseReqMsg)
      ON_COURIER_MESSAGE(StartCalculateTourReqMsg)
      ON_COURIER_MESSAGE(UpdateRouteCriteriaReqMsg)
      ON_COURIER_MESSAGE(EnteredMapScreenReqMsg)
      ON_COURIER_MESSAGE(VoiceTagOptionsMsg)
      ON_COURIER_MESSAGE(AddressGadgetItemSelectedMsg)
      COURIER_CASE_DUMMY_ENTRY()
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_REF(_hmiModelNavigationServiceExtended)
      COURIER_MSG_MAP_DELEGATE_END()

      // Incoming requests from navigation service
      virtual void onGetVersionStringRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::GetVersionStringRequest >& /*request*/);
      virtual void onStartGuidanceToPosWGS84Request(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceToPosWGS84Request >& request);
      virtual void onShowPOILocationFromTCURequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowPOILocationFromTCURequest>& request);
      virtual void onShowCalculateTourRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowCalculateTourRequest>& /*request*/);
      virtual void onShowDestinationOverviewFromTCURequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowDestinationOverviewFromTCURequest>& /*request*/);
      virtual void onShowOnMapRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowOnMapRequest>& request);
      virtual void onSetZoomOutStepRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetZoomOutStepRequest>& request);
      virtual void onSetZoomInStepRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetZoomInStepRequest>& request);
      virtual void onStartGuidanceRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::StartGuidanceRequest>& /*request*/);
      virtual void onSetLocationWithSdsInputRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetLocationWithSdsInputRequest>& /*request*/);
      virtual void onSdsCheckAddressRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SdsCheckAddressRequest>& request);
      virtual void onSdsGetRefinementListRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsGetRefinementListRequest >& request);
      virtual void onSelectSdsRefinementRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SelectSdsRefinementRequest>& /*request*/);
      virtual void onShowCityInputAndGetCityCoordinatesRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowCityInputAndGetCityCoordinatesRequest>& request);

      virtual void onStartGuidanceToHomeLocationRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::StartGuidanceToHomeLocationRequest>& /*request*/);
      virtual void onStartGuidanceToWorkLocationRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::StartGuidanceToWorkLocationRequest>& /*request*/);
      virtual void onShowWhereAmIScreenRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowWhereAmIScreenRequest>& /*request*/);
      virtual void onShowRouteCalculationToDestinationRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowRouteCalculationToDestinationRequest>& request);

      virtual void onInsertWaypointRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::InsertWaypointRequest>& request);
      virtual void onInsertWaypointAtDefaultPositionRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::InsertWaypointAtDefaultPositionRequest >& /*request*/);
      virtual void onApplyWaypointListChangeRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::ApplyWaypointListChangeRequest >& /*request*/);
      virtual void onReplaceWaypointRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ReplaceWaypointRequest>& request);
      virtual void onDeleteWaypointsRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::DeleteWaypointsRequest>& request);
      virtual void onSetRouteCriterionRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetRouteCriterionRequest>& request);

      virtual void onActivateNonPremiumTMCRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ActivateNonPremiumTMCRequest>& /*request*/);
      virtual void onDeactivateNonPremiumTMCRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::DeactivateNonPremiumTMCRequest>& /*request*/);

      virtual void onShowDestinationFreeTextSearchInputRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowDestinationFreeTextSearchInputRequest>& request);
      virtual void onRequestSetFreeTextSearchTypeRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::RequestSetFreeTextSearchTypeRequest>& request);
      virtual void onRequestFreeTextSearchResultsRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsRequest>& request);
      virtual void onSetLocationWithFreeTextSearchInputRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetLocationWithFreeTextSearchInputRequest>& /*request*/);

      virtual void onSetLocationWithDestinationMemoryEntryRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetLocationWithDestinationMemoryEntryRequest>& request);
      virtual void onSetMapRepresentationRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetMapRepresentationRequest>& request);
      virtual void onRetriggerAcousticOutputRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::RetriggerAcousticOutputRequest>& /*request*/);
      virtual void onSetVoiceGuidanceRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetVoiceGuidanceRequest>& request);
      virtual void onShowAdjustCurrentLocationScreenRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowAdjustCurrentLocationScreenRequest>& /*request*/);
      virtual void onShowDeleteWaypointListScreenRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowDeleteWaypointListScreenRequest>& /*request*/);
      virtual void onShowCarsorLocationOnMapRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowCarsorLocationOnMapRequest>& /*request*/);
      virtual void onShowMapScreenWithMapViewModeRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowMapScreenWithMapViewModeRequest>& request);
      virtual void onCancelRouteGuidanceRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::CancelRouteGuidanceRequest>& request);
      virtual void onRequestWaypointListRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::RequestWaypointListRequest>& /*request*/);
      virtual void onSetZoomLevelRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetZoomLevelRequest>& request);
      virtual void onShowMapScreenCarsorLockModeRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowMapScreenCarsorLockModeRequest>& /*request*/);
      virtual void onCheckNavDataCompatibilityRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::CheckNavDataCompatibilityRequest>& request);
      virtual void onRequestLocationDetailsForCoordinatesRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::RequestLocationDetailsForCoordinatesRequest>& request);
      virtual void onRequestDetailsForSelectedCoordinateWithRadiusRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedCoordinateWithRadiusRequest >& request);
      virtual void onSelectPoiCategoryShortcutRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SelectPoiCategoryShortcutRequest>& request);
      virtual void onGetPoiCategoryShortcutsRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::GetPoiCategoryShortcutsRequest>& request);
      virtual void onSetLocationWithCoordinatesRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetLocationWithCoordinatesRequest>& request);
      virtual void onSdsGetHouseNumberPatternRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SdsGetHouseNumberPatternRequest>& request);
      virtual void onSdsUpdateVoiceTagRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SdsUpdateVoiceTagRequest>& request);
      virtual void onRequestDestinationMemoryEntriesRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::RequestDestinationMemoryEntriesRequest>& request);
      virtual void onStorePOILocationToAddressBookRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::StorePOILocationToAddressBookRequest>& request);
      virtual void onStoreLocationToAddressBookRequest(const ::boost::shared_ptr<org::bosch::cm::navigation::NavigationService::StoreLocationToAddressBookRequest >& request);
      virtual void onRequestDetailsForSelectedLocationRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationRequest>& request);
      virtual void onShowTrafficInfoScreenRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowTrafficInfoScreenRequest>& /*request*/);
      virtual void onSetSXMTravelLinkSubscriptionStatusRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetSXMTravelLinkSubscriptionStatusRequest>& request);
      virtual void onSetLocationWithDetailsRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetLocationWithDetailsRequest>& request);
      virtual void onSpeakSamplePhraseRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SpeakSamplePhraseRequest>& request);
      virtual void onStartTripReplayRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::StartTripReplayRequest>& request);
      virtual void onUndoFreeTextSearchElementSelectionRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::UndoFreeTextSearchElementSelectionRequest>& /*request*/);
      virtual void onStopTripReplayRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::StopTripReplayRequest>& /*request*/);
      virtual void onSeekTripReplayRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SeekTripReplayRequest>& request);
      virtual void onSetTripReplayModeRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetTripReplayModeRequest>& request);
      virtual void onSetMapLightModeRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetMapLightModeRequest>& request);
      virtual void onShowLocationSelectionAndGetAddressDetailsRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowLocationSelectionAndGetAddressDetailsRequest>& request);
      virtual void onRequestJamAheadListRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::RequestJamAheadListRequest>& request);
      virtual void onRequestFixedPOICategorySearchResultsRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::RequestFixedPOICategorySearchResultsRequest>& /*request*/);
      virtual void onUndoSetLocationWithFixedPOICategoryInputRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::UndoSetLocationWithFixedPOICategoryInputRequest>& /*request*/);
      virtual void onSetLocationWithFixedPOICategoryInputRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SetLocationWithFixedPOICategoryInputRequest>& /*request*/);
      virtual void onSelectJamAheadListEntryRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::SelectJamAheadListEntryRequest>& request);
      virtual void onReleaseJamAheadListRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ReleaseJamAheadListRequest>& /*request*/);
      virtual void onCancelJamAheadRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::CancelJamAheadRequest>& /*request*/);
      virtual void onShowAndSetLocationWithDetailsRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationService::ShowAndSetLocationWithDetailsRequest>& request);

      bool onCourierMessage(const ShowCityInputAndGetCityAddressResponseReqMsg& oMsg);
      bool onCourierMessage(const StartCalculateTourReqMsg& /*oMsg*/);
      bool onCourierMessage(const UpdateRouteCriteriaReqMsg& oMsg);
      bool onCourierMessage(const EnteredMapScreenReqMsg& /*oMsg*/);
      bool onCourierMessage(const VoiceTagOptionsMsg& oMsg);
      bool onCourierMessage(const AddressGadgetItemSelectedMsg& oMsg);

      /*Function to send all the necessary navigation settings to AppHmi_Vehicle at initialization*/
      void updateNavigationSettingsToOtherApps();
      struct SavePoiDetails
      {
         ::std::string poiName;
         ::std::string address;
         std::vector< ::std::string > phoneNumber;
      };

   private:
      HMIModelNavigationServiceExtended _hmiModelNavigationServiceExtended;
      // type conversion helper
      ::org::bosch::cm::navigation::NavigationService::SDSAddressElementType convertSDSAddressElementType(navmiddleware::SDSAddressElementType middlSDSAddressElementType);
      navmiddleware::SDSAddressElementType convertSDSAddressElementType(::org::bosch::cm::navigation::NavigationService::SDSAddressElementType serviceSDSAddressElementType);
      ::navmiddleware::settings::RouteCriterion convertRouteCriterion(::org::bosch::cm::navigation::NavigationService::RouteCriterion routeCriterion);
      ::org::bosch::cm::navigation::NavigationService::RouteCriterion convertRouteCriterion(::navmiddleware::settings::RouteCriterion routeCriterion);
      ::org::bosch::cm::navigation::NavigationService::DeformedImageRoadType convertDeformedImageRoadType(navmiddleware::DeformedImageRoadType deformedImageRoadType);
      ::org::bosch::cm::navigation::NavigationService::DeformedImageArrowType convertDeformedImageArrowType(navmiddleware::DeformedImageArrowType deformedImageArrowType);
      ::org::bosch::cm::navigation::NavigationService::ManeuverViewType convertManeuverViewType(navmiddleware::ManeuverViewType maneuverViewType);
      ::org::bosch::cm::navigation::NavigationService::DistanceUnit convertDistanceUnit(navmiddleware::DistanceUnit distanceUnit);
      ::org::bosch::cm::navigation::NavigationService::ManeuverRecommendationType convertManeuverRecommendationType(navmiddleware::RecommendationType recommendationType);
      ::org::bosch::cm::navigation::NavigationService::LaneStatus convertLaneStatus(navmiddleware::LaneStatus laneStatus);
      ::org::bosch::cm::navigation::NavigationService::RoadClass convertRoadClass(navmiddleware::RoadClass roadClass);
      navmiddleware::MapRepresentation convertMapRepresentation(::org::bosch::cm::navigation::NavigationService::MapRepresentation mapRepresentation);
      ::org::bosch::cm::navigation::NavigationService::MapRepresentation convertMapRepresentation(navmiddleware::MapRepresentation mapRepresentation);
      navmiddleware::FreeTextSearchType convertFreeTextSearchLocationType(org::bosch::cm::navigation::NavigationService::FTSLocationType locationType);
      navmiddleware::LocationSearchScope::Type convertFreeTextSearchScope(org::bosch::cm::navigation::NavigationService::FreeTextSearchScope freeTextSearchScope);
      ::org::bosch::cm::navigation::NavigationService::SpeedUnit convertSpeedUnit(navmiddleware::SpeedUnit speedUnit);
      ::org::bosch::cm::navigation::NavigationService::NavDataCompatibility convertNavDataCompatibilityType(navmiddleware::NavDataCompatibilityInfo::CompatibilityState compatibilityState);
      ::org::bosch::cm::navigation::NavigationService::DirectionDescription convertDirectionDescription(navmiddleware::DirectionDescription direction);
      ::org::bosch::cm::navigation::NavigationService::TrafficReceptionState convertTrafficReceptionState(navmiddleware::TrafficReceptionState trafficReceptionState);
      ::org::bosch::cm::navigation::NavigationService::IntersectionMapCarsorState convertMapCarsorState(navmiddleware::IntersectionMapCarsorPosition::CarsorState carsorState);
      ::org::bosch::cm::navigation::NavigationService::TrafficMessageSource convertTrafficMessageSource(navmiddleware::TrafficMessageSource trafficMessageSource);

      void updateRouteCriteria(navmiddleware::settings::RouteCriterion routeCriterion);
      void updatePositionInformation();
      void updateLocationDetails(const navmiddleware::LocationAttributeInfos& locationAttributeInfos, ::org::bosch::cm::navigation::NavigationService::LocationDetails& locationDetails);
      void updateLocationPoiShortcutInformation(navmiddleware::LocationContext::HmiContext hmiContext);
      void updateGuidanceArrivalInformation();
      void showLocationSelectionAndGetAddressDetailsCallback();
      void showMapMain();
      void updateEtcStatusFromInterrupt(bool forceInitialValue = false);
      bool updateLocationDetailsFromMap(const navmiddleware::LocationAttributeInfos::AddressDetailInfo*   addressDetailInfos, ::org::bosch::cm::navigation::NavigationService::LocationDetails& locationDetail);
      void setEtcStatusWithCheck(org::bosch::cm::navigation::NavigationService::ETCStatus status, bool isEtcIconDisplayEnabled);
      void updateEtcStatusFromVicsSourcesChanged();
      void updateLocationSearchResult(const navmiddleware::LocationInfos& locationInfos);
      void setLocationDetails(const org::bosch::cm::navigation::NavigationService::POILocation& poiLocation);
      void applyNonPremiumTMCStatus(bool nonPremiumTMCStatus);
      void constructDestinationMemoryEntries(::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryDetailListElement>& destinationMemoryDetailListElements);
      void updateToDestinationMemoryItemList(const navmiddleware::LocationAttributeInfos::AddressDetailInfo* addressDetailInfo,
                                             const navmiddleware::LocationAttributeInfos& locationAttributes,
                                             ::std::vector< ::org::bosch::cm::navigation::NavigationService::DestinationMemoryEntryItem >& destinationMemoryEntryItemList);

      act_t _cityAddressRequestAct;
      act_t _sdsCheckAddressRequestAct;
      act_t _selectSdsRefinementAct;
      act_t _freeTextSearchResultAct;
      act_t _getAdressbookDestinationAct;
      act_t _getLastDestinationAct;
      act_t _getPersonalEPOIAct;
      act_t _getSdsGetRefinementListAct;
      act_t _getRequestCityNameAct;
      act_t _getNavDataCompatibilityAct;
      act_t _showLocationSelectionAndGetAddressAct;
      act_t _getHouseNumberPatternAct;
      act_t _getDeleteWaypointAct;
      act_t _storePOILocationToAddressBookAct;
      act_t _storeLocationToAddressBookAct;
      act_t _getRequestLocationAttributesAct;
      act_t _requestDetailsForSelectedCoordinateWithRadiusRequestAct;
      act_t _getJamAheadListAct;
      act_t _getFixedPOICategorySearchAct;
      act_t _getSetLocationWithFixedPOICategoryInputAct;
      act_t _getShowAndSetLocationWithDetailsAct;
      act_t _startTourCalculationAct;

      org::bosch::cm::navigation::NavigationService::RouteCriterion _routeCriterion;
      int _deleteWaypointCount;
      int _deleteWaypointStartIndex;
      int _zoomLevelSteps;
      int32_t _zoomToStreetScaleLevel;
      bool _isZoomOutPending;
      bool _isZoomInPending;
      bool _isZoomStreetPending;
      bool _isAdjustCurrentLocationPending;
      bool _isCancelRouteGuidancePending;
      SavePoiDetails _savePoiDetails;
      org::bosch::cm::navigation::NavigationService::FTSLocationType _ftsLocationType;
      // Maintains the true state of ETC. ETC Settings control how ETC icon is displayed,
      // so _etcStatusCache is not always communicated outside.
      org::bosch::cm::navigation::NavigationService::ETCStatus _etcStatusCache;
      bool _isVicsSourceDsrcConnected;

      //::std::vector< uint32 > _weatherRequestIds;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(HMIModelNavigationService);
};


#else // HALL_NAVIGATION_SERVICE

class HMIModelNavigationService : public HMIModelBase
{
   public:
      HMIModelNavigationService(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore) : HMIModelBase(navMiddleware, infoStore) {}
      virtual ~HMIModelNavigationService() {};

      virtual void initialize() {};
      virtual void deinitialize() {};

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
#pragma warning(disable : 4065)
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_CASE_DUMMY_ENTRY() // LINT Info 764
      COURIER_MSG_MAP_END()

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(HMIModelNavigationService);
};


#endif // HALL_NAVIGATION_SERVICE
#endif // HALL_TO_MDW_COM
#endif // _HMI_MODEL_NAVIGATION_SERVICE_H
