/* ***************************************************************************************
* FILE:          AddressDetailedInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AddressDetailedInfo.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) -2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_ADDRESS_DETAILED_INFO_H)
#define _ADDRESS_DETAILED_INFO_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "List/Data/ListDataProviderDistributor.h"
#include "ListRegistry.h"
#include "Candera/System/MemoryManagement/SharedPointer.h"
#include "NavMiddleware.h"
#include "../Common/Util/HMIModelDefines.h"
#include "../Common/Util/NavMiddlewareUtils.h"
#include "../Common/Util/StaticListHandlerBase.h"
#include "../Common/Util/HMIModelIncludes.h"


class AddressDetailedInfo : public HMIModelBase
{
   public:

      AddressDetailedInfo(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~AddressDetailedInfo();

      virtual void initialize();
      virtual void deinitialize();

      static AddressDetailedInfo* getInstance();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_ATTRIBUTES_ERROR, onPropertyUpdateLocationAttributesError)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_ATTRIBUTES_AVAILABLE, onPropertyUpdateLocationAttributesAvailable)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_BT_ACTIVE_DEVICE_CHANGED, updateCallButtonState);
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ShowDetailedAddressMsg)
      ON_COURIER_MESSAGE(ResetDetailedAddressMsg)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(ShowFavEditIcon_Enable_Delete_Guidance_Buttons)
      ON_COURIER_MESSAGE(UpdateDeletePopupTextReqMsg)
      COURIER_MSG_MAP_END()

      void onPropertyUpdateLocationAttributesError();
      void onPropertyUpdateLocationAttributesAvailable();

      bool onCourierMessage(const ShowDetailedAddressMsg& oMsg);
      bool onCourierMessage(const ResetDetailedAddressMsg& oMsg);
      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const ShowFavEditIcon_Enable_Delete_Guidance_Buttons& oMsg);
      bool onCourierMessage(const UpdateDeletePopupTextReqMsg& oMsg);
      void UpdateEditFavIcon(Courier::UInt32 EditIcon);
      void FillAddressDetailedinfo(const navmiddleware::LocationAttributeInfos& infos);

   private:
      bool updateCallButtonState();

      enum HierarchyLevel
      {
         LEVEL_ONE,
         LEVEL_TWO,
         LEVEL_THREE
      };

      static AddressDetailedInfo* poSelf;

      DataBindingItem<PlaceInfoDetailsDataBindingSource> _placeInfoDetailsData;
      DataBindingItem<AddressDetailedInfoIconDataBindingSource> _favEditIcon_DeleteBtn;
      DataBindingItem<TwoLinePopuptextDataBindingSource> _PopupText;
      DataBindingItem<ThreeLinePopuptextDataBindingSource> _threeLinePopupText;
      DataBindingItem<EnableGuidanceButtonDataBindingSource> _enableGuidanceButtonVisibility;
      DataBindingItem<EnablePhoneButtonDataBindingSource> _enablePhoneButtonVisibility;
      DataBindingItem<MultiLinePopupTextDataBindingSource> _multiLinePopupText;
      DataBindingItem<EnableSetLatLongButtonDataBindingSource> _enableSetLatLongButton; // Fix for RTC-1002020 : To Disable setlatlong button in N_LatLongInput till callbacks are received
};


#endif
