/**************************************************************************************
* @file         : VehicleDimmingClientHandler.cpp
* @author       : CMC HMI Team
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <hmibase/hall_std_if.h>
#include "VehicleDimmingClientHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_NAVIGATION
#define ETG_I_TTFIS_CMD_PREFIX "APPHMI_NAVIGATION_"
#define ETG_I_FILE_PREFIX App::Core::VehicleDimmingClientHandler::
#include "trcGenProj/Header/VehicleDimmingClientHandler.cpp.trc.h"
#endif

#define T_e8_DIM_Mode__Night_Auto 4   //ToDo: Dimming FI is not yet updated with the value 4 for night auto. RTC-959958

using namespace ::asf::core;
using namespace ::dimming_main_fi;

namespace App {
namespace Core {

VehicleDimmingClientHandler::VehicleDimmingClientHandler(const std::string& vdDimFiPort)
   : _vdDimFiProxy(Dimming_main_fiProxy::createProxy(vdDimFiPort, *this))
{
   if (_vdDimFiProxy)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _vdDimFiProxy->getPortName());
   }
}


VehicleDimmingClientHandler::~VehicleDimmingClientHandler()
{
}


void VehicleDimmingClientHandler::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("VehicleDimmingClientHandler::onAvailable"));
   StartupSync::getInstance().onAvailable(proxy, stateChange);
}


void VehicleDimmingClientHandler::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("VehicleDimmingClientHandler::onUnavailable"));
   StartupSync::getInstance().onUnavailable(proxy, stateChange);
}


void VehicleDimmingClientHandler::registerProperties(const ::boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("VehicleDimmingClientHandler::registerProperties()"));
   if (_vdDimFiProxy == proxy)
   {
      _vdDimFiProxy->sendDIM_INFO_DimmingModeUpReg(*this);
   }
}


void VehicleDimmingClientHandler::deregisterProperties(const ::boost::shared_ptr< Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("VehicleDimmingClientHandler::deregisterProperties()"));
   if (_vdDimFiProxy == proxy)
   {
      _vdDimFiProxy->sendDIM_INFO_DimmingModeRelUpRegAll();
   }
}


void VehicleDimmingClientHandler::onDIM_INFO_DimmingModeStatus(const ::boost::shared_ptr< Dimming_main_fiProxy >& /*proxy*/,
      const boost::shared_ptr< DIM_INFO_DimmingModeStatus >& status)
{
   ETG_TRACE_USR4(("VehicleDimmingClientHandler::onDIM_INFO_DimmingModeStatus(config %d, car %d, status %d)", status->getConfig(), status->getCar(), status->getStatus()));

   enLightMode evaluatedLightMode = LIGHT_MODE_UNDEFINED;
   switch (status->getStatus())
   {
      case ::dimming_main_fi_types::T_e8_DIM_Mode__Day:
         evaluatedLightMode = LIGHT_MODE_DAY_PERMANENT;
         break;
      case ::dimming_main_fi_types::T_e8_DIM_Mode__Night:
         evaluatedLightMode = LIGHT_MODE_NIGHT_PERMANENT;
         break;
      case ::dimming_main_fi_types::T_e8_DIM_Mode__Auto:
         evaluatedLightMode = LIGHT_MODE_DAY_AUTO;
         break;
      case T_e8_DIM_Mode__Night_Auto:
         evaluatedLightMode = LIGHT_MODE_NIGHT_AUTO;
         break;
      default:
         evaluatedLightMode = LIGHT_MODE_DAY_PERMANENT;
         break;
   }
   ETG_TRACE_USR4(("evaluatedLightMode = %d", evaluatedLightMode));

   POST_MSG((COURIER_MESSAGE_NEW(DimmingModeStatusUpdateMsg)(evaluatedLightMode)));
}


void VehicleDimmingClientHandler::onDIM_INFO_DimmingModeError(const ::boost::shared_ptr< Dimming_main_fiProxy >& /*proxy*/,
      const boost::shared_ptr< DIM_INFO_DimmingModeError >& /*error*/)
{
   ETG_TRACE_USR4(("VehicleDimmingClientHandler::onDIM_INFO_DimmingModeError()"));
}


}
}
