/**************************************************************************************
* @file         : ClusterDataTypes.h
* @author       : Preethi Alagappan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2022 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CLUSTERDATATYPES_H
#define CLUSTERDATATYPES_H

namespace App {
namespace Core {

// Scaling factor and offset for coordinate conversion
static const unsigned int SCALING_FACTOR = 10000000;
static const unsigned int OFFSET = 210;

static const unsigned int TIME_BYTE_COUNT = 2;
static const unsigned int DISTANCE_BYTE_COUNT = 4;
static const unsigned int DISTANCE_TO_WARNING_BYTE_COUNT = 2;
static const unsigned int STREET_NAME_BYTE_COUNT = 64;

static const unsigned int LANE_MAX_COUNT = 8;
static const unsigned int VEHICLE_RESTRICTIONS_MAX_COUNT = 8;

static const unsigned int LANE_DIRECTION_TYPE_COUNT = 10;
static const unsigned int VEHICLE_RESTRICTIONS_TYPE_COUNT = 6;

static const unsigned int DISTANCE_TO_WARNING = 200; // meters

enum ClusterNaviDataType
{
   ClusterDataType__CURRENT_STREET_NAME = 1,
   ClusterDataType__DESTINATION_INFO    = 2,
   ClusterDataType__TURN_TO_SYMBOLS     = 3,
   ClusterDataType__LANE_GUIDANCE       = 4,
   ClusterDataType__TURN_TO_STREET_NAME = 5,
   ClusterDataType__NAVIGATION_WARNING  = 6
};


enum ClusterLaneStatus
{
   ClusterLaneStatus__NOT_RECOMMENDED  = 0x00,
   ClusterLaneStatus__RECOMMENDED      = 0x10
                                         //ClusterLaneStatus__BEST_RECOMMENDED__Unused = 0x20
};


enum ClusterLaneDirection
{
   ClusterLaneDirection__NONE        = 0x00,
   ClusterLaneDirection__STRAIGHT    = 0x01,
   ClusterLaneDirection__HALF_LEFT   = 0x02,
   ClusterLaneDirection__LEFT        = 0x03,
   ClusterLaneDirection__SHARP_LEFT  = 0x04,
   ClusterLaneDirection__UTURN_LEFT  = 0x05,
   ClusterLaneDirection__UTURN_RIGHT = 0x06,
   ClusterLaneDirection__SHARP_RIGHT = 0x07,
   ClusterLaneDirection__RIGHT       = 0x08,
   ClusterLaneDirection__HALF_RIGHT  = 0x09
};


enum ClusterVehicleRestrictions
{
   ClusterVehicleRestrictions__UNKNOWN                       = 0x00,
   ClusterVehicleRestrictions__HEIGHT                        = 0x01,
   ClusterVehicleRestrictions__LENGTH                        = 0x02,
   ClusterVehicleRestrictions__WIDTH                         = 0x03,
   ClusterVehicleRestrictions__WEIGHT                        = 0x04,
   //ClusterVehicleRestrictions__MAX_WEIGHT__Unused          = 0x05,
   ClusterVehicleRestrictions__HAZARDOUS_LOAD                = 0x06,
   //ClusterVehicleRestrictions__TRAILER_RESTRICTION__Unused = 0x07
   //ClusterVehicleRestrictions__NUM_AXES__Unused            = 0x08,
   ClusterVehicleRestrictions__WEIGHT_PER_AXLE               = 0x09
};


class ClusterLaneInfo
{
   public:
      ClusterLaneInfo():
         laneStatus(ClusterLaneStatus__NOT_RECOMMENDED),
         laneDirection(ClusterLaneDirection__NONE) {}

      ClusterLaneStatus laneStatus;
      ClusterLaneDirection laneDirection;
};


}
}


#endif // CLUSTERDATATYPES_H
