/**************************************************************************************
* @file         : ClusterDataClientHandler.h
* @author       : Preethi Alagappan (ECH2)
* @addtogroup   : apphmi_navigation
* @brief        :
* @copyright    : (c) 2022 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef CLUSTER_DATACLIENTHANDLER_H
#define CLUSTER_DATACLIENTHANDLER_H

#include "VEHICLE_MAIN_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "ClusterDataTypes.h"
#include "navmid/GuidanceInfos.h"
#include "Settings/VehicleSettingsHelper.h"

using namespace ::asf::core;
using namespace ::VEHICLE_MAIN_FI;

namespace App {
namespace Core {

class ClusterDataClientHandler
   : public hmibase::ServiceAvailableIF
   , public ::VEHICLE_MAIN_FI::VehicleNaviLatitudeCallbackIF
   , public ::VEHICLE_MAIN_FI::VehicleNaviLongitudeCallbackIF
   , public ::VEHICLE_MAIN_FI::SendNaviCurrentStreetNameInfoCallbackIF
   , public ::VEHICLE_MAIN_FI::SendNaviDestinationInfoCallbackIF
   , public ::VEHICLE_MAIN_FI::SendNaviLaneGuidanceInfoCallbackIF
   , public ::VEHICLE_MAIN_FI::SendNaviTurnToStreetNameInfoCallbackIF
   , public ::VEHICLE_MAIN_FI::SendNaviNavigationWarningInfoCallbackIF
{
   public:
      static ClusterDataClientHandler* getInstance();
      static void destroyInstance();

      virtual void onAvailable(const ::boost::shared_ptr< Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onVehicleNaviLatitudeResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VehicleNaviLatitudeResult >& result);
      void onVehicleNaviLatitudeError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VehicleNaviLatitudeError >& error);
      void onVehicleNaviLongitudeResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VehicleNaviLongitudeResult >& result);
      void onVehicleNaviLongitudeError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VehicleNaviLongitudeError >& error);

      void onSendNaviCurrentStreetNameInfoResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< SendNaviCurrentStreetNameInfoResult >& result);
      void onSendNaviCurrentStreetNameInfoError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< SendNaviCurrentStreetNameInfoError >& error);

      void onSendNaviDestinationInfoResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< SendNaviDestinationInfoResult >& result);
      void onSendNaviDestinationInfoError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< SendNaviDestinationInfoError >& error);

      void onSendNaviLaneGuidanceInfoResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< SendNaviLaneGuidanceInfoResult >& result);
      void onSendNaviLaneGuidanceInfoError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< SendNaviLaneGuidanceInfoError >& error);

      void onSendNaviTurnToStreetNameInfoResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< SendNaviTurnToStreetNameInfoResult >& result);
      void onSendNaviTurnToStreetNameInfoError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< SendNaviTurnToStreetNameInfoError >& error);

      void onSendNaviNavigationWarningInfoResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< SendNaviNavigationWarningInfoResult >& result);
      void onSendNaviNavigationWarningInfoError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< SendNaviNavigationWarningInfoError >& error);

      void updateVehiclePosition(const double& latitude, const double& longitude);
      void updateCurrentStreetName(const ::std::string& streetName);
      void updateDestinationInfo(const int& distanceToDest, const int& arrivalTimeHour, const int& arrivalTimeMin, const int& timeToDest);
      void updateLaneGuidanceInfo(const ::navmiddleware::LaneInfos& laneInfos);
      void updateTurnToStreetName(const ::std::string& streetName);
      void updateVehicleRestrictions(const ::std::vector<VehicleRestrictionsPriorityType>& restrictions);

   private:
      ClusterDataClientHandler();
      ClusterDataClientHandler(const ClusterDataClientHandler&);
      ClusterDataClientHandler& operator=(const ClusterDataClientHandler&);
      ~ClusterDataClientHandler() {};

      void convertLaneInfosToClusterType(const ::navmiddleware::LaneInfos& navmidLaneInfos, ::std::vector<ClusterLaneInfo>& clusterLaneInfos);
      ClusterLaneDirection convertLaneDirectionToClusterType(const ::navmiddleware::LaneDirection& laneDirection);
      ClusterVehicleRestrictions convertVehicleRestrictionToClusterType(const VehicleRestrictionsPriorityType& restriction);

      inline void extractToByteListFromInteger(int integerData, std::vector<uint8>& byteArray, int numBytesToExtract = 1);
      inline void printClusterNaviData(const ::std::vector<uint8>& listData);

      unsigned int m_latitudeValueToCAN;
      unsigned int m_longitudeValueToCAN;

      ::std::vector<uint8> m_destinationInfos;
      ::std::vector<uint8> m_laneInfos;
      ::std::vector<uint8> m_turnToStreetName;

      static ClusterDataClientHandler* _clusterDataClientHandler;
      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> _vehicleProxy;
};


}
}


#endif //CLUSTER_DATACLIENTHANDLER_H
