/**************************************************************************************
* @file         : SpmClientHandler.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef SPM_CLIENT_HANDLER_H
#define SPM_CLIENT_HANDLER_H

#define OSAL_S_IMPORT_INTERFACE_UTIL
#include "osal_if.h"

#include "AppBase/ServiceAvailableIF.h"
#include "SPM_CORE_FIProxy.h"
#include "fcswupdatesrv/FcSwUpdateSrvProxy.h"
#include "../../DataModel/Common/Util/HMIModelIncludes.h"
#include "PrmNotihandler.h"

namespace App {
namespace Core {

class SpmClientHandler
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public SPM_CORE_FI::OnOffTriggerCallbackIF
   , public SPM_CORE_FI::DownloadLockStatesCallbackIF
   , public SPM_CORE_FI::UpdateLockCallbackIF
   , public SPM_CORE_FI::UpdateLockStatesCallbackIF
   , public SPM_CORE_FI::SystemStateCallbackIF
{
   public:
      SpmClientHandler(const std::string& spmFiPort, const std::string& fcswupdatePort);
      virtual ~SpmClientHandler();

      virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& /*proxy*/, const ::asf::core::ServiceStateChange& /*stateChange*/);
      virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& /*proxy*/, const ::asf::core::ServiceStateChange& /*stateChange*/);

      virtual void vRegisterForUSBMedia();
      virtual void vUnRegisterForUSBMedia();
      void vPRMHandler(const PrmNotificationHandler::DeviceInfo& oData);

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void onOnOffTriggerError(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/,
                               const ::boost::shared_ptr< SPM_CORE_FI::OnOffTriggerError >& /*error*/);

      void onOnOffTriggerResult(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/,
                                const ::boost::shared_ptr< SPM_CORE_FI::OnOffTriggerResult >& /*result*/);

      void onDownloadLockStatesError(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/,
                                     const ::boost::shared_ptr< SPM_CORE_FI::DownloadLockStatesError >& /*error*/);

      void onDownloadLockStatesStatus(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/,
                                      const ::boost::shared_ptr< SPM_CORE_FI::DownloadLockStatesStatus >& status);

      void onUpdateLockError(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/,
                             const ::boost::shared_ptr< SPM_CORE_FI::UpdateLockError >& /*error*/);

      void onUpdateLockResult(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/,
                              const ::boost::shared_ptr< SPM_CORE_FI::UpdateLockResult >& result);

      void onUpdateLockStatesError(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/,
                                   const ::boost::shared_ptr< SPM_CORE_FI::UpdateLockStatesError >& /*error*/);

      void onUpdateLockStatesStatus(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/,
                                    const ::boost::shared_ptr< SPM_CORE_FI::UpdateLockStatesStatus >& status);

      void onSystemStateStatus(const ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy >&  /*proxy*/,
                               const ::boost::shared_ptr< ::SPM_CORE_FI::SystemStateStatus >& /*status*/);

      void onSystemStateError(const ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/,
                              const ::boost::shared_ptr< ::SPM_CORE_FI::SystemStateError >& error);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(NAVDATAUPDATE_SpmMapUpdateUnLockReqMsg)
      ON_COURIER_MESSAGE(NAVDATAUPDATE_SpmStartMapUpdateLockReqMsg)
      //ON_COURIER_MESSAGE(SetSpmSubstateCustomerDownloadActivationReqMsg)
      COURIER_MSG_MAP_END()

      //bool onCourierMessage(const SetSpmSubstateCustomerDownloadActivationReqMsg& oMsg);
      bool onCourierMessage(const NAVDATAUPDATE_SpmMapUpdateUnLockReqMsg& oMsg);
      bool onCourierMessage(const NAVDATAUPDATE_SpmStartMapUpdateLockReqMsg& oMsg);

   private:
      ::boost::shared_ptr < SPM_CORE_FI::SPM_CORE_FIProxy > _spmCoreFiProxy;
      ::boost::shared_ptr < fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy > _fcswupdateProxy;
      bool _serviceAvailable;
      bool _fcswupdateProxyAvailable;
      tU16 _mapUpdateLockOwner;
      bool _isRequestingLock;
      std::vector< ::spm_core_fi_types::T_e8_UpdateLockState > _eLockState;

      void releaseMapUpdateLock();
      bool searchElemByUser(tU16 appId, const std::vector<tU16>& userList);
      void printUserListInfo(const std::vector<tU16>& userList);
      ENUM_CONVERT_DECLARE(getRelevantSpmSystemState, ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES, enSpmSystemState);
      virtual tVoid vNotifyStateChange(const tU16& status, const std::string& szUsbPath);
      bool vUSBSourceAvailableCheck(const std::string& szUsbPath);
};


} // namespace Core
} // namespace App

#endif // SPM_CLIENT_HANDLER_H
