/**************************************************************************************
* @file         : PrmNotihandler.h
* @author       : ECH-Venkata Sairam Dubba
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (C) 2020 Robert Bosch GmbH
*                 (C) 2020 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef PrmNotihandler_h__
#define PrmNotihandler_h__

#define OSAL_S_IMPORT_INTERFACE_TYPES
#include "osal_if.h"
#include <string>
#define NAV_USER_POI_MEDIA_SOURCE_PATH "/dev/media"

namespace App {
namespace Core {
class SpmClientHandler;
class PrmNotificationHandler
{
   public:

      struct DeviceInfo
      {
         std::string devicePath;
         tU16 status;
         tU16 type;
      };

      static SpmClientHandler* m_pSystemStateChangedUpdFI;
      static void vUSBNotificationHandler(const tU32* pu32ModeChangeInfo, const tU8 au8DeviceName[]);
      static void vIntializeFuncUnit(SpmClientHandler* pSystemStateChangedUpdFI);
};


}
}


#endif // PrmNotihandler_h__
