/**************************************************************************************
* @file         : PrmNotihandler.cpp
* @author       : ECH-Venkata Sairam Dubba
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (C) 2020 Robert Bosch GmbH
*                 (C) 2020 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "PrmNotihandler.h"
#include "SpmClientHandler.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_NAVIGATION
#define ETG_I_TTFIS_CMD_PREFIX "APPHMI_NAVIGATION_"
#define ETG_I_FILE_PREFIX App::Core::PrmNotihandler::
#include "trcGenProj/Header/PrmNotihandler.cpp.trc.h"
#endif


namespace App {
namespace Core {
SpmClientHandler* PrmNotificationHandler::m_pSystemStateChangedUpdFI = NULL;

tVoid PrmNotificationHandler::vUSBNotificationHandler(const tU32* pu32ModeChangeInfo, const tU8 au8DeviceName[])
{
   tU16 u16Type = (*pu32ModeChangeInfo) >> 16;
   ETG_TRACE_USR4(("PrmNotificationHandler::vUSBNotificationHandler(), u16Type: %d", u16Type));

   std::stringstream sDeviceName;
   tU16 deviceNameLength = OSAL_u32StringLength(au8DeviceName);
   for (int index = 0; index < deviceNameLength; index++)
   {
      sDeviceName << au8DeviceName[index];
   }

   std::string usbPath(NAV_USER_POI_MEDIA_SOURCE_PATH);
   usbPath.append("/");
   usbPath.append(sDeviceName.str());

   DeviceInfo deviceInfo;
   deviceInfo.devicePath = usbPath;
   deviceInfo.status = (tU16)(*pu32ModeChangeInfo);
   deviceInfo.type = u16Type;
   if (NULL != m_pSystemStateChangedUpdFI)
   {
      m_pSystemStateChangedUpdFI->vPRMHandler(deviceInfo);
   }
}


void PrmNotificationHandler::vIntializeFuncUnit(SpmClientHandler* pSystemStateChangedUpdFI)
{
   m_pSystemStateChangedUpdFI = pSystemStateChangedUpdFI;
}


}
}
