/**************************************************************************************
* @file         : NavigationHall.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef NavigationHall_h
#define NavigationHall_h

#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/HallComponentBase.h"
#include "AppHmi_NavigationMessages.h"

#include "App/DataModel/Main/HMIModelComponent.h"

#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "App/Core/AudioClient/AudioClientHandler.h"
#include "App/Core/BTPhoneClient/BTPhoneClientHandler.h"
#include "App/Core/ClockClient/ClockClientHandler.h"
#include "App/Core/DiagnosisService/DiagnosisServiceClientHandler.h"
#include "App/Core/DiagnosticsClient/DiagnosticsClientHandler.h"
#include "App/Core/AudioSource/AudioSourceHandler.h"
#include "App/Core/VehicleDataClient/ClusterDataClientHandler.h"
#include "App/Core/VehicleDataClient/VehicleDataClientHandler.h"
#include "App/Core/VehicleDimmingClient/VehicleDimmingClientHandler.h"
#include "App/Core/SpmClient/SpmClientHandler.h"
#include "App/Core/ApplicationSwitchClient/NaviApplicationSwitchClientHandler.h"

#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include <Adapter/LanguageHandlerAdapter.h>


#define AUDIOMANAGER_COMMANDINTERFACE org::genivi::audiomanager::CommandInterface
#define MASTERAUDIOSERVICE_INTERFACE ::bosch::cm::ai::hmi::masteraudioservice

using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;

namespace App {
namespace Core {

class NavigationHall
   : public HallComponentBase
   , public ::languageHandler::LanguageHandlerAdapter
{
   public:
      NavigationHall();
      virtual ~NavigationHall();

      // TimerCallbackIF
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);

   protected:
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ApplicationStateUpdMsg)

      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_REF(_modelComponent)
      COURIER_MSG_DELEGATE_TO_OBJ(_btPhoneClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_audioClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_audioSourceHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_clockClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_naviApplicationSwitchClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_vehicleDataClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_spmClientHandler)
      COURIER_MSG_DELEGATE_TO_CLASS(::languageHandler::LanguageHandlerAdapter)
      COURIER_MSG_DELEGATE_TO_CLASS(HallComponentBase)
      COURIER_MSG_MAP_DELEGATE_END()

      virtual void onSavePersistency();
      bool onCourierMessage(const ApplicationStateUpdMsg& oMsg);

      // for factory reset
      virtual void reqPrepareResponse(const PrepareResDiagMsgData&);
      virtual void reqExecuteResponse(const ExecuteResDiagMsgData&);
      virtual void reqFinalizeResponse(const FinalizeResDiagMsgData&);

   private:
      NavigationHall(const NavigationHall& rhs);
      const NavigationHall& operator=(const NavigationHall& rhs);

      bool OnAppModeChange(hmibase::app::base::lcm::ShutdownType newState, hmibase::app::base::lcm::ShutdownType oldState);

      ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy > _audioSourceChangeProxy;
      ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy > _soundPropertiesProxy;

      HMIModelComponent _modelComponent;
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;
      BTPhoneClientHandler* _btPhoneClientHandler;
      AudioClientHandler* _audioClientHandler;
      ClusterDataClientHandler* _clusterDataClientHandler;
      VehicleDataClientHandler* _vehicleDataClientHandler;
      VehicleDimmingClientHandler* _vehicleDimmingClientHandler;
      ClockClientHandler* _clockClientHandler;
      DiagnosticsClientHandler* _diagnosticsClientHandler;
      AudioSourceHandler* _audioSourceHandler;
      SpmClientHandler*   _spmClientHandler;
      NaviApplicationSwitchClientHandler* _naviApplicationSwitchClientHandler;
      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App


#endif
