/* ***************************************************************************************
* FILE:          NavigationGui.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  NavigationGui.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) -2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef NavigationGui_h
#define NavigationGui_h

#include "AppBase/GuiComponentBase.h"
#include "HMIAppCtrl/Proxy/ProxyHandler.h"

namespace App {
namespace Core {


class NavigationGui : public GuiComponentBase
{
   public:
      NavigationGui();
      virtual ~NavigationGui();

      virtual void preRun();
      virtual void postRun();

      static void TraceCmd_NotProcessedMsg(const unsigned char* pcu8Data);

      virtual unsigned int getDefaultTraceClass();
      virtual void setupCgiInstance();

   private:

      void PersistentValuesRead();
      void PersistentValuesWrite();
      //HmiAppNavigation::PersMemVars _mvar;

      hmibase::services::hmiappctrl::ProxyHandler _hmiAppCtrlProxyHandler;
};


} // namespace Core
} // namespace App


#endif
