/* ***************************************************************************************
* FILE:          NavigationGui.cpp
* SW-COMPONENT:  HMI-BASE
* DESCRIPTION:   NavigationGui.cpp is part of HMI-Base reference/demo/test applications
* COPYRIGHT:     (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "NavigationGui.h"
#include "HMI/CGIComponents/AppViewSettings.h"
#include "HMI/CGIComponents/CGIApp.h"
#include "AppBase/IApplicationSettings.h"
#include "Common/AppBaseSettings/KeyMapping.h"
#include "Common/Util/HMIModelIncludes.h"

//////// TRACE IF ///////////////////////////////////////////////////
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_NAVIGATION_MAIN
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_NAVIGATION
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_NAVIGATION_"
#define ETG_I_FILE_PREFIX                 App::Core::NavigationGui::
#include "trcGenProj/Header/NavigationGui.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN
//////// TRACE IF ///////////////////////////////////////////////////

//                                   main surface,                                      video surface,                    popup surfaces
//DEFAULT_APPSETTINGS(static_cast<int>(SURFACEID_MAIN_SURFACE_NAVIGATION), static_cast<int>(SURFACEID_NONE), static_cast<int>(SURFACEID_NONE), static_cast<int>(SURFACEID_NONE))

APPSETTINGS_BEGIN()
APPSETTINGS_ADD_MAINSURFACE(SURFACEID_MAIN_SURFACE_NAVIGATION),
//                            APPSETTINGS_ADD_MAINSURFACE(UD_SURFACEID_MAIN_SURFACE_NAVIGATION),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_TOP_POPUP_SURFACE_NAVIGATION),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION)
//                            APPSETTINGS_ADD_POPUPSURFACE(UD_SURFACEID_TOP_POPUP_SURFACE_NAVIGATION),
//                            APPSETTINGS_ADD_POPUPSURFACE(UD_SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION)
                            APPSETTINGS_END()

                            using namespace ::hmi;

#define MAP_OVERLAY_SYNC_BLOCK_KEY 700
#define GADGET_SYNC_BLOCK_KEY 765

namespace App {
namespace Core {


NavigationGui::NavigationGui() : GuiComponentBase(hmi::apps::reference::appHmi_Navigation, appSettings)
{
   ETG_I_REGISTER_FILE();
   ETG_I_REGISTER_CHN(TraceCmd_NotProcessedMsg);
   _hmiAppCtrlProxyHandler.setTraceId(TR_CLASS_APPHMI_NAVIGATION_APPCTRL_PROXY);

   // direct texture // configure sync block connection for unique producer id on unique 'channel' 765
   SYNC_BLOCK_CONNECTION(GADGET_SYNC_BLOCK_KEY, NAVIGATION_GADGET); // NAVIGATION_GADGET = 4; in ProjectBaseExchangingTextures

   SYNC_BLOCK_CONNECTION(MAP_OVERLAY_SYNC_BLOCK_KEY, MAP_OVERLAY);

   uint32 DisplayID_D1 = 1;// DisplayConfiguration::getInstance()->getPhysicalDisplayIdOfDisplayIndex(0);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_MAIN_SURFACE_NAVIGATION, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_TOP_POPUP_SURFACE_NAVIGATION, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION, DisplayID_D1);
}


NavigationGui::~NavigationGui()
{
   //hmibase::utils::trace::GuiInfo::setViewHandler(NULL);
}


unsigned int NavigationGui::getDefaultTraceClass()
{
   return TR_CLASS_APPHMI_NAVIGATION_MAIN;
}


void NavigationGui::setupCgiInstance()
{
   std::string assetFileName = hmibase::app::base::SystemConfiguration::getAssetFileName();
   setCgiApp(new CGIApp(assetFileName.c_str(), _hmiAppCtrlProxyHandler));
}


void NavigationGui::preRun()
{
//   DP_vCreateDatapool();
   PersistentValuesRead();
}


void NavigationGui::postRun()
{
   PersistentValuesWrite();
}


void NavigationGui::PersistentValuesRead()
{
//   dp_tclhmiAppNavigationPersMemVarsNavigation dp;
//   _mvar = dp.tGetData();
}


void NavigationGui::PersistentValuesWrite()
{
//   dp_tclhmiAppNavigationPersMemVarsNavigation dp;
//   dp.s32SetData(_mvar);
}


/**
 *sink for not processed ttfis input messages
 */
void NavigationGui::TraceCmd_NotProcessedMsg(const unsigned char* data)
{
   if (data)
   {
      ETG_TRACE_FATAL(("TraceCmd_NotProcessedMsg() : 0x%*x", ETG_LIST_LEN(data[0]), ETG_LIST_PTR_T8(data)));
   }
}


} // namespace Core
} // namespace App
