/**************************************************************************************
* @file         : DiagnosticsClientHandler.cpp
* @author       : ECH2 Preethi Alagappan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (C) 2022 Robert Bosch GmbH
*                 (C) 2022 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "DiagnosticsClientHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_NAVIGATION
#define ETG_I_TTFIS_CMD_PREFIX "APPHMI_NAVIGATION_"
#define ETG_I_FILE_PREFIX App::Core::DiagnosticsClientHandler::
#include "trcGenProj/Header/DiagnosticsClientHandler.cpp.trc.h"
#endif

static const ::std::string DIAGNOSTICS_FI_PORT    = "diagnosticsFiPort";
static const uint16_t RUNTIME_U16_APP_NAVI_RG     = 0x000A;
static const uint16_t RUNTIME_U16_APP_NAVI_MAPOUT = 0x000B;

using namespace ::asf::core;
using namespace Midw_Diagnostics_FI;

namespace App {
namespace Core {

DiagnosticsClientHandler* DiagnosticsClientHandler::_diagnosticsClientHandler = NULL;

DiagnosticsClientHandler::DiagnosticsClientHandler()
   : _diagnosticProxy(Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy::createProxy(DIAGNOSTICS_FI_PORT, *this))
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::DiagnosticsClientHandler()"));
}


DiagnosticsClientHandler* DiagnosticsClientHandler::getInstance()
{
   if(NULL == _diagnosticsClientHandler)
   {
      _diagnosticsClientHandler = new DiagnosticsClientHandler();
   }
   return _diagnosticsClientHandler;
}


void DiagnosticsClientHandler::destroyInstance()
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::destroyInstance()"));
   if(NULL != _diagnosticsClientHandler)
   {
      delete _diagnosticsClientHandler;
      _diagnosticsClientHandler = NULL;
   }
}


void DiagnosticsClientHandler::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::onAvailable()"));
   StartupSync::getInstance().onAvailable(proxy, stateChange);
}


void DiagnosticsClientHandler::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::onUnavailable()"));
   StartupSync::getInstance().onUnavailable(proxy, stateChange);
}


void DiagnosticsClientHandler::onSetRunTimeSourceDataError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRunTimeSourceDataError >& error)
{
   ETG_TRACE_ERR(("DiagnosticsClientHandler::onSetRunTimeSourceDataError(), CCA error code : %d, System error code : %d", error->getCcaErrorCode(), error->getSystemErrorCode()));
}


void DiagnosticsClientHandler::onSetRunTimeSourceDataResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRunTimeSourceDataResult >& result)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::onSetRunTimeSourceDataResult(%d)", result->getRunTimeSourceDiagResp()));
}


void DiagnosticsClientHandler::updateGuidanceRuntimeInfo(uint32_t seconds)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::updateGuidanceRuntimeInfo() : %d seconds", seconds));

   if(NULL != _diagnosticProxy.get())
   {
      _diagnosticProxy->sendSetRunTimeSourceDataStart(*this, RUNTIME_U16_APP_NAVI_RG, seconds);
   }
}


void DiagnosticsClientHandler::updateMapStreamingRuntimeInfo(uint32_t seconds)
{
   ETG_TRACE_USR4(("DiagnosticsClientHandler::updateMapStreamingRuntimeInfo() : %d seconds", seconds));

   if(NULL != _diagnosticProxy.get())
   {
      _diagnosticProxy->sendSetRunTimeSourceDataStart(*this, RUNTIME_U16_APP_NAVI_MAPOUT, seconds);
   }
}


} // namespace App
} // namespace Core
