/**************************************************************************************
* @file         : ClockClientHandler.h
* @author       : ECG5-Atchuta Sashank Kappagantu
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (C) 2018 Robert Bosch GmbH
*                 (C) 2018 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CLOCK_CLIENT_HANDLER_H
#define CLOCK_CLIENT_HANDLER_H

#include "Common/Util/HMIModelIncludes.h"
#include "clock_main_fiProxy.h"
#include "AppHmi_NavigationTypes.h"
#include "NavMiddleware.h"
#include "AppBase/ServiceAvailableIF.h"

namespace App {
namespace Core {

class ClockClientHandler
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public clock_main_fi::NewDateFormatCallbackIF
   , public clock_main_fi::TimeFormatCallbackIF
   , public clock_main_fi::LocalTimeOffsetCallbackIF
   , public clock_main_fi::GPS_AutoSyncCallbackIF
   , public clock_main_fi::LocalTimeDate_MinuteUpdateCallbackIF
{
   public:
      ClockClientHandler(const std::string& clockFiPort);
      virtual ~ClockClientHandler();

      virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onTimeFormatError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
                             const ::boost::shared_ptr< clock_main_fi::TimeFormatError >& /*error*/);
      void onTimeFormatStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
                              const ::boost::shared_ptr< clock_main_fi::TimeFormatStatus >& /*status*/);

      void onNewDateFormatError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                                const ::boost::shared_ptr< clock_main_fi::NewDateFormatError >& error);
      void onNewDateFormatStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                                 const ::boost::shared_ptr< clock_main_fi::NewDateFormatStatus >& status);

      void onLocalTimeDate_MinuteUpdateError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                                             const ::boost::shared_ptr< clock_main_fi::LocalTimeDate_MinuteUpdateError >& error);
      void onLocalTimeDate_MinuteUpdateStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                                              const ::boost::shared_ptr< clock_main_fi::LocalTimeDate_MinuteUpdateStatus >& status);

      void onLocalTimeOffsetError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                                  const ::boost::shared_ptr< clock_main_fi::LocalTimeOffsetError >& error);
      void onLocalTimeOffsetStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                                   const ::boost::shared_ptr< clock_main_fi::LocalTimeOffsetStatus >& status);

      void onGPS_AutoSyncError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                               const ::boost::shared_ptr< clock_main_fi::GPS_AutoSyncError >& error);
      void onGPS_AutoSyncStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                                const ::boost::shared_ptr< clock_main_fi::GPS_AutoSyncStatus >& status);

      Courier::UInt8 convertNewDateFormat(::clock_main_fi_types::VDCLK_TEN_NewDateFormat vdNewDateFormat);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_CASE_DUMMY_ENTRY()
      COURIER_MSG_MAP_END()

   private:
      void updateLocalTimeOffsetInfo();

      int32 _displayTimeOffset;
      bool _isAutoModeOn;
      bool _isTwelveHrFormat;

      uint8 _localHourValue;
      uint8 _localMinuteValue;

      ::boost::shared_ptr< ::clock_main_fi::Clock_main_fiProxy > _clockProxy;

      DataBindingItem<HeaderTimeDataBindingSource> _headerTime;
};


}
}


#endif // CLOCK_CLIENT_HANDLER_H
