/**************************************************************************************
* @file         : AudioClientHandler.h
* @author       : ECG5-Atchuta Sashank Kappagantu
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef AUDIO_CLIENT_HANDLER_H
#define AUDIO_CLIENT_HANDLER_H

#include "org/genivi/audiomanager/CommandInterfaceProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesProxy.h"
#include "App/Core/AudioSource/AudioSourceHandler.h"
#include "Common/Util/HMIModelIncludes.h"
#include "mascf_main_fiProxy.h"
#include "AppBase/ServiceAvailableIF.h"

#define COMMAND_INTERFACE ::org::genivi::audiomanager::CommandInterface
#define MASTERAUDIOSERVICE_INTERFACE ::bosch::cm::ai::hmi::masteraudioservice

namespace App {
namespace Core {

class AudioClientHandler
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SetMainSinkSoundPropertyCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MainSinkSoundPropertyChangedCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertyListCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SystemPropertyListCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SystemPropertyChangedCallbackIF
   , public ::mascf_main_fi::BeepFileCallbackIF
{
   public:
      AudioClientHandler(const std::string& commandInterfacePort, const std::string& mascfFiPort);
      virtual ~AudioClientHandler();

      virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onSetMainSinkSoundPropertyError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy  >& /*proxy*/,
                                           const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SetMainSinkSoundPropertyError >& /*error*/);
      void onSetMainSinkSoundPropertyResponse(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy  >& /*proxy*/,
                                              const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SetMainSinkSoundPropertyResponse >& /*response*/);

      void onMainSinkSoundPropertyChangedError(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy  >& /*proxy*/,
            const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MainSinkSoundPropertyChangedError >& /*error*/);
      void onMainSinkSoundPropertyChangedSignal(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy  >& /*proxy*/,
            const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MainSinkSoundPropertyChangedSignal >& signal);

      void onSoundPropertyListError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& proxy,
                                    const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertyListError >& error);
      void onSoundPropertyListUpdate(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& proxy,
                                     const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertyListUpdate >& update);

      void onSystemPropertyListError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& proxy,
                                     const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SystemPropertyListError >& error);
      void onSystemPropertyListUpdate(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& proxy,
                                      const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SystemPropertyListUpdate >& update);

      void onSystemPropertyChangedError(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy  >& /*proxy*/,
                                        const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SystemPropertyChangedError >& /*error*/);
      void onSystemPropertyChangedSignal(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy  >& /*proxy*/,
                                         const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SystemPropertyChangedSignal >& signal);

      void onBeepFileError(const ::boost::shared_ptr< ::mascf_main_fi::Mascf_main_fiProxy >& /*proxy*/,
                           const ::boost::shared_ptr< ::mascf_main_fi::BeepFileError >& /*response*/);
      void onBeepFileResult(const ::boost::shared_ptr< ::mascf_main_fi::Mascf_main_fiProxy >& /*proxy*/,
                            const ::boost::shared_ptr< ::mascf_main_fi::BeepFileResult >& /*response*/);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SetGuidanceVolumeReqMsg)
      ON_COURIER_MESSAGE(PlayUserBeepReqMsg)
      COURIER_MSG_MAP_END()

      bool onCourierMessage(const SetGuidanceVolumeReqMsg& oMsg);
      bool onCourierMessage(const PlayUserBeepReqMsg& oMsg);

   private:
      void onPrivateModeUpdate(int privateMode);
      int checkVolumeValue(int value);
      void sendGuidanceVolumeToAudioManager(int value);
      void sendGuidanceVolumeUpdateMsg(uint16 sinkId, int value, bool forceUpdate = false);
      void sendAudioBeepFile(::std::string beepFile);

      ::boost::shared_ptr < COMMAND_INTERFACE::CommandInterfaceProxy > _commandIFProxy;
      ::boost::shared_ptr < ::mascf_main_fi::Mascf_main_fiProxy > _mascfFiProxy;
      ::boost::shared_ptr< bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy > _audioSourceChangeProxy;
      /** Instance of SoundPropertiesProxy */
      ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy > _soundPropertiesProxy;
      int _volumeLevelCockpit;
      int _volumeLevelPrivate;
      uint16 _sinkId;
};


}
}


#endif // AUDIO_CLIENT_HANDLER_H
