/* ***************************************************************************************
* FILE:          CGIAppPopupTable.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppPopupTable.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "CgiExtensions/PopupConfig.h"

#include "CGIAppViewController_Media.h"
#include "ProjectBaseTypes.h"

POPUP_TABLE_BEGIN() // modality, priority, presentation time, minTime, validity period, closeOnSuperseded, closeOnAppLeave, surface ID, _controllerClass_
POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, true, SURFACEID_CENTER_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_MediaMessage, false),
                      POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 3000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_MediaUnsupportedPopupMessage),
                      POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 3000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_MediaUnsupportedPopupMessageHUB),
                      POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 0, 0, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_MediaConfirmBTPairing),
                      POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 12, 3000, 2000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_MediaBTStreamingUnavailable),
                      POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 13, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_WaitScene),
                      POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 13, 0, 0, 0, false, true, SURFACEID_CENTER_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_NoPlayableContentPopup),
                      POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 20, 0, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_MEDIA, CGIAppViewController_Sys_Popup),
                      POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::Application, 12, 4000, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_VideoDisableMessage, false),
                      POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::Application, 12, 4000, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_MediaGlassUnavailableMessage, false),
                      POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::Application, 12, 4000, 2000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_WMA_DRM_ProtectedFileMessage, true),
                      POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 13, 5000, 2000, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_MediaDB_Download_Error),
                      POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 5000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_MediaDB_Download_Successful),
                      POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application, 13, 0, 0, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_SignalRangeError),
                      POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 5000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MEDIA, CGIAppViewController_Pfo_MediaDB_Download_Failure),
                      POPUP_TABLE_END()
