/* ***************************************************************************************
* FILE:          HMIModelComponent.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  HMIModelComponent.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*21.09.17 Rev. 0.1 Sunil (RBEI/ECG5),Ruchi (RBEI/ECG5),Sonia (RBEI/ECG5)
* 		  		   Initial Revision.
*************************************************************************************** */

#if !defined(_HMI_MODEL_COMPONENT_H)
#define _HMI_MODEL_COMPONENT_H
#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_hmi_04_if.h"
#endif
#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_MediaStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Core/MediaDefines.h"
#include "mplay_MediaPlayer_FI.h"
#include "../../../Common/DataModel/ListRegistry.h"
#include "Core/MediaClientHandler/MediaClientHandler.h"
#include "Core/TunerClientHandler/TunerClientHandler.h"
#include "Core/SourceSwitch/MediaSourceHandling.h"
#include "Core/Utils/clMetaData.h"
#include "mplay_MediaPlayer_FI.h"
#include "mplay_MediaPlayer_FIProxy.h"
#include "Core/KDSHandler/KDSHandler.h"
#include "Core/CabinSourceRestoration/CabinSourceRestoration.h"

using namespace Courier;

namespace App {
namespace Core {

/***********************************************************************
	Structure and Typedef Declaration
***********************************************************************/

class KDSHandler;
class CabinSourceRestoration;
class HMIModelComponent
{
   private:
#ifdef WINDOWS_SIMULATION
   public: // the constructor, copy constructor and assignment opearator will be public only for DemoApp
#endif
      HMIModelComponent();
      HMIModelComponent(const HMIModelComponent&);
      HMIModelComponent& operator =(const HMIModelComponent&);
#ifdef WINDOWS_SIMULATION
   private:
#endif
      static HMIModelComponent* _theModelInstance;
      bool MediaSystemMuteStatus;
      tU8 m_u8AppleDeviceConnectionType;
      uint8 m_u8selectedDeviceType;

      uint8 m_u8LastDevType;
      tU8 m_u8ActiveDeviceType;

      uint32 m_u32PlayBackMode;
      uint32 m_u32RepeatMode;
      uint8 mTACheckboxStatus;
      MediaGadgetIndex _mediaGadgetIndex;
      //  Binding source instances
      DataBindingItem<DeviceConnectStatusDataBindingSource> m_MediaMessageData;
      DataBindingItem<PlaybackActionDataBindingSource> m_MediaPlayBackData;
      DataBindingItem<USBCameraPortPlaybackActionDataBindingSource> m_USBCameraPortMediaPlayBackData;
      DataBindingItem<USBRouterPlaybackActionDataBindingSource> m_USBRouterMediaPlayBackData;
      DataBindingItem<AppleDeviceDataBindingSource> m_MediaAppleDeviceData;
      DataBindingItem<BTPlayInfoUpdateDataBindingSource> m_MediaBTDeviceData;
      DataBindingItem<BTRepeatOptionDataBindingSource> m_MediaBTRepeatData;
      DataBindingItem<BTShuffleOptionDataBindingSource> m_MediaBTShuffleData;
      DataBindingItem<BTPlayPauseOptionDataBindingSource> m_MediaBTPlayPauseData;
      DataItemContainer<ID3CoverDataForBTDataBindingSource> ID3CoverDataForBT;
      DataBindingItem<USBCameraPortAlbumVisibilityDataBindingSource> _AlbumIconTextVisibility;
      DataItemContainer<VideoPlaybackActionDataBindingSource> m_MediaVideoPlayBackData;
      DataItemContainer<SPIVisibilityDataBindingSource> m_SPIVisibilityData;
      DataBindingItem<USBShuffleOptionDataBindingSource> m_MediaUSBShuffleData;
      DataBindingItem<USBCameraPortShuffleOptionDataBindingSource> m_MediaUSBCameraPortShuffleData;
      DataBindingItem<USBRouterShuffleOptionDataBindingSource> m_MediaUSBRouterShuffleData;
      DataBindingItem<USBRepeatOptionDataBindingSource> m_MediaUSBRepeatData;
      DataBindingItem<USBCameraPortRepeatOptionDataBindingSource> m_MediaUSBCameraPortRepeatData;
      DataBindingItem<USBRouterRepeatOptionDataBindingSource> m_MediaUSBRouterRepeatData;
      DataBindingItem<USBPlayPauseOptionDataBindingSource> m_MediaUSBPlayPauseData;
      DataBindingItem<VideoPlayerFullScreeenDataBindingSource> m_VideoPlayerFullScreeenPause;
      DataBindingItem<AuxButtonDataBindingSource> m_AuxButton;
      DataBindingItem<AppleShuffleOptionDataBindingSource> m_MediaAppleShuffleData;
      DataBindingItem<AppleRepeatOptionDataBindingSource> m_MediaAppleRepeatData;
      DataBindingItem<ApplePlayPauseOptionDataBindingSource> m_MediaApplePlayPauseData;
      DataBindingItem<AuxActivationDataBindingSource> m_MediaAuxActivation;
      DataBindingItem<GadgetPlayPauseOptionDataBindingSource> _gadgetplaypauseindex;
      DataBindingItem<PlaybackActionGadgetDataBindingSource> _gadgetplaybackaction;
      DataBindingItem<USBCameraPortPlayPauseOptionDataBindingSource> m_MediaUSBCameraPortPlayPauseData;
      DataBindingItem<USBRouterPlayPauseOptionDataBindingSource> m_MediaRouterPlayPauseData;
      DataBindingItem<MediaSourceUpdateInGadgetDataBindingSource> m_MediaSourceGadgetUpdate;
      DataBindingItem<MediaMetaDataUpdateInGadgetDataBindingSource> m_MediaMetaDataGadgetUpdate;
      DataBindingItem<PlaybackActionCabinAGadgetDataBindingSource> _cabinAgadgetplaybackaction;
      DataBindingItem<CamportUSBGadgetPlayPauseOptionDataBindingSource> _camportusbgadgetplaypauseindex;
      DataBindingItem<RouterUSBGadgetPlayPauseOptionDataBindingSource> _routerusbgadgetplaypauseindex;
      DataBindingItem<PlaybackActionRouterGadgetDataBindingSource> _routergadgetplaybackaction;
      DataBindingItem<MediaSourceUSBNameInGadgetDataBindingSource> m_MediaSourceUSBNameInGadget;

      //mcode
      DataBindingItem<MuteStateVisibleGadgetDataBindingSource> m_MuteStateVisibleGadget;
      //mcode
      DataBindingItem<IconsDataBindingSource> m_MediaArtistIconType;
      DataBindingItem<IconsVisibilityDataBindingSource> m_MediaIconType;
      DataItemContainer<ID3CoverDataForGadgetDataBindingSource> mID3GadgetCoverData;
      DataItemContainer<ID3CoverDataForCamportUSBGadgetDataBindingSource> mID3CamportUSBGadgetCoverData;
      DataItemContainer<ID3CoverDataForRouterUSBGadgetDataBindingSource> mID3RouterUSBGadgetCoverData;
      DataItemContainer<ID3CoverDataForCamportUSBDataBindingSource> mID3CamportUSBCoverData;
      DataItemContainer<ID3CoverDataForRouterUSBDataBindingSource> mID3RouterUSBCoverData;

      DataBindingItem<BTVisibilityDataBindingSource> m_MediaBTVisibility;

      //Highlighting of icon in Source_Selection view
      DataItemContainer<IpodButtonDataBindingSource> oIpodButtonData;
      DataItemContainer< MuteInfoforAuxDataBindingSource> oMuteInfoforAux;
      DataItemContainer<USBButtonDataBindingSource> oUSBButtonData;
      DataItemContainer<USB2ButtonDataBindingSource> oUSB2ButtonData;

      DataItemContainer<BTButtonDataBindingSource> oBTButtonData;

      DataBindingItem<VariantInfoDataBindingSource> oVariantInfo;

      DataItemContainer<ID3CoverDataDataBindingSource> mID3CoverData;
      DataItemContainer<ID3CoverDataForAppleDataBindingSource> ID3CoverDataForApple;

      DataItemContainer<TAStatusDataBindingSource> m_MediaSettingsTAStatus;
      DataItemContainer<TAIconStatusDataBindingSource> m_MediaTAIcon;
      DataItemContainer<MuteInfoDataBindingSource> _MuteInfo;

      DataBindingItem<ExternalMediaSourceDataBindingSource> _externalMediaSourceListVisibility;
      DataItemContainer<GadgetItemVisibilityStateDataBindingSource> m_GadgetItemsVisibility;
      DataItemContainer<Camport1USBButtonDataBindingSource> m_camport1USBDataBinding;
      DataItemContainer<Camport1HDMIButtonDataBindingSource> m_camport1HDMIDataBinding;

      DataItemContainer<BTNowplayIconsDataBindingSource> m_BTNowplayIcons;

      // Incomming events ...
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
      bool onCourierMessage(const GuiStartupFinishedUpdMsg& oMsg);
      //virtual bool onCourierMessage(const SelectDeviceSourceMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(Courier::StartupMsg)

#ifdef WINDOWS_SIMULATION
      ON_COURIER_MESSAGE(MediaOperationMsgReq)
#endif
      //ON_COURIER_MESSAGE(SelectDeviceSourceMsg)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)
      COURIER_MSG_MAP_END()

      COURIER_BINDING_MAP_BEGIN()

      COURIER_BINDING_MAP_END()

   public:
      bool getMediaConnectionPopupVisibilityState(int deviceType);
      void bOnUpdateAlbumArtDefaultforGadgetMedia();
      void bOnUpdateAlbumArtDefaultforExternalMediaGadget(int srcID);
      void bOnUpdateAlbumArtDefaultforExternalMediaSources(int srcID);
      void enableorDisableTASettingsBasedOnRegion();
      void vOnUpdateAlbumArtForUsbCamport();
      virtual ~HMIModelComponent();
      bool Init();
      static HMIModelComponent& getInstance();
      void ClearPlaytimedata(int devtype);
      void removeInstance();
      void bOnUpdateNowPlayingStatusCamera();
      void bOnUpdateNowPlayingStatusRouter();
      void vUpdateNextPerviousNormalState();
      void bOnUpdatePlayPauseStateOnCameraPort(uint8_t mPlayState);
      void bOnUpdatePlayPauseStateOnRouter(uint8_t mPlayState);
      void bOnUpdateRepeatStateOnCameraPort(uint8_t mPlayState);
      void vUpdateDeviceConnectionStatus(uint8_t DeviceTag, int DeviceType, bool DeviceConnectionStatus, bool ActiveDeviceStatus, bool NoPlayableContentStatus, int u8DeviceDisconnectionReason, int devNum);
      void vClearMetadata(int mediaSourceType);
      void vClearGadgetMetadata(int mediaSourceType);
      bool bOnUpdateDeviceStatusOnSelectionMsg(uint8 u8DeviceType, uint8 u8UsbNum);
      void VariantCheck(uint8 region);
      //To set the Play-Pause state
      void vUpdatePlayBackState(uint8_t mPlayState);
      void vUpdatePlayStateOnHomeScreen(uint8_t mPlayState);
      void vUpdatePlayBackStateOnCamportUSBHomeScreen(uint8_t mPlayState, int srcid);
      void vUpdatePlayBackStateRouterUSBHomeScreen(uint8_t mPlayState, int srcid);
      void vUpdatePlayBackStateOnHomeScreen(uint8_t mPlayState);
      bool vUpdateLastEntertainmentDeviceMsg(uint8_t DeviceTag);
      void vSourceButtonHighlight(uint8_t DeviceType, int subsrcid);
      void SourceButtonHighlight(int iDeviceType, int  usbdevicenum);
      void vUpdateStatusHomescreen(int ActiveSource);
      void vUpdateCamporUSBHomescreenStatus();
      void vUpdateRouterUSBHomescreenStatus();
      void updateSpidataVisibilityonMediaGadget(bool val);
      void vUpdateExternalSourcesVisibility();
      void vUpdateUsbAlbumIconAndTextVisibility();
      void vUpdateCabinGadgetVisibility();
      //For Metadata
      void vOnUpdateNowPlayingMetaDataInfoStatus();
      void bOnUpdateNowPlayingStatus();
      void bOnUpdateNowPlayingStatusCameraOnHomeScreen();
      void bOnUpdateNowPlayingStatusOnHomeScreen();
      void bOnVideoNowPlayingStatusMsg(std::string cVideoTitle, std::string cVideoEpisode);
      void vOnUpdateAlbumArtForUsbRouter();
      void bOnUpdatePlayTimeStatus(const uint32& u32TotalPlaytime, const uint32& u32Elapsetime
                                   , const Candera::String& szTotalTime, const Candera::String szPlayTime, const uint8_t NowPlayingDevType);
      //void vOnUpdateElapsedTimeStatusCameraPort(std::string Elapsedtime, double elapsedslidertime, double totalslidertime);
      void vUpdatePlayTimeStatus(const uint32& u32TotalPlaytime, const uint32& u32Elapsetime
                                 , const Candera::String& TotalPlaytimeText, const Candera::String ElapsetimeText);
      void vOnUpdateElapsedTimeStatusCameraPort(std::string Elapsedtime, double elapsedslidertime, double totalslidertime, std::string TotalPlayTime);
      void vOnUpdateElapsedTimeStatusRouter(std::string Elapsedtime, double elapsedslidertime, double totalslidertime, std::string TotalPlayTime);
      void vOnUpdateRepeatTrackIcon();
      void vOnUpdateRepeatListIcon();
      void vOnUpdateRepeatOffIcon();
      bool bOnUpdateRepeatModeStatus(const uint32& u32RepeatMode);
      bool bOnUpdateRepeatModeCamportUSBStatus(const uint32& u32RepeatMode);
      bool bOnUpdatePlayBackModeStatus(const uint32& u32PlayBackMode);
      bool bOnUpdateShuffleModeCamportUSBStatus(const uint32& u32PlayBackMode);
      bool bOnUpdateShuffleModeRouterStatus(const uint32& u32PlayBackMode);
      bool bOnUpdateRepeatModeRouterStatus(const uint32& u32RepeatMode);
      void vUpdateDeviceTypeToSM(uint32 deviceType);
      void vResetDeviceTypeInSM();
      void setKdsHandlerInstance(KDSHandler* _kdsHandlerInstance);
      void setCabinSourceRestorationInstance(CabinSourceRestoration* _cabinSourceRestorationInstance);
      void onMediaGadgetIndexUpdate(MediaGadgetIndex mediaGadgetIndex);
      bool onCourierMessage(const MediaOperationMsgReq& oMsg);

      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      void vUpdateTACheckbox(uint8 TAStatus);
      void vSetTAStatus(uint8 TAStatus);
      uint8 tGetTAStatus();
      void vUpdateTAIcon(bool TAIconStatus);
      // void vUpdateGadgetSourceName(std::string source, uint8 srcID);
      //mcode
      void vUpdateMuteStatus();
      void vUpdateNextPerviousIconStatus();
      void initialisemediaMetadataGadgetIndexMap();
      void updateMediaSourceInfoInGadget(int deviceType);
      void setCabinMediaGadgetIndex(MediaGadgetIndex cabinTextIndex);
      //mcode
      void bOnUpdateAlbumArt(const ::std::vector< uint8 > u8ImageData, uint32 u32ImageDataSize);
      void bOnUpdateAlbumArtDefaultforInternalMediaSources();
      void vUpdateNowplayIcons(uint8_t mediaIconIndex);
      void bOnUpdateHeaderMuteStatus();
      void ClearHeaderSourceName();
      void vUpdateMuteStateVisibleGadget(bool controlIconStatus, bool playDisableIconVisible, bool playEnableIconVisible);

      void vAuxSourceVisibility(bool bVisible);
      void clearSourceButtonHighlight();
      Candera::String GetListAllTitleId();
      Candera::String GetListAllAlbumId();

      int shuffleFlag;
      int playFlag;
      std::map <int, MediaGadgetIndex> _mediaMetadataGadgetIndexMap;

      int m_GuiStartUpFlag;
      int getGuiStartupStatus();
      Candera::String m_szTotalTimeText;
      Candera::String m_szElapsedTimeText;
      KDSHandler* _kdsHandler;
      CabinSourceRestoration* _cabinSourceRestoration;
      int	_cabinGadgetTextIndex;
      int _cabinSourceId ;
      bool _restorationEvaluatingStatus;
};


}
}


#endif // _HMI_MODEL_COMPONENT_H
