/**
 * @file <VehicleSrvClient.h>
 * @author <ECG> <INF4CV>
 * @copyright (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 * @addtogroup <AppHmi_Tuner>
 */

#ifndef LANGUAGE_CLIENT_H
#define LANGUAGE_CLIENT_H

#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
#define LANGNO  19
#endif

#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
#define LANGNO  22
#endif

#include "VEHICLE_MAIN_FIProxy.h"
#include "vehicle_main_fi_types.h"
//#include "datacollector_main_fiProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "Common/DataModel/ListRegistry.h"
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
namespace App {
namespace Core {

class ExternalMediaClientHandler;

class VehicleSrvClient : public ListImplementation,
   public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::VEHICLE_MAIN_FI::LanguageSyncSourceCallbackIF,
   public ::VEHICLE_MAIN_FI::SetLanguageCallbackIF,
   public ::VEHICLE_MAIN_FI::LanguageCallbackIF,
   public ::VEHICLE_MAIN_FI::SpeedCallbackIF,
   public ::VEHICLE_MAIN_FI::ParkingBreakSwitchCallbackIF,
   public ::VEHICLE_MAIN_FI::TrackCommandCallbackIF,
   public ::VEHICLE_MAIN_FI::CabinMediaSourceCommandCallbackIF,
   public ::VEHICLE_MAIN_FI::CabinMediaTrackCommandCallbackIF
{
   public:
      static VehicleSrvClient* poGetInstance()
      {
         if (NULL == _VehicleSrvClient)
         {
            _VehicleSrvClient = new VehicleSrvClient();
         }

         return _VehicleSrvClient;
      }
      virtual ~VehicleSrvClient();
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                              const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                const asf::core::ServiceStateChange& /*stateChange*/);

      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void setExternalMediaClientHandlerInstance(ExternalMediaClientHandler* _externalMediaClientHandlerInstance);

      virtual void onParkingBreakSwitchError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                             const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::ParkingBreakSwitchError >& error);

      virtual void onParkingBreakSwitchStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                              const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::ParkingBreakSwitchStatus >& status);

      void onSetLanguageError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                              const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SetLanguageError >& error);

      void onSetLanguageResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                               const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SetLanguageResult >& result);

      void onLanguageSyncSourceError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, \
                                     const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageSyncSourceError >& /*error*/) {}

      void onLanguageSyncSourceStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, \
                                      const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageSyncSourceStatus >& /*status*/) {}

      void onLanguageStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                            const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageStatus >& status);

      void onLanguageError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                           const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageError >& error);

      virtual void onSpeedError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SpeedError >& error);
      virtual void onSpeedStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SpeedStatus >& status);
      virtual void onTrackCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TrackCommandError >& error);
      virtual void onTrackCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TrackCommandStatus >& status);
      virtual void onCabinMediaSourceCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaSourceCommandError >& error);
      virtual void onCabinMediaSourceCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaSourceCommandStatus >& status);
      virtual void onCabinMediaTrackCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaTrackCommandError >& error);
      virtual void onCabinMediaTrackCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaTrackCommandStatus >& status);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_END()
      std::string getLanguageId(int index);
      void readLanguageOnStartUp();
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;

   private:
      VehicleSrvClient();
      static VehicleSrvClient* _VehicleSrvClient;
      ExternalMediaClientHandler* _externalMediaClientHandler;
      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> _vehicleProxy;
};


}
}


#endif
