/************************************************************************
 *FILE			: clMetaData.h
 *SW-COMPONENT	: Media
 *DESCRIPTION	:clListDataBase class which is storing Current playing songs details,
 *				  Hierarchy Informations and store Browsing level Information
 *COPYRIGHT		: (c) 2017-2019 Robert Bosch Car Multimedia GmbH
 *HISTORY:
 *
 *
 *21.09.17 Rev. 0.1 Ruchi (RBEI/ECG5)
 * 		  			Initial Revision.
 ************************************************************************/
#ifndef MEDIA_TRACK
#define MEDIA_TRACK
#define OSAL_S_IMPORT_INTERFACE_TYPES

/***********************************************************************
  INCLUDE FILES
***********************************************************************/
#ifndef WINDOWS_SIMULATION
#include "osal_if.h"
#endif


#include "ProjectBaseTypes.h"
#include "AppHmi_MediaStateMachine.h"
#include "Core/MediaDefines.h"
#include <map>
#include <string>
#include "asf/core/Types.h"
namespace App {
namespace Core {
/***********************************************************************
 Primary Declarations
 ***********************************************************************/
using namespace ::std;

/***********************************************************************
  Forward Class Declaration
  ***********************************************************************/

/***********************************************************************
  Structure and Typedef Declaration
  ***********************************************************************/

class clMetaData
{
   private:
      /*****************************************************************
        List Handling Member Variables Declaration
        ******************************************************************/
      std::string       m_szSourceName;
      std::string       m_szArtistName;
      std::string       m_szAlbumName;
      std::string       m_szTitleName;
      std::string       m_szFilename;
      int32           m_u32MediaFileType;
      int32           m_u32ListHandle;
      int32           m_u32Listtype;
      int32           m_u32TotalTime;
      int32           m_u32PlayTime;
      int32          m_u32PrevDevGrp;
      int32		   m_u32SrcID;
      int32			  m_u32SubSrcID;
      int32			m_ApplicationState;
      int 			  m_iUSBDeviceNum;
      static clMetaData* _theInstance;
      bool			m_bShuffleSupported;
      bool			m_bRepeatSupported;
      bool			m_bBrowseSupported;
      bool			m_bCamportSourceAvailable;
      bool			m_bHdmiSourceAvailable;
      bool			m_guiStartupInitiated;

   public:
      clMetaData();
      static clMetaData& getInstance();
      void removeInstance();
      ~clMetaData();
      ///***************************************************************************
      //  Current Track Info handling Functions Declaration
      //***************************************************************************/
      void setSourceName(std::string sSourceName);
      void setArtistName(std::string sArtistName);
      void setAlbumName(std::string sAlbumName);
      void setTitleName(std::string sTitleName);
      void setFilename(std::string sFilename);
      void setMediaFileType(int32 sMediaFileType);
      void setListHandle(int32 sListHandle);
      void setTotalTime(int32 u32TotalTime);
      void setPlayTime(int32 u32PlayTime);
      void setPreviousDevGrp(int32 u32PrevDevGrp);
      void setSrcID(int32 u32SrcID);
      void setSubSrcID(int32 u32SubSrcID);
      void setShuffleSupported(bool bShuffleSupported);
      void setRepeatSupported(bool bRepeatSupported);
      void setBrowseSupported(bool bBrowseSupported);
      void setUsbCamportAvailable(bool bAvail);
      void setHdmiCamportAvailable(bool bAvail);
      void setApplicationState(int32 iState);
      void setGuiStartupStatus(bool bAvail);

      std::string getArtistName();
      std::string getAlbumName();
      std::string getTitleName();
      std::string getFilename();
      int32 getMediaFileType();
      int32 getListHandle();
      int32 getTotalTime();
      int32 getPreviousDevGrp();
      int32 getSrcID();
      int32 getSubSrcID();
      bool getShuffleSupported();
      bool getRepeatSupported();
      bool getBrowseSupported();
      bool getUsbCamportAvailable();
      bool getHdmiCamportAvailable();
      int32 getApplicationState();
      bool getGuiStartupStatus();

      tVoid szOnConvertPlayTime(std::string& refTime, tU32 u32PlayTime);

      int getUSBDeviceNumber();
      void setUSBDeviceNumber(int iUSBDeviceNum);

      ///***************************************************************************
      //  Current Track Info data clearing
      //***************************************************************************/
      void vclearTrackInfo()
      {
         m_szSourceName 		= "";
         m_szArtistName 		= "";
         m_szAlbumName 		= "";
         m_szTitleName 		= "";
         m_szFilename 		= "";
         m_u32MediaFileType 	= MEDIA_C_VALUE_ZERO;
         m_u32ListHandle  	= MEDIA_C_VALUE_ZERO;
         m_u32TotalTime   	= MEDIA_C_VALUE_ZERO;
         m_u32PlayTime    	= MEDIA_C_VALUE_ZERO;
      }
};


}//end of Core
}//end of App
#endif //CLLISTDATABASE_HEADER
