/**************************************************************************************
 * @file         : RegionSinkMap.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "RegionSinkMap.h"

#include "hall_std_if.h"
#include <vector>
#include <string>
#include <stdint.h>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::RegionSinkMap::
#include "trcGenProj/Header/RegionSinkMap.cpp.trc.h"
#endif

namespace App {
namespace Core {

RegionSinkMap::RegionSinkMap()
{
   ETG_TRACE_USR1(("RegionSinkMap constructor \n"));
}


RegionSinkMap::~RegionSinkMap()
{
   ETG_TRACE_USR1(("RegionSinkMap Destructor \n"));
}


int RegionSinkMap::getRegionId(int sinkId)
{
   ETG_TRACE_USR4(("RegionSinkMap getRegionId sinkId %d\n", sinkId));
   int requestedRegionId = REGION_INVALID;
   if (sinkId == COCKPIT_SINK_ID)
   {
      requestedRegionId = REGION_COCKPIT ;
   }
   else if (sinkId == CABIN_A_SINK_ID)
   {
      requestedRegionId = REGION_CABIN_A ;
   }
   else if (sinkId == CABIN_B_SINK_ID)
   {
      requestedRegionId = REGION_CABIN_B ;
   }
   return requestedRegionId;
}


int RegionSinkMap::getSinkId(int activeRegion)
{
   ETG_TRACE_USR1(("RegionSinkMap getSinkId activeRegion %d \n", activeRegion));
   int sinkId = SINK_INVALID;
   if (activeRegion == REGION_CABIN_A)
   {
      sinkId = CABIN_A_SINK_ID;
   }
   else if (activeRegion == REGION_CABIN_B)
   {
      sinkId = CABIN_B_SINK_ID;
   }
   else
   {
      sinkId = COCKPIT_SINK_ID;
   }
   return sinkId;
}


}// namespace Core
}// namespace App
