/**************************************************************************************
* @file         : PlayableContentMap.cpp
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "hall_std_if.h"
#include "PlayableContentMap.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::PlayableContentMap::
#include "trcGenProj/Header/PlayableContentMap.cpp.trc.h"
#endif

namespace App {
namespace Core {

/************************************************************************
*FUNCTION		: PlayableContentMap
*DESCRIPTION	: Constructor. Initializes the member variables.
*PARAMETER		:
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
PlayableContentMap::PlayableContentMap()
{
   ETG_TRACE_USR1(("PlayableContentMap constructor is entered \n"));
   initialiseMap();
}


/************************************************************************
*FUNCTION		: PlayableContentMap
*DESCRIPTION	: Destructor.
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
PlayableContentMap::~PlayableContentMap()
{
   ETG_TRACE_USR1(("PlayableContentMap::PlayableContentMap Destructor is entered \n"));
}


void PlayableContentMap::initialiseMap()
{
   ETG_TRACE_USR1(("PlayableContentMap::initialiseMap is entered \n"));
   m_playableContentAvailibilityMap[EnumConst::entSourceType_CMP] = PlayableContentAvailability(false, false, EN_CRC_MATCH);
   m_playableContentAvailibilityMap[EnumConst::entSourceType_CMR] = PlayableContentAvailability(false, false, EN_CRC_MISMATCH);
}


void PlayableContentMap::setPlayableAudioContent(EnumConst::entSourceType sourceType, bool playableAudioContent)
{
   ETG_TRACE_USR4(("PlayableContentMap::setPlayableAudioContent sourceType ,playableAudioContent %d %d \n", ETG_CENUM(entSourceType, sourceType), playableAudioContent));
   m_playableContentAvailibilityMap[sourceType].AudioAvailability = playableAudioContent;
}


void PlayableContentMap::setPlayableVideoContent(EnumConst::entSourceType sourceType, bool playableVideoContent)
{
   ETG_TRACE_USR4(("PlayableContentMap setPlayableVideoContent sourceType ,playableVideoContent %d %d \n", ETG_CENUM(entSourceType, sourceType), playableVideoContent));
   m_playableContentAvailibilityMap[sourceType].VideoAvailability = playableVideoContent;
}


void PlayableContentMap::setCRCStatus(EnumConst::entSourceType sourceType, int controlValue)
{
   ETG_TRACE_USR4(("PlayableContentMap::setCRCStatus sourceType %d  controlValue %d \n", ETG_CENUM(entSourceType, sourceType), controlValue));
   m_playableContentAvailibilityMap[sourceType].CRCControlStatus = controlValue;
}


int PlayableContentMap::getCRCStatus(EnumConst::entSourceType sourceType)
{
   int controlValue = EN_CRC_MISMATCH;
   if (m_playableContentAvailibilityMap.count(sourceType))
   {
      controlValue = m_playableContentAvailibilityMap[sourceType].CRCControlStatus;
   }
   ETG_TRACE_USR3(("PlayableContentMap::getCRCStatus sourceType ,CRCControlStatus %d, %d \n", ETG_CENUM(entSourceType, sourceType), controlValue));

   return controlValue;
}


bool PlayableContentMap::getPlayableAudioContent(EnumConst::entSourceType sourceType)
{
   int l_audioAvailability = false;
   if (m_playableContentAvailibilityMap.count(sourceType))
   {
      l_audioAvailability = m_playableContentAvailibilityMap[sourceType].AudioAvailability;
   }
   ETG_TRACE_USR3(("PlayableContentMap::getPlayableAudioContent sourceType, AudioAvailability %d %d \n", ETG_CENUM(entSourceType, sourceType), l_audioAvailability));

   return l_audioAvailability;
}


bool PlayableContentMap::getPlayableVideoContent(EnumConst::entSourceType sourceType)
{
   bool l_videoAvailability = false;
   if (m_playableContentAvailibilityMap.count(sourceType))
   {
      l_videoAvailability =  m_playableContentAvailibilityMap[sourceType].VideoAvailability;
   }
   ETG_TRACE_USR4(("PlayableContentMap::getPlayableVideoContent sourceType ,VideoAvailability %d %d \n", ETG_CENUM(entSourceType, sourceType), l_videoAvailability));
   return l_videoAvailability;
}


} // end of namespace Core
} // end of namespace App
