/**************************************************************************************
* @file         : MediaUtils.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef MEDIAPLAYER_UTILS_H_
#define MEDIAPLAYER_UTILS_H_

#include "asf/core/Types.h"
#include "MPlay_fi_types.h"
#include "Core/MediaDefines.h"
#include <map>
#include <string>
#include "AvdeccPluginConstant.h"


namespace App {
namespace Core {
/***********************************************************************
Primary Declarations
***********************************************************************/
using namespace ::std;

class MediaUtils
{
   private:
      static MediaUtils* _theInstance;

   public:
      MediaUtils();
      static MediaUtils& getInstance();
      void removeInstance();
      ~MediaUtils();
      void AppendSelectedFolderInCurrFolderPath(std::string& strPath, const std::string& strFolderName);

   public:
      std::map <int, stActiveDeviceInfo> m_ActiveDeviceDataMap;
      std::map <int, stActiveDeviceInfo>::iterator m_ActiveDeviceDataMapItr;
      std::map <tU8, stNowPlayingInfo> _metadataMap;

      int getActiveSource(int activeRegion);
      int getDeviceType(EnumConst::entSourceType sourceType);
      EnumConst::entSourceType getSourceType(int srcId);
};


} // end of namespace Core
} // end of namespace App


#endif /* MEDIAPLAYER_UTILS_H_ */
