/**************************************************************************************
* @file         : ListUtilityDatabase.h
* @author       : ECV - vma6cob
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef LIST_UTILITY_DATABASE_H
#define LIST_UTILITY_DATABASE_H


class ListUtilityDatabase
{
   public:
      ListUtilityDatabase();
      ~ListUtilityDatabase();
      void vSetCurrentStartIndex(uint32 StartIndex);
      uint32 u32GetCurrentStartIndex() const;
      void vSetCurrentWindowSize(uint32 BufferSize);
      uint32 u32GetCurrentWindowSize() const;
      void vSetListHandle(uint32 listHanlde);
      uint32 u32GetListHandle() const;
      void vSetListSize(uint32 listHanlde);
      uint32 u32GetListSize() const;
      void vSetActiveItemIndex(uint32 u32Index);
      uint32 u32GetActiveItemIndex() const;
      uint32 u32GetTagbyIndex(uint32 Index);
      uint32 u32GetActiveItemTag();
      void vStoreIndexToTagData(std::vector<uint32>& v);
      void vSetFirstElement(std::vector<std::string>  firstelement);
      std::string getFirstElementText(uint32) const;
      Candera::String getListTextByIndex(uint32) const;
      void vStoreIndexToPlayableStatus(std::vector<uint32>& v);
      uint32 u32GetPlayableStatusbyIndex(uint32 Index);

   private:
      uint32 m_u32CurrentStartIndex;
      uint32 m_u32CurrentWindowSize;
      uint32 m_u32ListHandle;
      uint32 m_u32ListSize;
      uint32 m_u8ActiveItemIndex;
      std::vector<std::string>  m_sFirstItem;
      std::vector<uint32> _listItemTag;
      std::vector<uint32> _listItemPlayableStatus;
      std::vector<uint32> _FolderPlayableStatus;
};


#endif // LIST_UTILITY_DATABASE_H
