/**************************************************************************************
* @file         : ListUtilityDatabase.cpp
* @author       : ECV - vma6cob
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "ListUtilityDatabase.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS         TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL             TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX          "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX               App::Core::ListUtilityDatabase::

#include "trcGenProj/Header/ListUtilityDatabase.cpp.trc.h"
#endif
/**
* @Constructor
*/
ListUtilityDatabase::ListUtilityDatabase():
   m_u32CurrentStartIndex(0)
   , m_u32CurrentWindowSize(0)
   , m_u32ListHandle(0)
   , m_u32ListSize(0)
   , m_u8ActiveItemIndex(0)
   //, m_sFirstItem("")
{
   _listItemTag.clear();
}


/**
* @Destructor
*/
ListUtilityDatabase::~ListUtilityDatabase()
{
}


/**
* vSetCurrentStartIndex - function to store the start index of list
* @param[in] StartIndex
*/
void ListUtilityDatabase::vSetCurrentStartIndex(uint32 StartIndex)
{
   m_u32CurrentStartIndex = StartIndex;
}


/**
* u32GetCurrentStartIndex - function to get the start index of list
* @param[in] StartIndex
*/
uint32 ListUtilityDatabase::u32GetCurrentStartIndex() const
{
   ETG_TRACE_USR4(("ListUtilityDatabase::u32GetCurrentStartIndex currentstartindex:%d", m_u32CurrentStartIndex));

   return m_u32CurrentStartIndex;
}


/**
* vSetCurrentWindowSize - function to set the widow size of list
* @param[in] StartIndex
*/
void ListUtilityDatabase::vSetCurrentWindowSize(uint32 BufferSize)
{
   m_u32CurrentWindowSize = BufferSize;
}


/**
* u32GetCurrentWindowSize - function to get the widow size of list
* @param[in] StartIndex
*/
uint32 ListUtilityDatabase::u32GetCurrentWindowSize() const
{
   ETG_TRACE_USR4(("ListUtilityDatabase::u32GetCurrentWindowSize currentwindowsize:%d", m_u32CurrentWindowSize));

   return m_u32CurrentWindowSize;
}


/**
* vSetListHandle - function to set list handle
* @param[in] StartIndex
*/
void ListUtilityDatabase::vSetListHandle(uint32 u32ListHandle)
{
   m_u32ListHandle = u32ListHandle;
}


/**
* u32GetListHandle - function to get the list handle
* @param[in] StartIndex
*/
uint32 ListUtilityDatabase::u32GetListHandle() const
{
   ETG_TRACE_USR4(("ListUtilityDatabase::u32GetListHandle listhandle:%d", m_u32ListHandle));

   return m_u32ListHandle;
}


/**
* vSetListSize - function to set the current list size
* @param[in] StartIndex
*/
void ListUtilityDatabase::vSetListSize(uint32 u32ListSize)
{
   m_u32ListSize = u32ListSize;
}


/**
* u32GetListSize - function to get the current list size
* @param[in] StartIndex
*/
uint32 ListUtilityDatabase::u32GetListSize() const
{
   ETG_TRACE_USR4(("ListUtilityDatabase::u32GetListSize:listsize:%d", m_u32ListSize));

   if (m_u32ListSize > 0)
   {
      return m_u32ListSize;
   }
   else
   {
      return 0;
   }
}


/**
* vSetActiveItemIndex - function to set the selected item's index in the list
* @param[in] StartIndex
*/
void ListUtilityDatabase::vSetActiveItemIndex(uint32 u32ActiveItemIndex)
{
   m_u8ActiveItemIndex = u32ActiveItemIndex;
}


/**
* u32GetActiveItemIndex - function to get the selected item's index in the list
* @param[in] StartIndex
*/
uint32 ListUtilityDatabase::u32GetActiveItemIndex() const
{
   ETG_TRACE_USR4(("ListUtilityDatabase::u32GetActiveItemIndex activeitemindex %d", m_u8ActiveItemIndex));

   return m_u8ActiveItemIndex;
}


/**
* u32GetActiveItemTag - function to get the active item's tag in the list
* @param[in] StartIndex
*/
uint32 ListUtilityDatabase::u32GetActiveItemTag()
{
   ETG_TRACE_USR4(("ListUtilityDatabase::u32GetActiveItemTag activeitemindex %d", m_u8ActiveItemIndex));

   if (m_u8ActiveItemIndex < _listItemTag.size())	//vector size check is needed to avoid resets
   {
      ETG_TRACE_USR4(("ListUtilityDatabase::u32GetActiveItemTag listitemtag %d", _listItemTag[m_u8ActiveItemIndex]));
      return _listItemTag[m_u8ActiveItemIndex];
   }
   else
   {
      return 0;
   }
}


/**
* u32GetTagbyIndex - function to get the item's tag based on index
* @param[in] StartIndex
*/
uint32 ListUtilityDatabase::u32GetTagbyIndex(uint32 u32Index)
{
   ETG_TRACE_USR4(("ListUtilityDatabase::u32GetTagbyIndex index:%d", u32Index));

   if (u32Index < _listItemTag.size())	//vector size check is needed to avoid resets
   {
      ETG_TRACE_USR4(("ListUtilityDatabase::u32GetTagbyIndex listitemtagindex:%d", _listItemTag[u32Index]));
      return _listItemTag[u32Index];
   }
   else
   {
      return 0;
   }
}


/**
* vStoreIndexToTagData - function to store the tag of all elements in list
* @param[in] StartIndex
*/
void ListUtilityDatabase::vStoreIndexToTagData(std::vector<uint32>& v)
{
   _listItemTag = v;
}


/**
* vSetFirstElement - function to set first element
* @param[in] StartIndex
*/
void ListUtilityDatabase::vSetFirstElement(std::vector<std::string> firstelement)
{
   m_sFirstItem = firstelement;
}


/**
* getFirstElementText - function to get first element
* @param[in] selectedIndex
*/
std::string ListUtilityDatabase::getFirstElementText(uint32 selectedIndex) const
{
   ETG_TRACE_USR4(("ListUtilityDatabase::getFirstElementText selected index:%d", selectedIndex));

   if (selectedIndex < m_sFirstItem.size())
   {
      ETG_TRACE_USR4(("ListUtilityDatabase::getFirstElementText:firstitem of selected index:%s", m_sFirstItem[selectedIndex]));
      return m_sFirstItem[selectedIndex];
   }
   else
   {
      //  return (m_sFirstItem.size() == 0) ? "" : m_sFirstItem[0];
      ETG_TRACE_USR4(("ListUtilityDatabase::getFirstElementText:firstitem:%s", ((m_sFirstItem.empty() == 1) ? "" : m_sFirstItem[0]).c_str()));
      return (m_sFirstItem.empty() == 1) ? "" : m_sFirstItem[0];
   }
}


/**
* getListTextByIndex - function to get list text for selected index
* @param[in] selectedIndex
*/
Candera::String ListUtilityDatabase::getListTextByIndex(uint32 selectedIndex) const
{
   ETG_TRACE_USR4(("ListUtilityDatabase::getListTextByIndex selectedIndex:%d", selectedIndex));

   if (selectedIndex < m_sFirstItem.size())
   {
      ETG_TRACE_USR4(("ListUtilityDatabase::getListTextByIndex firstitem:%s", Candera::String(m_sFirstItem[selectedIndex].c_str())));
      return Candera::String(m_sFirstItem[selectedIndex].c_str());
   }
   else
   {
      return "";
   }
}


/**
* vStoreIndexToPlayableStatus- function to store the playable status of all elements in list
* @param[in] StartIndex
*/
void ListUtilityDatabase::vStoreIndexToPlayableStatus(std::vector<uint32>& v)
{
   _listItemPlayableStatus = v;
}


/**
* u32GetPlayableStatusbyIndex - function to get the item's playable status based on index
* @param[in] StartIndex
*/
uint32 ListUtilityDatabase::u32GetPlayableStatusbyIndex(uint32 u32Index)
{
   ETG_TRACE_USR4(("ListUtilityDatabase::u32GetPlayableStatusbyIndex index:%d", u32Index));

   if (u32Index < _listItemPlayableStatus.size())	//vector size check is needed to avoid resets
   {
      ETG_TRACE_USR4(("ListUtilityDatabase::u32GetPlayableStatusbyIndex playablestatus:%d", _listItemPlayableStatus[u32Index]));
      return _listItemPlayableStatus[u32Index];
   }
   else
   {
      return 0;
   }
}
