/**************************************************************************************
* @file         : ExternalMediaSourceConnectionStatus.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef EXTERNALMEDIASOURCECONNECTIONSTATUS_H_
#define EXTERNALMEDIASOURCECONNECTIONSTATUS_H_


namespace App {
namespace Core {
/***********************************************************************
Primary Declarations
***********************************************************************/
using namespace ::std;


class ExternalMediaSourceConnectionStatus
{
   public:
      ExternalMediaSourceConnectionStatus();
      virtual ~ExternalMediaSourceConnectionStatus();

      void initialiseMap();
      void setExternalSourceConnectionStatus(int16 sourceId, bool connectionStatus);
      bool getExternalSourceConnectionStatus(int16 sourceId);
      std::map <int16, bool> getExternalSourceConnectionStatusMap();

   private:
      std::map <int16, bool> _externalMediaSourceConnectionStatusMap;
};


} // end of namespace Core
} // end of namespace App


#endif /* EXTERNALMEDIASOURCECONNECTIONSTATUS_H_ */
