/**************************************************************************************
* @file         : ExternalMediaSourceConnectionStatus.cpp
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "hall_std_if.h"
#include "ExternalMediaSourceConnectionStatus.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::ExternalMediaSourceConnectionStatus::
#include "trcGenProj/Header/ExternalMediaSourceConnectionStatus.cpp.trc.h"
#endif

namespace App {
namespace Core {

/************************************************************************
*FUNCTION		: ExternalMediaSourceConnectionStatus
*DESCRIPTION	: Constructor. Initializes the member variables.
*PARAMETER		:
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
ExternalMediaSourceConnectionStatus::ExternalMediaSourceConnectionStatus()
{
   ETG_TRACE_COMP(("ExternalMediaSourceConnectionStatus constructor \n"));
   initialiseMap();
}


/************************************************************************
*FUNCTION		: ExternalMediaSourceConnectionStatus
*DESCRIPTION	: Destructor.
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
ExternalMediaSourceConnectionStatus::~ExternalMediaSourceConnectionStatus()
{
   ETG_TRACE_COMP(("ExternalMediaSourceConnectionStatus destructor \n"));
}


/************************************************************************
*FUNCTION		: initialiseMap
*DESCRIPTION	: Initializes map.
*PARAMETER		:
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
void ExternalMediaSourceConnectionStatus::initialiseMap()
{
   ETG_TRACE_COMP(("ExternalMediaSourceConnectionStatus initialiseMap"));
   _externalMediaSourceConnectionStatusMap.insert(pair<int16, bool>(SRC_CAMERAPORT1_USB_VIDEO, false));
   _externalMediaSourceConnectionStatusMap.insert(pair<int16, bool>(SRC_CMR1_USB1_VIDEO, false));
   _externalMediaSourceConnectionStatusMap.insert(pair<int16, bool>(SRC_CAMERAPORT1_HDMI, false));
   _externalMediaSourceConnectionStatusMap.insert(pair<int16, bool>(SRC_CAMERAPORT2_HDMI, false));
   _externalMediaSourceConnectionStatusMap.insert(pair<int16, bool>(SRC_CAMERAPORT3_HDMI, false));
   _externalMediaSourceConnectionStatusMap.insert(pair<int16, bool>(SRC_CMR1_USB1_AUDIO, false));
}


void ExternalMediaSourceConnectionStatus::setExternalSourceConnectionStatus(int16 sourceId, bool connectionStatus)
{
   ETG_TRACE_COMP(("ExternalMediaSourceConnectionStatus setExternalSourceConnectionStatus sourceId %d connectionStatus %d",
                   sourceId, connectionStatus));
   if (_externalMediaSourceConnectionStatusMap.count(sourceId))
   {
      _externalMediaSourceConnectionStatusMap[sourceId] = connectionStatus;
   }
}


bool ExternalMediaSourceConnectionStatus::getExternalSourceConnectionStatus(int16 sourceId)
{
   bool connectionStatus = false;
   if (_externalMediaSourceConnectionStatusMap.count(sourceId))
   {
      connectionStatus =  _externalMediaSourceConnectionStatusMap[sourceId];
      ETG_TRACE_USR1(("ExternalMediaSourceConnectionStatus getExternalSourceConnectionStatus sourceId %d connectionStatus %d \n",
                      sourceId, connectionStatus));
   }
   return connectionStatus;
}


std::map <int16, bool> ExternalMediaSourceConnectionStatus::getExternalSourceConnectionStatusMap()
{
   ETG_TRACE_COMP(("ExternalMediaSourceConnectionStatus getExternalSourceConnectionStatusMap"));
   return _externalMediaSourceConnectionStatusMap;
}


} // end of namespace Core
} // end of namespace App
