/**************************************************************************************
* @file         : TunerClientHandler.h
* @author       : ECG - ake9kor
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef TUNERCLIENTHANDLER_H_
#define TUNERCLIENTHANDLER_H_

#include "MIDW_TUNERMASTER_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "DataModel/HMIModelComponent.h"
#include "MIDW_TUNER_FIProxy.h"
#include "Common/DataModel/ListRegistry.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"

class StartupSync;
namespace App {
namespace Core {

class TunerClientHandler
   : public StartupSync::PropertyRegistrationIF,
     public hmibase::ServiceAvailableIF,
     public::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNOUNCEMENT_STATUSCallbackIF,
     public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNO_BUTTON_STATUSCallbackIF,
     public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTCallbackIF,
     public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_TP_STATUSCallbackIF,
     public ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOCallbackIF
{
   private:
      static TunerClientHandler* _tunerClientHandler;
      ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy > _tunerMasterFiProxy;
      ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy > _tunerFiProxy;

      ::midw_tunermaster_fi_types::T_e8_Source _CurrentActiveSrc;
      ::midw_tunermaster_fi_types::T_e8_AnnoTypes _CurrentAnnoType;

   public:
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_END()

      TunerClientHandler();
      virtual ~TunerClientHandler();

      static TunerClientHandler* getInstance()
      {
         if (NULL == _tunerClientHandler)
         {
            _tunerClientHandler = new TunerClientHandler();
         }

         return _tunerClientHandler;
      }

      bool _taActive;
      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                      const asf::core::ServiceStateChange& stateChange);

      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                        const asf::core::ServiceStateChange& stateChange);

      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void onFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTError >& /*error*/);
      virtual void onFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult >& /*result*/);
      virtual void onFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus >& status);
      virtual void onFID_TUNMSTR_G_ANNOUNCEMENT_STATUSError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNOUNCEMENT_STATUSError >& /*error*/);
      virtual void setTAflag(bool tastatus);
      virtual void onFID_TUNMSTR_G_ANNO_BUTTON_STATUSError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNO_BUTTON_STATUSError >& /*error*/);
      virtual void onFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus >& status);
      // class FID_TUN_G_ATSTATIONINFOCallbackIF implementation
      virtual void onFID_TUN_G_ATSTATIONINFOError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOError >& /*error*/);
      virtual void onFID_TUN_G_ATSTATIONINFOStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOStatus >& status);

      virtual void onFID_TUNMSTR_G_TP_STATUSError(const ::boost::shared_ptr< MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_TP_STATUSError >& /*error*/);
      virtual void onFID_TUNMSTR_G_TP_STATUSStatus(const ::boost::shared_ptr< MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_TP_STATUSStatus >& status);
};


}
}


#endif /* TUNERCLIENTHANDLER_H_ */
