/**************************************************************************************
* @file         : TunerClientHandler.cpp
* @author       : ECG - ake9kor
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "Core/TunerClientHandler/TunerClientHandler.h"
#include "Core/MediaClientHandler/MediaClientHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS         TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL             TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX          "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX               App::Core::TunerClientHandler::

#include "trcGenProj/Header/TunerClientHandler.cpp.trc.h"
#endif


namespace App {
namespace Core {
using namespace ::MIDW_TUNERMASTER_FI;
using namespace ::midw_tunermaster_fi_types;

using namespace ::MIDW_TUNER_FI;
using namespace ::midw_tuner_fi_types;

TunerClientHandler* TunerClientHandler::_tunerClientHandler = NULL;

TunerClientHandler::TunerClientHandler()
   : _tunerMasterFiProxy(MIDW_TUNERMASTER_FIProxy::createProxy("tunermasterFiPort", *this)),
     _tunerFiProxy(MIDW_TUNER_FIProxy::createProxy("tunerFiPort", *this)),
     _CurrentActiveSrc(T_e8_Source__TUN_MSTR_SOURCE_NONE),
     _CurrentAnnoType(T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_INVALID)
{
   ETG_TRACE_USR1(("TunerClientHandler::TunerClientHandler constructor"));
   if (_tunerMasterFiProxy.get())
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _tunerMasterFiProxy->getPortName());
   }
   if (_tunerFiProxy.get())
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _tunerFiProxy->getPortName());
   }
   ETG_I_REGISTER_FILE();
   _taActive = false;
}


TunerClientHandler::~TunerClientHandler()
{
   ETG_TRACE_USR1(("TunerClientHandler::TunerClientHandler destructor"));
   _tunerClientHandler = NULL;
   ETG_I_UNREGISTER_FILE();
}


void TunerClientHandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("TunerClientHandler::deregisterProperties"));
   if ((proxy == _tunerMasterFiProxy) && (_tunerMasterFiProxy.get()))
   {
      _tunerMasterFiProxy->sendFID_TUNMSTR_G_ANNOUNCEMENT_STATUSRelUpRegAll();
      _tunerMasterFiProxy->sendFID_TUNMSTR_G_ANNO_BUTTON_STATUSRelUpRegAll();
   }
   if ((proxy == _tunerFiProxy) && (_tunerFiProxy.get()))
   {
      _tunerFiProxy->sendFID_TUN_G_ATSTATIONINFORelUpRegAll();
   }
}


void TunerClientHandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("TunerClientHandler::registerProperties"));
   if ((proxy == _tunerMasterFiProxy) && (_tunerMasterFiProxy.get()))
   {
      _tunerMasterFiProxy->sendFID_TUNMSTR_G_ANNOUNCEMENT_STATUSUpReg(*this);
      _tunerMasterFiProxy->sendFID_TUNMSTR_G_ANNO_BUTTON_STATUSUpReg(*this);
   }
   if ((proxy == _tunerFiProxy) && (_tunerFiProxy.get()))
   {
      _tunerFiProxy->sendFID_TUN_G_ATSTATIONINFOUpReg(*this);
   }
}


void TunerClientHandler::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("TunerClientHandler::onAvailable"));
   if ((proxy == _tunerMasterFiProxy) && (_tunerMasterFiProxy.get()))
   {
      _tunerMasterFiProxy->sendFID_TUNMSTR_G_ANNOUNCEMENT_STATUSUpReg(*this);
      _tunerMasterFiProxy->sendFID_TUNMSTR_G_ANNO_BUTTON_STATUSUpReg(*this);
      _tunerMasterFiProxy->sendFID_TUNMSTR_G_TP_STATUSUpReg(*this);
   }
   if ((proxy == _tunerFiProxy) && (_tunerFiProxy.get()))
   {
      _tunerFiProxy->sendFID_TUN_G_ATSTATIONINFOUpReg(*this);
   }
}


void TunerClientHandler::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("TunerClientHandler::onUnavailable"));

   if ((proxy == _tunerMasterFiProxy) && (_tunerMasterFiProxy.get()))
   {
      _tunerMasterFiProxy->sendFID_TUNMSTR_G_ANNOUNCEMENT_STATUSRelUpRegAll();
      _tunerMasterFiProxy->sendFID_TUNMSTR_G_ANNO_BUTTON_STATUSRelUpRegAll();
      _tunerMasterFiProxy->sendFID_TUNMSTR_G_TP_STATUSRelUpRegAll();
   }
   if ((proxy == _tunerFiProxy) && (_tunerFiProxy.get()))
   {
      _tunerFiProxy->sendFID_TUN_G_ATSTATIONINFORelUpRegAll();
   }
}


void TunerClientHandler::onFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus >& status)
{
   ETG_TRACE_COMP(("TunerClientHandler::onFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus"));

   _CurrentActiveSrc = status->getSource();
   _CurrentAnnoType = status->getAnno_Types();

   if (_CurrentAnnoType == T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_TA)
   {
      ETG_TRACE_USR1(("TunerClientHandler::onFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus : Current Announcement Type: Traffic Announcement"));
      //update HMI model component to display the TA icon if checked

      // HMIModelComponent::getInstance().vUpdateTAIcon(status->getAnno_Status());
   }
}


void TunerClientHandler::onFID_TUNMSTR_G_ANNOUNCEMENT_STATUSError(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_G_ANNOUNCEMENT_STATUSError >& /*error*/)
{
   ETG_TRACE_COMP(("TunerClientHandler::onFID_TUNMSTR_G_ANNOUNCEMENT_STATUSError"));
}


void TunerClientHandler::setTAflag(bool tastatus)
{
   ETG_TRACE_USR3(("TunerClientHandler::setTAflag TAstatus is %d ", tastatus));
   ETG_TRACE_USR3(("TunerClientHandler::setTAflag TAActive is %d ", _taActive));

   if (_taActive != tastatus)
   {
      T_b8_SourceAnno source;
      T_b32_AnnoType anno;

      anno.setTUNMSTR_ANNOTYPE_TA(tastatus);
      anno.setTUNMSTR_ANNOTYPE_PTY(true);
      source.setTUNMSTR_ANNOSRC_FM(true);
      source.setTUNMSTR_ANNOSRC_DAB(true);

      ((_tunerMasterFiProxy.get())
       && (_tunerMasterFiProxy->sendFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTStart(
              *this, anno, source)));
   }
}


void TunerClientHandler::onFID_TUNMSTR_G_ANNO_BUTTON_STATUSError(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_G_ANNO_BUTTON_STATUSError >& /*error*/)
{
   ETG_TRACE_COMP(("TunerClientHandler::onFID_TUNMSTR_G_ANNO_BUTTON_STATUSError"));
}


void TunerClientHandler::onFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus >& status)
{
   ETG_TRACE_COMP(("TunerClientHandler::onFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus"));

   bool bDataUpdated = false;
   _taActive = status->getB32AnnouncementType().getTUNMSTR_ANNOTYPE_TA();
   ETG_TRACE_USR4(("TunerClientHandler:onFID_TUNMSTR_G_TA_STATUSStatus TAActive : %d", _taActive));
   HMIModelComponent::getInstance().vUpdateTACheckbox(_taActive);
   tclMediaClientHandler::getInstance().setTAActiveStatus(_taActive);
}


void TunerClientHandler::onFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTError(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTError >& /*error*/)
{
   ETG_TRACE_COMP(("TunerClientHandler::onFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTError"));
}


void TunerClientHandler::onFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult >& /*result*/)
{
   ETG_TRACE_COMP(("TunerClientHandler::onFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult"));
}


/**
* Description     : Virtual function implemented to get update of StationInfo Error
*
* @param[in]      : proxy: the client side representation of the CCA Functional Interface 'MIDW_TUNER_FIProxy'
* @param[in]      : error : The error message of 'StationInfo'
* @return         : void
*/
void TunerClientHandler::onFID_TUN_G_ATSTATIONINFOError(const ::boost::shared_ptr< MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUN_G_ATSTATIONINFOError >& /*error*/)
{
   ETG_TRACE_COMP(("TunerClientHandler::onFID_TUN_G_ATSTATIONINFOError"));
}


/**
* Description     : Virtual function implemented to get update of StationInfo Status
*
* @param[in]      : proxy: the client side representation of the CCA Functional Interface 'MIDW_TUNER_FIProxy'
* @param[in]      : status : The status message of the property "StationInfo"
* @return         : void
*/
void TunerClientHandler::onFID_TUN_G_ATSTATIONINFOStatus(const ::boost::shared_ptr< MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUN_G_ATSTATIONINFOStatus >& status)
{
   ETG_TRACE_COMP(("TunerClientHandler::onFID_TUN_G_ATSTATIONINFOStatus"));

   // tU8 u8TPStatus = status->getAtstationinfo().getE8AtStationTPinfo();

   // T_e8_AtStationTPinfo e8AtStationTPinfo = (T_e8_AtStationTPinfo)u8TPStatus;
   // if (T_e8_AtStationTPinfo__SELF_TP == e8AtStationTPinfo)
   // {
   // ETG_TRACE_USR3(("TunerClientHandler:TA is available"));
   // HMIModelComponent::getInstance().vUpdateTAIcon(true);
   // }
   // else
   // {
   // ETG_TRACE_USR3(("TunerClientHandler: TA is not (crossed out)available"));
   // HMIModelComponent::getInstance().vUpdateTAIcon(false);
   // }
}


void TunerClientHandler::onFID_TUNMSTR_G_TP_STATUSError(const ::boost::shared_ptr< MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_TP_STATUSError >& /*error*/)
{
   ETG_TRACE_COMP(("TunerClientHandler::onFID_TUNMSTR_G_TP_STATUSError"));
}


void TunerClientHandler::onFID_TUNMSTR_G_TP_STATUSStatus(const ::boost::shared_ptr< MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_TP_STATUSStatus >& status)
{
   ETG_TRACE_COMP(("TunerClientHandler::onFID_TUNMSTR_G_TP_STATUSStatus"));
   bool tpStatus = status->getTP_STATE();
   ETG_TRACE_USR4(("TunerClientHandler::onFID_TUNMSTR_G_TP_STATUSStatus tpstatus:%d", tpStatus));

   HMIModelComponent::getInstance().vUpdateTAIcon(tpStatus);
}


}//App
}//Core
