/**************************************************************************************
* @file         : SpeedLockStatusHandler.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*18.07.20 Rev. 0.1 Naga Suman (RBEI/ECG5)
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _SPEEDLOCK_STATUS_HANDLER_H_
#define _SPEEDLOCK_STATUS_HANDLER_H_

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "DataModel/HMIModelComponent.h"
#include "AppHmi_MediaTypes.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "Core/Utils/clMetaData.h"
#include "Core/SourceSwitch/MediaSourceHandling.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "AppHmi_MediaMessages.h"
#else
#include <string>
#include "asf/core/Types.h"
#endif

namespace App {
namespace Core {

class SpeedLockStatusHandler
{
   public:
      virtual ~SpeedLockStatusHandler();
      static SpeedLockStatusHandler& getInstance();
      void removeInstance();
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ActiveRenderedView)
      ON_COURIER_MESSAGE(MediaSurfaceStateUpdMsg)
      COURIER_MSG_MAP_END()

      bool onCourierMessage(const ActiveRenderedView& msg);
      bool onCourierMessage(const MediaSurfaceStateUpdMsg& msg);

      void handleMediaVideoLayerVisibility(bool visibility);
      void performVideoSpeedRestrictionOperation();
      void readVideoRestrictionValue();
      bool isSurfaceVisibleOnLayer(const unsigned int layerID, const int surfaceID);
      void performVideoRestrictionBasedonSpeedAndParkingBrake();
#endif
      void updateSpeedValue(uint16 speedValue);
      void updateParkBrakeStatus(uint16 parkBrakeStatus);
      bool getVideoSpeedLockStatus();
      bool isCurrentViewVideoPlayerScene(std::string currentView);
   private:

      SpeedLockStatusHandler();
      static  SpeedLockStatusHandler* _SpeedLockStatusHandler;
      uint16 m_parkBrakeStatus;
      uint16 m_speedValue;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      std::string m_currentView;
      int m_iSurfaceState;
      std::string m_previousView;
      tU8 m_videoPlayingRestrictionConfigValue;
      bool m_isVideoSpeedLockActive;
#endif
};


}//end of Core
}//end of App


#endif // _SPEEDLOCK_STATUS_HANDLER_H_
