/**************************************************************************************
* @file         : MediaSourceHandling.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef MediaSourceHandling_h
#define MediaSourceHandling_h

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppBase/ServiceAvailableIF.h"
#include "mplay_MediaPlayer_FI.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesProxy.h"
#include "org/genivi/audiomanager/CommandInterfaceProxy.h"
#include "Core/MediaClientHandler/MediaClientHandler.h"
#include <map>
#include <vector>
#include <iterator>
#include <algorithm>
#define AUDIOMANAGER_COMMANDINTERFACE org::genivi::audiomanager::CommandInterface
#define MASTERAUDIOSERVICE_INTERFACE ::bosch::cm::ai::hmi::masteraudioservice
#else
#include "asf/core/Types.h"
#endif

namespace App {
namespace Core {
class ExternalMediaClientHandler;
class ExternalMediaSourceHandler;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
class IPlayScreen;
class IDeviceConnection;

class MediaSourceHandling
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActivateSourceCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::DeactivateSourceCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::SourceListChangedCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::GetSourceListCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::SourceAvailabilityChangedCallbackIF
   , public AUDIOMANAGER_COMMANDINTERFACE::SetMainSinkSoundPropertyCallbackIF
   , public AUDIOMANAGER_COMMANDINTERFACE::MainSinkSoundPropertyChangedCallbackIF
   , public AUDIOMANAGER_COMMANDINTERFACE::SetVolumeCallbackIF
   , public AUDIOMANAGER_COMMANDINTERFACE::GetListMainSinkSoundPropertiesCallbackIF

   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::VolumeCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MuteStateCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SetMuteStateCallbackIF
   , public ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateMapCallbackIF
{
#else
class MediaSourceHandling
{
#endif
   public :
      virtual ~MediaSourceHandling();
      MediaSourceHandling();
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
// ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onActivateSourceError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                         const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActivateSourceError >& error);
      virtual void onActivateSourceResponse(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                            const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActivateSourceResponse >& /*response*/);

      virtual void onDeactivateSourceError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                           const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::DeactivateSourceError >& /*error*/);
      virtual void onDeactivateSourceResponse(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                              const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::DeactivateSourceResponse >& /*response*/);

      virtual void onSourceListChangedError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                            const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::SourceListChangedError >& /*error*/);
      virtual void onSourceListChangedSignal(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                             const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::SourceListChangedSignal >& signal);

      virtual void onGetSourceListError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                        const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::GetSourceListError >& /*error*/);
      virtual void onGetSourceListResponse(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                           const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::GetSourceListResponse >& response);

      virtual void onActiveSourceError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceError >& /*error*/);
      virtual void onActiveSourceUpdate(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                        const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceUpdate >& update);
      void onSetMainSinkSoundPropertyError(const ::boost::shared_ptr< AUDIOMANAGER_COMMANDINTERFACE::CommandInterfaceProxy >& /*proxy*/,
                                           const ::boost::shared_ptr< AUDIOMANAGER_COMMANDINTERFACE::SetMainSinkSoundPropertyError >& /*error*/);
      void onSetMainSinkSoundPropertyResponse(const ::boost::shared_ptr< AUDIOMANAGER_COMMANDINTERFACE::CommandInterfaceProxy >& /*proxy*/,
                                              const ::boost::shared_ptr< AUDIOMANAGER_COMMANDINTERFACE::SetMainSinkSoundPropertyResponse >& /*response*/);
      virtual void onMainSinkSoundPropertyChangedError(const ::boost::shared_ptr<AUDIOMANAGER_COMMANDINTERFACE::CommandInterfaceProxy >& /*proxy*/,
            const ::boost::shared_ptr<AUDIOMANAGER_COMMANDINTERFACE::MainSinkSoundPropertyChangedError >& /*error*/);
      virtual void onMainSinkSoundPropertyChangedSignal(const ::boost::shared_ptr<AUDIOMANAGER_COMMANDINTERFACE::CommandInterfaceProxy >& /*proxy*/,
            const ::boost::shared_ptr<AUDIOMANAGER_COMMANDINTERFACE::MainSinkSoundPropertyChangedSignal >& signal);
      virtual void onGetListMainSinkSoundPropertiesError(const ::boost::shared_ptr<AUDIOMANAGER_COMMANDINTERFACE::CommandInterfaceProxy >& /*proxy*/,
            const ::boost::shared_ptr<AUDIOMANAGER_COMMANDINTERFACE::GetListMainSinkSoundPropertiesError >& /*error*/);

      virtual void onGetListMainSinkSoundPropertiesResponse(const ::boost::shared_ptr<AUDIOMANAGER_COMMANDINTERFACE::CommandInterfaceProxy >& /*proxy*/,
            const ::boost::shared_ptr<AUDIOMANAGER_COMMANDINTERFACE::GetListMainSinkSoundPropertiesResponse >& response);

      virtual void onSetVolumeError(const ::boost::shared_ptr< AUDIOMANAGER_COMMANDINTERFACE::CommandInterfaceProxy >& /*proxy*/,
                                    const ::boost::shared_ptr< AUDIOMANAGER_COMMANDINTERFACE::SetVolumeError >& /*error*/);
      virtual void onSetVolumeResponse(const ::boost::shared_ptr< AUDIOMANAGER_COMMANDINTERFACE::CommandInterfaceProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< AUDIOMANAGER_COMMANDINTERFACE::SetVolumeResponse >& /*response*/);

      virtual void onVolumeError(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& /*proxy*/, const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties:: VolumeError >& /*error*/);

      virtual void onVolumeUpdate(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& /*proxy*/, const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties:: VolumeUpdate >& update);

      virtual void onMuteStateError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                    const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MuteStateError >& /*error*/);
      virtual void onMuteStateUpdate(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                     const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MuteStateUpdate >& update);

      virtual void onSetMuteStateError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& /*proxy*/, const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SetMuteStateError >& /*error*/);
      virtual void onSetMuteStateResponse(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& /*proxy*/, const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SetMuteStateResponse >& response);

      virtual void onActiveSourceListError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                           const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListError >& error);
      virtual void onActiveSourceListUpdate(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                            const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListUpdate >& signal);
      virtual void onMuteStateMapError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateMapError >& error);

      virtual void onMuteStateMapUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                        const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateMapUpdate >& update);

      virtual void onSourceAvailabilityChangedSignal(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
            const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::SourceAvailabilityChangedSignal >& signal);

      virtual void onSourceAvailabilityChangedError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
            const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::SourceAvailabilityChangedError >& error);

      int GetdeviceType();
      void InitialiseSrcAudioMap();
#endif
      bool IsMediaSourceRange(int srcid);
      bool IsTunerSourceRange(int srcid);
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      int m_Devicetype;
      int m_usbdevicenum;
      int GetUSBDeviceNum();
      void requestSourceActivation(int32 SrcID, int32 SubSrcID, int32 regionID);
      void setCurrentDeviceTag(int8 u8CurrentDeviceTag);
      int8 getCurrentDeviceTag();
      int getActiveSourceInSink(int sinkid);
      int8  m_u8sinkId;
      int8 subSrcMedia;
      tU8 IsSrcChgReqdInOtherSinks(uint32 ReqSrcID, uint32 SubSrcID, tU8 ReqSinkId);
      void initialiseAudioSourceMap();
      void setMuteStatus(bool bMuteStatus);
      void setSourceBtnHighlight();
      bool isMediaSrcActive(int iRegion);
      void vSetSourceHighlight();
      bool getCurrentRegionMuteStatus();
      bool isMediaPlayerAvailableInCabinSink(int sinkId);
      bool isBTAvailableInCabinSink(int sinkId);
      bool isMediaPlayerAvailableInPreviousSourceList(int sinkId);
      bool isBTAvailableInPreviousSourceList(int sinkId);
      void checkInternalSourceDisconnected();

      void vResetAudioSrcMapofCabin(int iSrcId);
      void removeCamportFromAudioSrcList();
      bool isCamportAvailableInCabinAudioSrcMap();
      void insertDataToMapForSrcHighlight(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceUpdate > update);
      void vRequestSourceDeactivation(int32 SrcID, int32 SubSrcID, int32 regionID);
      void vRequestGlassSourceDeactivation(int32 SrcID, int SinkId);
      void initialiseSourceAvailabilityMap();
      bool isInternalMediaSourceActiveInSink(int sinkId);
      bool isExternalMediaSourceActiveInSink(int sinkId);
      int getActiveSrcInRegion(uint8 regionId);
      int getSubSourceId(int sinkid);
      void vResetCabinGadgetAndAudioSrcMap(int iSrcId, uint32 cabinRegion);
      int getSinkId(uint32 Cabinregion);
      bool getMic1Status();

#endif
      uint8 GetActiveMediaSource(int iSrcId, int devType);
      static MediaSourceHandling& getInstance();
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      std::vector< std::multimap <int, int> > m_Audiosrc;
      std::vector< std::multimap <int, int> > m_Audiosrc_Cockpit;
      std::vector< std::multimap <int, int> > m_Audiosrc_Cabin;
      std::multimap <int, int> m_SubsrctoAudiosrc;
      std::map <uint16, bool> m_MuteStatusMap;
      std::map <int, int> m_ExternalSourceAvailabilityMap;
      std::map <int, int> _activeSourceInfo;
      bool UpdateSrcidtoMap(int m_subsrcid, int srcid);
      void lastActiveMediaSource();
      int _disconnectedSource;
      int m_iLastSubsrcid;
      void AddMediaSources(int SubSrc_id, int Src_id, int SinkId);
      int m_iLastSrcid;
      int GetLastSrcId();
      int GetLastSubSrcId();
      void removeMediaSourcefromVector(int subsrcid);
      void mediaSourcesInVector();
      void setActiveSourceStatus();
      void removeExternalMediaSourcefromVector(int iSrcId);
      void removeExternalSrcIdfromMap(int iSrcId);
      std::map< int, audioutility > audioSrcMap;
      std::map< int, audioutility > mediaSrcMap;
      void vUpdateMediaSrcMapOnDisconnection(int iDisconnectedDeviceTag);
      void vResetMediaSrcMap(int iSinkId);
      bool isHdmiAvailableInCabinAudioSrcMap();
      int getCurrentExternalSourceAvailability(int iSrcId);
      int GetLastMediaSubSrcId();
      int GetLastMediaSrcId();
      void setExternalMediaClientHandlerInstance(ExternalMediaClientHandler* _externalMediaClientHandlerInstance);
      void setExternalMediaSourceHandlerInstance(ExternalMediaSourceHandler* _externalMediaSourceHandlerInstance);
      int getSinkSrcId(int sinkId);
      int getPrevSrcId();
#else
      void setCurrentRegionSrcId(int srcId);
      void setCurrentRegionSubSrc(int iSubSrcValue);

#endif
      int vUpdateGadgetIcons(int SrcId, int currDevType);
      int getCurrentRegionSubSrc();
      int getCurrentRegionSrcId();
   private :
      static  MediaSourceHandling* _mediaSourceHandling;

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      ExternalMediaClientHandler* _externalMediaClientHandler;
      ExternalMediaSourceHandler* _externalMediaSourceHandler;
      ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy > _audioSourceChangeProxy;
      ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy > _soundPropertiesProxy;
      ::boost::shared_ptr < AUDIOMANAGER_COMMANDINTERFACE::CommandInterfaceProxy > _commandIFProxy;

      tU32 m_u32RequestedSubSrcId;
      uint8 m_requestedRegionId;
      int8 m_u8CurrentDeviceTag;
      bool m_bMuteStatus;
      void UpdateSrcidtoMap(int m_subsrcid);
      bool _isMicActive;
      int _prevSrcid;
#else
      int m_SrcId;
      int m_iSubSrcValue;
#endif
};


} // namespace Core
} // namespace App
#endif
