/**************************************************************************************
* @file         : RouterPluginClientHandler.h
* @author       : ECH - voa4kor
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef RouterPluginClientHandler_H_
#define RouterPluginClientHandler_H_

#include "AppHmi_MediaStateMachine.h"
#include "ProjectPluginMsgs.h"
#include "Core/PluginClientHandlerAppl/IPluginClientAppl.h"
#include "Core/MediaDefines.h"
#include "Core/ExternalMediaDefines.h"


namespace App {
namespace Core {

class ExternalMediaPlaybackHandler;
class ExternalMediaSourceHandler;

class RouterPluginClientHandler
   : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public IPluginClientAppl

{
   public:

      RouterPluginClientHandler();
      virtual ~RouterPluginClientHandler();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void sendPluginRequest(uint16 ControlValue, int srcID);
      int getPlaybackActionStreamType(int srcID, int u8activeRegion);
      int getRepeatModeStreamType(int srcID, int u8activeRegion);
      void updateSeekToStreamType(uint16 seekPercent);
      uint8 getPluginValue(EventDataItem* eventDataItemControlVal);
      std::string getPluginValueString(EventDataItem* eventDataItemControlVal);
      void sendpluginUpdate(uint16 ControlId, uint16 ControlValue, uint8 activeRegion, uint8 listValue, uint16 positionValue);
      double getSliderValue();
      void onMessagePluginUpdateResp(EventDataItem* eventDataItem, EventDataItem* eventDataItemControlVal, EventDataItem* eventDataItemPosition, EventDataItem* trackIndex, EventDataItem* folderPath, EventDataItem* listType, EventDataItem* subSrcType, EventDataItem* region);
      void setExternalMediaSrcHandlerInstance(ExternalMediaSourceHandler* _externalMediaSourceHandlerObject);
      void setPlayableContentInterfaceHandlerInstance(PlayableContentInterfaceHandler* _playableContentInterfaceHandlerObject);
      void updateCurrentPlayingListType(uint8 listtype, uint16 position);
      void updateCurentPlayingFolderPath(std::string folderPath);
      void updateCurrentPlayingSrcType(uint8 srcType);
      void updateCurrentPlayingFileType(uint16 fileType);
      void onPlaySelectedListItem(uint8 listtype, uint16 position, std::string folderPath, int fileType);
      void resetMetadata();
      void resetCurrentTrackInfo();

   private:
      ExternalMediaSourceHandler* _externalMediaSourceHandler;
      PlayableContentInterfaceHandler* _playableContentInterfaceHandler;
      ::std::map< uint32, ::std::map< int, StreamType > > m_StreamTypeMap;
      std::string m_sElapsedplaytimeData;
      double m_Elapsedslidervalue;
      double m_Totalslidervalue;
      double m_totaltime;
      std::string m_splaytimeData;
      stNowPlayingInfo NowPlayingInfoStatus;
      std::string m_strEmpData;
      std::string m_strEmpEpisodeData;
      std::string strEmpData;
      uint8 _currentPlayingListType;
      uint16 _currentPlayingSongPosition;
      std::string _folderPath;
      uint8 _srcType;
      uint16 _fileType;
      void initialiseStreamTypeMap();
      double getSlidertime(std::string totaltimeslidervalue);
      void deallocationRequestToAudio();
};


}
}


#endif /* RouterPluginClientHandler_H_ */
