/**************************************************************************************
* @file         : PluginClientFactory.cpp
* @author       : ECV - media
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <hmibase/hall_std_if.h>
#include "PluginClientFactory.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::PluginClientFactory::
#include "trcGenProj/Header/PluginClientFactory.cpp.trc.h"
#endif

namespace App {
namespace Core {

PluginClientFactory::PluginClientFactory()
{
}


PluginClientFactory::~PluginClientFactory()
{
}


IPluginClientAppl* PluginClientFactory::getPluginClient(int activeSource)
{
   ETG_TRACE_USR1(("PluginClientFactory getPluginClient activeSource : %d", activeSource));

   IPluginClientAppl* pluginHandler = NULL;

   if ((activeSource == SRC_CAMERAPORT1_USB_VIDEO) || (activeSource == SRC_CAMERAPORT1_USB_AUDIO))
   {
      ETG_TRACE_USR1(("PluginClientFactory getPluginClient \n"));
      static CamportUSBPluginClientHandler* _camportUSBPluginClientHandler = new CamportUSBPluginClientHandler;
      pluginHandler = _camportUSBPluginClientHandler;
   }
   else if ((activeSource == SRC_CMR1_USB1_VIDEO) || (activeSource == SRC_CMR1_USB1_AUDIO))
   {
      ETG_TRACE_USR1(("PluginClientFactory getPluginClient \n"));
      static RouterPluginClientHandler* _routerPluginClientHandler = new RouterPluginClientHandler;
      pluginHandler = _routerPluginClientHandler;
   }

   return pluginHandler;
}


}
}
