/**************************************************************************************
* @file         : PlayableContentInterfaceHandler..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _PlayableContentInterfaceHandler_H_
#define _PlayableContentInterfaceHandler_H_

#include <bits/stdc++.h>

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppBase/ServiceAvailableIF.h"
#include "bosch/cm/di/HmiEmpListInterfaceProxy.h"
#include "Core/Utils/PlayableContentMap.h"
using namespace ::bosch::cm::di::HmiEmpListInterface;
#endif
namespace App {
namespace Core {

class ExternalMediaClientHandler;

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
class PlayableContentInterfaceHandler
   : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public ::bosch::cm::di::HmiEmpListInterface::Sig_PlayableFlagCallbackIF
#else
class PlayableContentInterfaceHandler
#endif
{
   public:

      PlayableContentInterfaceHandler();
      virtual ~PlayableContentInterfaceHandler();
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      //<!--Property registration-->
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void onSig_PlayableFlagError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_PlayableFlagError >& error) ;
      virtual void onSig_PlayableFlagSignal(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_PlayableFlagSignal >& signal);
      void setPlayableContentMapInstance(PlayableContentMap* _playableContentMapInstance);
      void onCRCStatusReceived(EnumConst::entSourceType sourceType, int controlValue);
#endif
      void setExternalMediaClientHandlerInstance(ExternalMediaClientHandler* _externalMediaClientHandlerInst);
   private:

      ExternalMediaClientHandler* _externalMediaClientHandler;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      PlayableContentMap* _playableContentMap;
      ::boost::shared_ptr<HmiEmpListInterfaceProxy> _hmiEmpListInterfaceProxy;
#endif
};


} // namespace Core
} // namespace App


#endif  /* _PlayableContentInterfaceHandler_H_ */
