/**************************************************************************************
 * @file         : PlayableContentInterfaceHandler.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "hall_std_if.h"
#include "Core/PlayableContentInterfaceHandler/PlayableContentInterfaceHandler.h"
#include"Core/ExternalMediaSourceActivation/IExternalMediaSourceActivationHandler.h"
#include "Core/ExternalMediaSourceActivation/ExternalMediaSourceActivationFactory.h"
#include <vector>
#include <string>
#include <stdint.h>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::PlayableContentInterfaceHandler::
#include "trcGenProj/Header/PlayableContentInterfaceHandler.cpp.trc.h"
#endif
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "Core/ExternalMediaClientHandler/ExternalMediaClientHandler.h"
#include "Core/Utils/MediaUtils.h"

using namespace ::bosch::cm::di::HmiEmpListInterface;
#endif
namespace App {
namespace Core {

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
PlayableContentInterfaceHandler::PlayableContentInterfaceHandler()
   : _hmiEmpListInterfaceProxy(HmiEmpListInterfaceProxy::createProxy("HmiEmpListInterfacePort", *this))
   , _externalMediaClientHandler(NULL)
   , _playableContentMap(NULL)

{
   ETG_TRACE_USR1(("PlayableContentInterfaceHandler constructor \n"));
   StartupSync::getInstance().registerPropertyRegistrationIF(this, "HmiEmpListInterfacePort");
}


#endif


PlayableContentInterfaceHandler::~PlayableContentInterfaceHandler()
{
   ETG_TRACE_USR1(("PlayableContentInterfaceHandler Destructor \n"));
}


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void PlayableContentInterfaceHandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("PlayableContentInterfaceHandler::registerProperties"));
}


void PlayableContentInterfaceHandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("PlayableContentInterfaceHandler::deregisterProperties"));
}


void PlayableContentInterfaceHandler::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("PlayableContentInterfaceHandler::onUnavailable"));
   if (_hmiEmpListInterfaceProxy && _hmiEmpListInterfaceProxy == proxy)
   {
      _hmiEmpListInterfaceProxy->sendSig_PlayableFlagDeregisterAll();
   }
}


void PlayableContentInterfaceHandler::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("ExternalMediaListDBManager::onAvailable"));
   if (_hmiEmpListInterfaceProxy && _hmiEmpListInterfaceProxy == proxy)
   {
      _hmiEmpListInterfaceProxy->sendSig_PlayableFlagRegister(*this);
   }
}


void PlayableContentInterfaceHandler::setPlayableContentMapInstance(PlayableContentMap* _playableContentMapInstance)
{
   if (_playableContentMapInstance != NULL)
   {
      _playableContentMap = _playableContentMapInstance;
   }
   else
   {
      ETG_TRACE_USR1(("PlayableContentInterfaceHandler::_playableContentMapInstance is NULL"));
   }
}


void PlayableContentInterfaceHandler::setExternalMediaClientHandlerInstance(ExternalMediaClientHandler* _externalMediaClientHandlerInstance)
{
   if (_externalMediaClientHandlerInstance != NULL)
   {
      _externalMediaClientHandler = _externalMediaClientHandlerInstance;
   }
   else
   {
      ETG_TRACE_USR1(("PlayableContentInterfaceHandler::_externalMediaClientHandler is NULL"));
   }
}


void PlayableContentInterfaceHandler::onCRCStatusReceived(EnumConst::entSourceType sourceType, int controlValue)
{
   ETG_TRACE_USR4(("PlayableContentInterfaceHandler::onCRCStatusReceived sourceType:%d controlValue:%d", sourceType, controlValue));
   int deviceType  = FI_EN_E8DTY_UNKNOWN;
   _playableContentMap->setCRCStatus(sourceType, controlValue);
   deviceType = MediaUtils::getInstance().getDeviceType(sourceType);

   int srcID = SRC_INVALID;
   if (controlValue == EN_CRC_MISMATCH)
   {
      IExternalMediaSourceActivationHandler* iExternalMediaSourceActivationHandler = ExternalMediaSourceActivationFactory::getExternalActivationSourceHandlerObject(deviceType);
      srcID = iExternalMediaSourceActivationHandler->getSourceIDFromActiveContent();
      iExternalMediaSourceActivationHandler->reset();
      IPluginClientAppl* l_iPluginClientAppl = PluginClientFactory::getPluginClient(srcID);
      if (l_iPluginClientAppl != NULL)
      {
         l_iPluginClientAppl->updateCurrentPlayingListType(EnumConst::entListType_Invalid, 0);
      }
   }
   ETG_TRACE_USR4(("PlayableContentInterfaceHandler::onCRCStatusReceived deviceType:%d srcID:%d", deviceType, srcID));
}


void PlayableContentInterfaceHandler::onSig_PlayableFlagSignal(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_PlayableFlagSignal >& signal)
{
   bool bPlayableAudioContent  = signal->getIsPlayableAudio();
   bool bPlayableVideoContent  = signal->getIsPlayableVideo();
   int deviceType = FI_EN_E8DTY_UNKNOWN;
   EnumConst::entSourceType sourceType = static_cast<EnumConst::entSourceType>(signal->getSourceType());
   ETG_TRACE_USR4(("PlayableContentInterfaceHandler::onSig_PlayableFlagSignal bPlayableAudioContent:%d bPlayableVideoContent:%d",
                   bPlayableAudioContent, bPlayableVideoContent));
   _playableContentMap->setPlayableAudioContent(sourceType, bPlayableAudioContent);
   _playableContentMap->setPlayableVideoContent(sourceType, bPlayableVideoContent);
   deviceType = MediaUtils::getInstance().getDeviceType(sourceType);
   IExternalMediaSourceActivationHandler* iExternalMediaSourceActivationHandler = ExternalMediaSourceActivationFactory::getExternalActivationSourceHandlerObject(deviceType);
   iExternalMediaSourceActivationHandler->updateActivePlayableContentType();
}


void PlayableContentInterfaceHandler::onSig_PlayableFlagError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_PlayableFlagError >& error)
{
   ETG_TRACE_USR1(("PlayableContentInterfaceHandler::onSig_PlayableFlagError entered"));
}


#endif
}// namespace Core
}// namespace App
