/**************************************************************************************
* @file         : MediaPlaybackStatusUpdater..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _MediaPlaybackLongDataUpdater_H_
#define _MediaPlaybackLongDataUpdater_H_


#include <bits/stdc++.h>
#include "VEHICLE_MAIN_FIProxy.h"
#include "vehicle_main_fi_types.h"
#include "AppBase/ServiceAvailableIF.h"
#include "mplay_MediaPlayer_FIProxy.h"
#include "ProjectPluginMsgs.h"
#include "Core/ExternalMediaDefines.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "Core/VehicleSrvClient/VehicleSrvClient.h"

#define MASTERAUDIOSERVICE_INTERFACE ::bosch::cm::ai::hmi::masteraudioservice

namespace App {
namespace Core {


class MediaPlaybackLongDataUpdater : public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::mplay_MediaPlayer_FI::NowPlayingCallbackIF,
   public ::VEHICLE_MAIN_FI::SendMediaInfoCallbackIF,
   public ::VEHICLE_MAIN_FI::SendCabinAMediaInfoCallbackIF
//public ::mplay_MediaPlayer_FI::CurrentFolderPathCallbackIF
{
   public:
      MediaPlaybackLongDataUpdater();
      virtual ~MediaPlaybackLongDataUpdater();
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onSendMediaInfoError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendMediaInfoError >& error);
      virtual void onSendMediaInfoResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy  >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendMediaInfoResult >& result);

      virtual void onSendCabinAMediaInfoError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendCabinAMediaInfoError >& error);
      virtual void onSendCabinAMediaInfoResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy  >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendCabinAMediaInfoResult >& result);

      virtual void onNowPlayingError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::NowPlayingError >& error);
      virtual void onNowPlayingStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::NowPlayingStatus >& status);
      void vUpdateMediaLongDataToCAN();
      void vUpdateCabinMediaLongDataToCAN();
      void pushMediaCANLongDataToVector(uint8 mediaType, std::string mediaData);
      void pushCabinMediaCANLongDataToVector(uint8 mediaType, std::string mediaData);
      uint32 getControlId(EventDataItem* eventDataItem);
      std::string getPluginValueString(EventDataItem* eventDataItemControlVal);
      void initializePluginDataInfoMap();

      virtual bool onCourierMessage(const PluginUpdateRespMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(PluginUpdateRespMsg)
      COURIER_MSG_MAP_END()

      std::vector<uint8> _mediaCANLongDataInfo;
      std::vector<uint8> _cabinMediaCANLongDataInfo;
      std::map<std::string, stPluginData> _pluginDataInfoMap;
      std::string _previousTitle;
      std::string _previousArtist;
      bool _isInternalSourceActiveInCabin;
      bool _isExternalSourceActiveInCabin;
   private:
      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> _vehicleProxy;
      ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy > _mediaPlayerProxy;
};


} // namespace Core
} // namespace App


#endif  /* _ExternalMediaSourceHandler_H_ */
