/**************************************************************************************
 * @file         : MediaPlaybackLongDataUpdater.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "hall_std_if.h"
#include "Core/MediaPlaybackLongDataUpdater/MediaPlaybackLongDataUpdater.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include <vector>
#include <string>
#include "Core/MediaClientHandler/MediaClientHandler.h"
#include "Core/MediaSourceListHandler/MediaSourceListHandler.h"
#include "PluginConstants.h"
#include "MediaCameraPort.h"
#include "MediaRouter.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::MediaPlaybackLongDataUpdater::
#include "trcGenProj/Header/MediaPlaybackLongDataUpdater.cpp.trc.h"
#endif

using namespace ::VEHICLE_MAIN_FI;
using namespace MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange;

namespace App {
namespace Core {

/**
	* Description     : Constructor of class MediaPlaybackLongDataUpdater
	*/
MediaPlaybackLongDataUpdater::MediaPlaybackLongDataUpdater(): _vehicleProxy(::VEHICLE_MAIN_FIProxy::createProxy("vehicleMainFiPort", *this)),
   _mediaPlayerProxy(::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy::createProxy("mediaPlayerFiPort", *this))

{
   ETG_TRACE_USR1(("MediaPlaybackLongDataUpdater::MediaPlaybackLongDataUpdater constructor \n"));
   _previousTitle = " ";
   _previousArtist = " ";
   _isInternalSourceActiveInCabin = false;
   _isExternalSourceActiveInCabin = false;
   initializePluginDataInfoMap();
   _mediaCANLongDataInfo.clear();
   _cabinMediaCANLongDataInfo.clear();
   if (_vehicleProxy)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _vehicleProxy->getPortName());
   }
   if (_mediaPlayerProxy.get())
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _mediaPlayerProxy->getPortName());
   }
}


MediaPlaybackLongDataUpdater::~MediaPlaybackLongDataUpdater()
{
   ETG_TRACE_USR1(("ExternalMediaListDBManager::MediaPlaybackLongDataUpdater Destructor \n"));
   _previousTitle = " ";
   _previousArtist = " ";
   _isInternalSourceActiveInCabin = false;
   _isExternalSourceActiveInCabin = false;
   _pluginDataInfoMap.clear();
   _mediaCANLongDataInfo.clear();
   _cabinMediaCANLongDataInfo.clear();
}


void MediaPlaybackLongDataUpdater::initializePluginDataInfoMap()
{
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::initializePluginDataInfoMap"));
   _pluginDataInfoMap["Router"] = stPluginData(" ", " ");
   _pluginDataInfoMap["Media"] = stPluginData(" ", " ");
}


void MediaPlaybackLongDataUpdater::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::onUnavailable entered"));

   if ((proxy == _mediaPlayerProxy) && (_mediaPlayerProxy.get()))
   {
      _mediaPlayerProxy->sendNowPlayingRelUpRegAll();
      //_mediaPlayerProxy->sendCurrentFolderPathRelUpRegAll();
   }
}


void MediaPlaybackLongDataUpdater::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::onAvailable entered"));

   if ((proxy == _mediaPlayerProxy) && (_mediaPlayerProxy.get()))
   {
      _mediaPlayerProxy->sendNowPlayingUpReg(*this);
      // _mediaPlayerProxy->sendCurrentFolderPathUpReg(*this);
   }
}


void MediaPlaybackLongDataUpdater::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::registerProperties entered"));
}


void MediaPlaybackLongDataUpdater::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::deregisterProperties entered"));
}


void MediaPlaybackLongDataUpdater::onSendMediaInfoError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy  >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendMediaInfoError >& error)
{
   ETG_TRACE_COMP(("MediaPlaybackStatusUpdater::onSendMediaInfoError received"));
}


void MediaPlaybackLongDataUpdater::onSendMediaInfoResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy  >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendMediaInfoResult >& result)
{
   ETG_TRACE_COMP(("MediaPlaybackStatusUpdater::onSendMediaInfoResult received"));
}


void MediaPlaybackLongDataUpdater::onSendCabinAMediaInfoError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy  >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendCabinAMediaInfoError >& error)
{
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::onSendCabinAMediaInfoError received"));
}


void MediaPlaybackLongDataUpdater::onSendCabinAMediaInfoResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy  >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendCabinAMediaInfoResult >& result)
{
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::onSendCabinAMediaInfoResult received"));
}


void MediaPlaybackLongDataUpdater::onNowPlayingError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::NowPlayingError >& error)
{
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::onNowPlayingError received."));
}


void MediaPlaybackLongDataUpdater::onNowPlayingStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::NowPlayingStatus >& status)
{
   ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::onNowPlayingStatus oMediaInfo.sMetaDataField1 		= %s", status->getOMediaObject().getSMetaDataField1().c_str()));
   ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::onNowPlayingStatus oMediaInfo.sMetaDataField2 		= %s", status->getOMediaObject().getSMetaDataField2().c_str()));
   ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::onNowPlayingStatus oMediaObject::sMetaDataField3 		= %s", status->getOMediaObject().getSMetaDataField3().c_str()));
   ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::onNowPlayingStatus oMediaObject::sMetaDataField4 		= %s", status->getOMediaObject().getSMetaDataField4().c_str()));
   ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::onNowPlayingStatus oMediaObject::fileName 		= %s", status->getOMediaObject().getSFilename().c_str()));
   ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::onNowPlayingStatus oMediaObject::_isExternalSourceActiveInCabin %d", _isExternalSourceActiveInCabin));
   if (_isExternalSourceActiveInCabin == false)
   {
      _cabinMediaCANLongDataInfo.clear();
   }
   std::string currentFilePath = status->getOMediaObject().getSFilename();
   std::string currentFileName = "";
   std::string currentTitle = "" ;
   std::string currentArtist = "";
   std::string currentAlbum = "";
   std::string currentFolderPath = "";
   ::std::size_t found = ::std::string::npos;
   if (!currentFilePath.empty())
   {
      found = currentFilePath.find_last_of("/\\");
   }
   ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::onNowPlayingStatus found value is %d", found));

   if (found != ::std::string::npos)
   {
      currentFileName = currentFilePath.substr(found + 1);
      currentFolderPath = currentFilePath.substr(0, found);
   }
   ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::onNowPlayingStatus currentFileName is %s", currentFileName.c_str()));
   ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::onNowPlayingStatus folder name = %s", currentFolderPath.c_str()));
   if (MediaSourceHandling::getInstance().isInternalMediaSourceActiveInSink(COCKPIT_SINK_ID))
   {
      pushMediaCANLongDataToVector(MEDIA_CURRENT_FILENAME, currentFileName);
      pushMediaCANLongDataToVector(MEDIA_CURRENT_FOLDER, currentFolderPath);
   }
   if (MediaSourceHandling::getInstance().isInternalMediaSourceActiveInSink(CABIN_A_SINK_ID))
   {
      pushCabinMediaCANLongDataToVector(MEDIA_CURRENT_FILENAME, currentFileName);
      pushCabinMediaCANLongDataToVector(MEDIA_CURRENT_FOLDER, currentFolderPath);
   }
   tU8 categoryType =  status->getOMediaObject().getE8CategoryType();
   ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::onNowPlayingStatus oMediaObject::e8CategoryType= %d", categoryType));

   switch (categoryType)
   {
      case MPlay_fi_types::T_e8_MPlayCategoryType__e8CTY_SONG:
      {
         currentTitle = status->getOMediaObject().getSMetaDataField4();
         currentArtist = status->getOMediaObject().getSMetaDataField2();
         currentAlbum =  status->getOMediaObject().getSMetaDataField3();
         if (MediaSourceHandling::getInstance().isInternalMediaSourceActiveInSink(COCKPIT_SINK_ID))
         {
            pushMediaCANLongDataToVector(MEDIA_CURRENT_TITLE, currentTitle);
            pushMediaCANLongDataToVector(MEDIA_CURRENT_ALBUM, currentAlbum);
            pushMediaCANLongDataToVector(MEDIA_CURRENT_ARTIST, currentArtist);
         }
         if (MediaSourceHandling::getInstance().isInternalMediaSourceActiveInSink(CABIN_A_SINK_ID))
         {
            pushCabinMediaCANLongDataToVector(MEDIA_CURRENT_TITLE, currentTitle);
            pushCabinMediaCANLongDataToVector(MEDIA_CURRENT_ALBUM, currentAlbum);
            pushCabinMediaCANLongDataToVector(MEDIA_CURRENT_ARTIST, currentArtist);
         }
         break;
      }
      case  MPlay_fi_types::T_e8_MPlayCategoryType__e8CTY_EPISODE:
      {
         currentTitle = status->getOMediaObject().getSMetaDataField4();
         currentAlbum = status->getOMediaObject().getSMetaDataField3();
         currentArtist = "";
         if (MediaSourceHandling::getInstance().isInternalMediaSourceActiveInSink(COCKPIT_SINK_ID))
         {
            pushMediaCANLongDataToVector(MEDIA_CURRENT_TITLE, currentTitle);
            pushMediaCANLongDataToVector(MEDIA_CURRENT_ALBUM, currentAlbum);
            pushMediaCANLongDataToVector(MEDIA_CURRENT_ARTIST, currentArtist);
         }
         if (MediaSourceHandling::getInstance().isInternalMediaSourceActiveInSink(CABIN_A_SINK_ID))
         {
            pushCabinMediaCANLongDataToVector(MEDIA_CURRENT_TITLE, currentTitle);
            pushCabinMediaCANLongDataToVector(MEDIA_CURRENT_ALBUM, currentAlbum);
            pushCabinMediaCANLongDataToVector(MEDIA_CURRENT_ARTIST, currentArtist);
         }
         break;
      }

      default:
      {
         break;
      }
   }
   if (MediaSourceHandling::getInstance().isInternalMediaSourceActiveInSink(COCKPIT_SINK_ID))
   {
      vUpdateMediaLongDataToCAN();
   }
   if (MediaSourceHandling::getInstance().isInternalMediaSourceActiveInSink(CABIN_A_SINK_ID))
   {
      _isInternalSourceActiveInCabin = true;
      vUpdateCabinMediaLongDataToCAN();
   }
}


uint32 MediaPlaybackLongDataUpdater::getControlId(EventDataItem* eventDataItem)
{
   EventDataItem::Data eventData = eventDataItem->getData();
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::getControlId eventDataItem  %d", eventData._type));
   uint32 u32ControlId = 0;
   if (EventDataItem::UINT16 == eventData._type)
   {
      u32ControlId = eventData._value._uint16Value;
   }
   else if (EventDataItem::UINT32 == eventData._type)
   {
      u32ControlId = eventData._value._uint32Value;
   }
   ETG_TRACE_USR1(("MediaPlaybackLongDataUpdater::getPluginValue u32ControlId  %d", u32ControlId));
   return u32ControlId;
}


std::string MediaPlaybackLongDataUpdater::getPluginValueString(EventDataItem* eventDataItemControlVal)
{
   EventDataItem::Data eventDataControlVal = eventDataItemControlVal->getData();
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::getPluginValueString eventDataControlVal  %d", eventDataControlVal._type));
   std::string l_ControlVal = "";
   if (EventDataItem::STRING == eventDataControlVal._type)
   {
      l_ControlVal = eventDataControlVal._value._stringValue->c_str();
   }
   ETG_TRACE_USR1(("MediaPlaybackLongDataUpdater::getPluginValueString l_ControlVal  %s", l_ControlVal.c_str()));
   return l_ControlVal;
}


void MediaPlaybackLongDataUpdater::pushMediaCANLongDataToVector(uint8 mediaType, std::string mediaData)
{
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::pushMediaCANLongDataToVector: mediaType %d, mediaData %s", mediaType, mediaData.c_str()));
   uint8 mediaDataCurrentIndex = 0;
   _mediaCANLongDataInfo.push_back(mediaType);
   if (!mediaData.empty())
   {
      for (; mediaDataCurrentIndex < mediaData.size(); ++mediaDataCurrentIndex)
      {
         _mediaCANLongDataInfo.push_back(mediaData[mediaDataCurrentIndex]);
      }
   }
   _mediaCANLongDataInfo.push_back('\0');
}


void MediaPlaybackLongDataUpdater::pushCabinMediaCANLongDataToVector(uint8 mediaType, std::string mediaData)
{
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::pushCabinMediaCANLongDataToVector: mediaType %d, mediaData %s", mediaType, mediaData.c_str()));
   uint8 mediaDataCurrentIndex = 0;
   _cabinMediaCANLongDataInfo.push_back(mediaType);
   if (!mediaData.empty())
   {
      for (; mediaDataCurrentIndex < mediaData.size(); ++mediaDataCurrentIndex)
      {
         _cabinMediaCANLongDataInfo.push_back(mediaData[mediaDataCurrentIndex]);
      }
   }
   _cabinMediaCANLongDataInfo.push_back('\0');
}


void MediaPlaybackLongDataUpdater ::vUpdateMediaLongDataToCAN()
{
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::vUpdateMediaLongDataToCAN"));

   ::vehicle_main_fi_types::T_CAN_Mesg  mediaCANmsg ;
   mediaCANmsg.setListData(_mediaCANLongDataInfo);
   _mediaCANLongDataInfo.clear();
   _vehicleProxy->sendSendMediaInfoStart(*this, mediaCANmsg);
}


void MediaPlaybackLongDataUpdater ::vUpdateCabinMediaLongDataToCAN()
{
   ETG_TRACE_COMP(("MediaPlaybackLongDataUpdater::vUpdateCabinMediaLongDataToCAN: _isInternalSourceActiveInCabin %d, _isExternalSourceActiveInCabin %d", _isInternalSourceActiveInCabin, _isExternalSourceActiveInCabin));
   ::vehicle_main_fi_types::T_CAN_Mesg  mediaCANmsg ;
   mediaCANmsg.setListData(_cabinMediaCANLongDataInfo);
   if (_isInternalSourceActiveInCabin == true)
   {
      _cabinMediaCANLongDataInfo.clear();
      _isInternalSourceActiveInCabin = false;
   }
   if (_isExternalSourceActiveInCabin = true)
   {
      _isExternalSourceActiveInCabin = false;
   }
   _vehicleProxy->sendSendCabinAMediaInfoStart(*this, mediaCANmsg);
}


bool MediaPlaybackLongDataUpdater::onCourierMessage(const PluginUpdateRespMsg& oMsg)
{
   const Candera::String& pluginName = oMsg.GetPluginName();
   const boost::shared_ptr<EventDataUtility>& dataUtility = oMsg.GetPluginData();
   ETG_TRACE_USR1(("MediaPlaybackLongDataUpdater::PluginUpdateRespMsg: pluginName = %s", pluginName.GetCString()));
   if (NULL != dataUtility.get())
   {
      const std::vector<EventDataItem*>& dataItems = dataUtility->getData();
      ETG_TRACE_USR2(("MediaPlaybackLongDataUpdater:PluginUpdateRespMsg dataItems %d", dataItems.size()));
      if (dataItems.size() > 1)
      {
         if ((0 == strcmp(PLUGIN_NAME_ROUTER, pluginName.GetCString())) || (0 == strcmp(PLUGIN_NAME_MEDIA, pluginName.GetCString())))
         {
            EventDataItem* eventDataItem = dataItems.at(0);
            EventDataItem* eventDataItemControlVal = dataItems.at(1);
            if (NULL != eventDataItem)
            {
               uint32 m_control_id = getControlId(eventDataItem);
               ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::PluginUpdateRespMsg m_control_id %d", m_control_id));
               switch (m_control_id)
               {
                  case EN_CAMPORT_VIDNAME://27
                  case EN_CAMPORT_TRACK://9
                  case EN_ROUTER_STREAM1_VIDEO_NAME://20
                  case EN_ROUTER_STREAM3_TRACK_NAME://2
                  {
                     if (NULL != eventDataItemControlVal)
                     {
                        _previousTitle = _pluginDataInfoMap[pluginName.GetCString()].titleName;
                        _pluginDataInfoMap[pluginName.GetCString()].titleName = getPluginValueString(eventDataItemControlVal);
                        ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::PluginUpdateRespMsg _previousTitle %s", _previousTitle.c_str()));
                        ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::PluginUpdateRespMsg titleName %s", _pluginDataInfoMap[pluginName.GetCString()].titleName.c_str()));
                        if (_previousTitle != _pluginDataInfoMap[pluginName.GetCString()].titleName)
                        {
                           _isExternalSourceActiveInCabin = true;
                           _cabinMediaCANLongDataInfo.clear();
                           pushCabinMediaCANLongDataToVector(MEDIA_CURRENT_TITLE, _pluginDataInfoMap[pluginName.GetCString()].titleName);
                           vUpdateCabinMediaLongDataToCAN();
                        }
                     }
                  }
                  break;
                  case EN_CAMPORT_VIDEPISODE://28
                  case EN_ROUTER_STREAM1_VIDEO_EPISODE://23
                  case EN_ROUTER_STREAM3_ARTIST_NAME://5
                  {
                     if (NULL != eventDataItemControlVal)
                     {
                        _previousArtist = _pluginDataInfoMap[pluginName.GetCString()].artistName;
                        _pluginDataInfoMap[pluginName.GetCString()].artistName = getPluginValueString(eventDataItemControlVal);
                        ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::PluginUpdateRespMsg _previousArtist %s", _previousArtist.c_str()));
                        ETG_TRACE_USR4(("MediaPlaybackLongDataUpdater::PluginUpdateRespMsg artistName %s", _pluginDataInfoMap[pluginName.GetCString()].artistName.c_str()));
                        if ((_previousArtist != _pluginDataInfoMap[pluginName.GetCString()].artistName) || (_previousTitle != _pluginDataInfoMap[pluginName.GetCString()].titleName))
                        {
                           _isExternalSourceActiveInCabin = true;
                           pushCabinMediaCANLongDataToVector(MEDIA_CURRENT_ARTIST, _pluginDataInfoMap[pluginName.GetCString()].artistName);
                           vUpdateCabinMediaLongDataToCAN();
                        }
                     }
                  }
                  break;
                  default:
                  {
                     ETG_TRACE_USR1(("MediaPlaybackLongDataUpdater:PluginUpdateRespMsg Default case option"));
                  }
                  break;
               }
            }
         }
      }
   }
   return false;
}


}// namespace Core
}// namespace App
