/* ***************************************************************************************
* FILE:          MediaGui.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  MediaGui.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "MediaGui.h"
#include "HMI/CGIComponents/AppViewSettings.h"
#include "HMI/CGIComponents/CGIApp.h"
#include "AppBase/IApplicationSettings.h"
#include "Common/AppBaseSettings/KeyMapping.h"

//////// TRACE IF ///////////////////////////////////////////////////
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_MAIN
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::MediaGui::
#include "trcGenProj/Header/MediaGui.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN
//////// TRACE IF ///////////////////////////////////////////////////

//                                   main surface,                                      video surface,                    popup surfaces
//(static_cast<int>(SURFACEID_MAIN_SURFACE_MEDIA), static_cast<int>(SURFACEID_MAIN_SURFACE_MEDIA), static_cast<int>(SURFACEID_TOP_POPUP_SURFACE_MEDIA), static_cast<int>(SURFACEID_CENTER_POPUP_SURFACE_MEDIA))
APPSETTINGS_BEGIN()
APPSETTINGS_ADD_MAINSURFACE(SURFACEID_MAIN_SURFACE_MEDIA),
                            APPSETTINGS_ADD_VIDEOSURFACE(SURFACEID_MAIN_SURFACE_MEDIA),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_TOP_POPUP_SURFACE_MEDIA),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_CENTER_POPUP_SURFACE_MEDIA),

                            APPSETTINGS_END();

using namespace ::hmi;

namespace App {
namespace Core {

/************************************************************************
*FUNCTION		: MediaGui
*DESCRIPTION	: constructor
*PARAMETER		: none
*RETURNVALUE	: none
************************************************************************/
MediaGui::MediaGui() : GuiComponentBase(hmi::apps::reference::appHmi_Media, appSettings)
{
   ETG_TRACE_USR1(("MediaGui::GuiComponentBase"));
   ETG_I_REGISTER_FILE();
   ETG_I_REGISTER_CHN(TraceCmd_NotProcessedMsg);
   _hmiAppCtrlProxyHandler.setTraceId(TR_CLASS_APPHMI_MEDIA_APPCTRL_PROXY);
   // direct texture // configure sync block connection for unique producer id on unique 'channel' 765
   SYNC_BLOCK_CONNECTION(765, MEDIA_GADGET);

   uint32 DisplayID_D1 = 1;// DisplayConfiguration::getInstance()->getPhysicalDisplayIdOfDisplayIndex(0);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_MAIN_SURFACE_MEDIA, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_TOP_POPUP_SURFACE_MEDIA, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_CENTER_POPUP_SURFACE_MEDIA, DisplayID_D1);
}


/************************************************************************
*FUNCTION		: ~MediaGui
*DESCRIPTION	: destructor
*PARAMETER		: none
*RETURNVALUE	: none
************************************************************************/
MediaGui::~MediaGui()
{
}


/************************************************************************
*FUNCTION		: getDefaultTraceClass
*DESCRIPTION	: returns the default trace class
*PARAMETER		: none
*RETURNVALUE	: int - default trace class ID
************************************************************************/
unsigned int MediaGui::getDefaultTraceClass()
{
   ETG_TRACE_USR1(("MediaGui::getDefaultTraceClass"));
   return TR_CLASS_APPHMI_MEDIA_MAIN;
}


/************************************************************************
*FUNCTION		: setupCgiInstance
*DESCRIPTION	: configures the asset file path
*PARAMETER		: none
*RETURNVALUE	: void
************************************************************************/
void MediaGui::setupCgiInstance()
{
   ETG_TRACE_USR1(("MediaGui::setupCgiInstance"));
   std::string assetFileName = hmibase::app::base::SystemConfiguration::getAssetFileName();
   setCgiApp(new CGIApp(assetFileName.c_str(), _hmiAppCtrlProxyHandler));
}


/************************************************************************
*FUNCTION		: preRun
*DESCRIPTION	:
*PARAMETER		: none
*RETURNVALUE	: void
************************************************************************/
void MediaGui::preRun()
{
   ETG_TRACE_USR1(("MediaGui::preRun"));
//   DP_vCreateDatapool();
   PersistentValuesRead();
}


/************************************************************************
*FUNCTION		: postRun
*DESCRIPTION	:
*PARAMETER		: none
*RETURNVALUE	: void
************************************************************************/
void MediaGui::postRun()
{
   ETG_TRACE_USR1(("MediaGui::postRun"));
   PersistentValuesWrite();// this is commented in MasterGui.cpp
}


/************************************************************************
*FUNCTION		: PersistentValuesRead
*DESCRIPTION	:
*PARAMETER		: none
*RETURNVALUE	: void
************************************************************************/
void MediaGui::PersistentValuesRead()
{
   ETG_TRACE_USR1(("MediaGui::PersistentValuesRead"));
//   dp_tclhmiAppMediaPersMemVarsMedia dp;
//   _mvar = dp.tGetData();
}


/************************************************************************
*FUNCTION		: PersistentValuesWrite
*DESCRIPTION	:
*PARAMETER		: none
*RETURNVALUE	: void
************************************************************************/
void MediaGui::PersistentValuesWrite()
{
   ETG_TRACE_USR1(("MediaGui::PersistentValuesWrite"));
//   dp_tclhmiAppMediaPersMemVarsMedia dp;
//   dp.s32SetData(_mvar);
}


/************************************************************************
*FUNCTION		: TraceCmd_NotProcessedMsg
*DESCRIPTION	: sink for not processed ttfis input messages
*PARAMETER		: data
*RETURNVALUE	: void
************************************************************************/
void MediaGui::TraceCmd_NotProcessedMsg(const unsigned char* data)
{
   ETG_TRACE_USR1(("MediaGui::TraceCmd_NotProcessedMsg"));
   if (data)
   {
      ETG_TRACE_USR4(("MediaGui::TraceCmd_NotProcessedMsg : 0x%*x", ETG_LIST_LEN(data[0]), ETG_LIST_PTR_T8(data)));
   }
}


ETG_I_CMD_DEFINE((TraceCmd_Test, "TraceCmd_Test %d", uint8))
void MediaGui::TraceCmd_Test(uint8 operationType)
{
   ETG_TRACE_USR4(("MediaGui::TraceCmd_Test operation type %d", operationType));
}


} // namespace Core
} // namespace App
