/**************************************************************************************
* @file         : <MediaDefines.h>
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : <AppHmi_media>
* @brief        :
* @copyright    : (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef MEDIADEFINES_H_
#define MEDIADEFINES_H_
#include <string>
#include <vector>
#include <stdint.h>
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"

#define szUSBConnectedstatus "USB device Connected";
#define szAppleDeviceConnectedstatus "Apple Device Connected";
#define szUSBNotConnectedstatus "No USB Device Connected";
#define szAppleNotDeviceConnectedstatus "No Apple Device Connected";
#define AuxText "%1"
#define BTAudioText "%1"
//#define FI_EN_E8DTY_SOURCESELECTIONSCREEN 12
//#define FI_EN_E8DTY_MEDIASETTINGSSCREEN 13
//#define FI_EN_E8DTY_MEDIALISTSCREEN 14
//#define FI_EN_E8DTY_MEDIAVIDEOFULLSCREEN 15
#define IPODText "IPOD"
#define USBText "USB"
#define MUTEText "%4"
#define NAM_REGION         0x00
#define EUR_REGION         0x06
#define SDCARD "%1"
#define IPOD "%2"
#define USB_NAME "USB"
#define BLUETOOTH "%1"
#define ExternalDVD "%1"
#define AUX "%1"
#define NOCANSIGNAL 65535
#define PLAY_BITMAP "Images#icon_play"
#define PAUSE_BITMAP "Images#icon_pause"
#define SUBSRCID_INVALID 255
#define MEDIA_BROWSE_LIST_VALUE 7

#define 	MTY_MUSIC_FILE		0x01
#define 	MTY_PODCAST			0x02
#define 	MTY_AUDIOBOOK		0x03
#define 	MTY_VIDEO			0x04
#define     MAX_SPEED           800
//Defined For the Play/Pause State
#define MEDIA_C_VALUE_ZERO  0
#define MEDIA_C_VALUE_ONE 1
#define MEDIA_C_VALUE_TWO 2
#define USB_ONE 1
#define USB_TWO 2
//#define MEDIA_COCKPIT_SINK  /*COCKPIT_SINK_ID 2*/ 1
//#define MEDIA_CABIN_A_SINK /*CABIN_A_SINK_ID 0*/ 2
//#define MEDIA_CABIN_B_SINK /*CABIN_B_SINK_ID 1*/ 3

#define MEDIA_VIDEO_DUMMY_SURFACEID 64
#define MEDIA_VIDEO_DUMMY_LAYERID 1001
#define MEDIA_VIDEO_LAYERID       3300
#define MAX_REG 2
#define REG_A 0
#define REG_B 1

enum GadgetSourceIconIndex
{
   GADGET_SRC_ICON_IDX_USB = 0,
   GADGET_SRC_ICON_IDX_IPOD,
   GADGET_SRC_ICON_IDX_AUX,
   GADGET_SRC_ICON_IDX_BT,
   GADGET_SRC_ICON_IDX_HDMI,
   GADGET_SRC_ICON_IDX_HDMI2,
   GADGET_SRC_ICON_IDX_HDMI3,
   GADGET_SRC_ICON_IDX_USBCAMPORT,
   GADGET_SRC_ICON_IDX_ROUTER
};


//Defined for Shuffle
#define MEDIA_C_ONE  1

#define SHUFFLE_OFF 0
#define SHUFFLE_ON  MEDIA_C_ONE

#define DEFAULT_SKIP_COUNT  1
#define MEDIA_C_ETA_BUFFER_SIZE 10

#define TIME_BUFFER_SIZE 12
#define ZERO 0

#define ALBUMARTWIDTH 123
#define ALBUMARTHEIGHT 159

#define PODCAST_NOWPLAY_ICON_UPDATE  1
#define AUDIOBOOK_NOWPLAY_ICON_UPDATE  2
#define IPOD_NOWPLAY_ICON_UPDATE  3

#define INVALID_LIST_TYPE 		   (255)


static const uint32_t ALBUMART_WIDTH_FOR_INF4CV = 256;
static const uint32_t ALBUMART_HEIGHT_FOR_INF4CV = 256;

struct stDeviceInfo
{
   tU8	  u8DeviceTag;
   tU8	  u8DeviceType;
   bool  bDeviceActiveSource;
};


struct stSourceListDetails
{
   int deviceType;
   Candera::String deviceText;
   int sourceIconIdx;
   int srcId;
};


struct stNowPlayingInfo
{
   std::string ArtistName;
   std::string TitleName;
   std::string AlbumName;
   uint32_t MediaFileType;
   std::string CurrentTrackNumber;
   uint8_t CurrentPlayingDeviceType;
   std::string TotalTime;
   uint8_t LastDeviceType;
   uint32_t MediaCategoryType;
};


struct stDeviceConnectionInfo
{
   std::string sName;
   uint8_t  u8DeviceTag;
   bool bConnectedStatus;
   bool bIsActive;
   uint32_t u32PlayableFiles;
   bool bRepeatSupported;
   bool bShuffleSupported;
   int disconnectReason;
   int devNum;
};


struct StrListInfoIF
{
   uint32_t ListType;
   uint32_t ParentListHandle;
   uint32_t Position;
   uint32_t Size;
};


enum SystemCategory
{
   SYS_CATEGORY_NONE = 0,
   SYS_CATEGORY_CMC = 1,
   SYS_CATEGORY_CMA = 2,
   SYS_CATEGORY_CMR = 5,
   SYS_CATEGORY_CMP1 = 6,
   SYS_CATEGORY_CMP2 = 7,
   SYS_CATEGORY_CMP3 = 8,
   SYS_CATEGORY_CMGA = 9,
   SYS_CATEGORY_CMGA2 = 10
};


enum SystemPosition
{
   EN_POSITION_PRIMARY = 1,
   EN_POSITION_SECONDARY,
   EN_POSITION_TERTIARY
};


enum SystemsInfoAcknowledgement
{
   EN_ACKNOWLEDGEMENT_NEW = 0,
   EN_ACKNOWLEDGEMENT_ONGOING = 1
};


enum ActiveSources
{
   INTERNALSOURCE,
   CAMPORTUSB,
   CAMPORTHDMI,
   ROUTERUSB
};


enum eSource
{
   E_SOURCE_DEFAULT = -1,
   E_SOURCE_TUNER = 0,
   E_SOURCE_MEDIA = 1,
   E_SOURCE_MAX
};


enum eDeviceSourceList
{
   EN_SOURCELIST_IPHONE = 0,
   EN_SOURCELIST_BLUETOOTH,
   EN_SOURCELIST_USB1,
   EN_SOURCELIST_USB2,
   EN_SOURCELIST_AUX
};


enum eIconIndex
{
   EN_ICON_IPHONE = 0,
   EN_ICON_BLUETOOTH,
   EN_ICON_USB1,
   EN_ICON_USB2,
   EN_ICON_AUX,
   EN_ICON_USBCAMERAPORT,
   EN_ICON_USBCAMERAPORTHDMI,
   EN_ICON_USBCAMERAPORTHDMI2,
   EN_ICON_USBCAMERAPORTHDMI3,
   EN_ICON_ROUTER_USB
};


enum eDeviceCabinSourceList
{
   EN_CABINSOURCELIST_ROUTER_USB = 0,
   EN_CABINSOURCELIST_USBCAMPORT,
   EN_CABINSOURCELIST_USBCAMPORTHDMI,
   EN_CABINSOURCELIST_USBCAMPORTHDMI_2,
   EN_CABINSOURCELIST_USBCAMPORTHDMI_3,
   EN_CABINSOURCELIST_USB1,
   EN_CABINSOURCELIST_USB2,
   EN_CABINSOURCELIST_BLUETOOTH,
   EN_CABINSOURCELIST_IPHONE
};


enum ExternalMediaRepeatShuffleModes
{
   EXT_REPEAT_SHUFFLE_OFF = 0,
   EXT_REPEAT_TRACK = 1,
   EXT_REPEAT_LIST = 2,
   EXT_SHUFFLE_LIST = 3,
};


struct stActiveDeviceInfo
{
   int activeSource;   //camport src (or) INTERNALSOURCE src
   int deviceGroup;    //device of media, 1 for usb, iPod, 4 for BT etc
   int source;         //media or tuner, eSource
   std::string ArtistName;
   std::string TitleName;
   std::string AlbumName;
   int CurrentDevType;
   uint8_t playPauseState;
   std::string strAlbumArt;
//    int currentPlayingSource;
//    int iRegion;
//    uint32_t TotalPlayTime;
};


enum tenMediaRepeatMode
{
   EN_MEDIA_REPEATMODE_OFF,
   EN_MEDIA_REPEATMODE_TRACK,
   EN_MEDIA_REPEATMODE_LIST
};


enum enPageDirection
{
   EN_MEDIATAB_PAGEUP,
   EN_MEDIATAB_DOWN
};


enum enHorizontalListIndex
{
   EN_MEDIA_INDEX0,
   EN_MEDIA_INDEX3 = 3,
   EN_MEDIA_INDEX5 = 5,
   EN_MEDIA_INDEX6 = 6
};


enum MediaTab
{
   TAB_TITLE = 0,
   TAB_ARTIST,
   TAB_ALBUM,
   TAB_GENRE,
   TAB_FOLDER,
   TAB_PLAYLIST,
   TAB_AUDIOBOOK,
   TAB_PODCAST,
   TAB_VIDEO,
   TAB_VIDEO_LANGUAGE
};


enum MediaItems
{
   ARTIST = 0,
   TITLE,
   ALBUM
};


enum MediaListSize
{
   szTITLE = 0,
   szARTIST,
   szALBUM,
   szGENRE,
   szFOLDER,
   szPLAYLIST,
   szAUDIOBOOK,
   szPODCAST,
   szVIDEO
};


enum MediaTypes
{
   OFF = 0,
   SHUFFLE = 1,
   REPEAT = 2,
   NORMAL = 3,
};


enum PopupMediaIconIdx
{
   POPUP_IDX_USB_ICON = 0,
   POPUP_IDX_IPOD_ICON,
};


enum ExternalMediaTypes
{
   EXT_NORMAL = 0,
   EXT_SHUFFLE = 1,
   EXT_REPEAT = 2,
};


enum ExternalMediaDownloadIcon
{
   EXT_DOWNLOAD_FAILURE = 0,
   EXT_DOWNLOAD_LOADING,
   EXT_DOWNLOAD_DEFAULT
};


enum ExternalRouterDBState
{
   EXT_CMR_DB_INVALID = 0,
   EXT_CMR_DB_INPREPARATION,
   EXT_CMR_DB_VALID,
};


enum ExternalMediaPlayBackActionTypes
{
   EXT_MEDIA_PLAY = 0,
   EXT_MEDIA_PAUSE = 1,
   EXT_MEDIA_PREVIOUS = 3,
   EXT_MEDIA_NEXT = 4,
   EXT_MEDIA_SOURCEACTIVE = 5,
   MEDIA_VIDEOSOURCERESTORE = 6,
   EXT_MEDIA_SHUFFLE = 8,
};


enum MediaPlayBackActionTypes
{
   Media_Play = 0,
   Media_Pause = 1,
   MEDIA_PREVIOUS = 3,
   MEDIA_NEXT = 4,
   MEDIA_FREW_START = 5,
   MEDIA_FREW_STOP = 6,
   MEDIA_FFWD_START = 7,
   MEDIA_FFWD_STOP = 8,
};


enum StatemachineStates
{
   IDLE,
   WAITING_PLAYERINDEX_METHODRESULT,
   WAITING_PLAYERINDEXLISTSLICE_METHODRESULT,
   LIST_REQUEST_PROCESS_DONE
};


enum SourceList
{
   USB1,
   USB2,
   IPHONE,
   BT,
   CAMPORT1USB,
   CAMPORT1HDMI
};


enum ParkBrakeStatus
{
   PARKING_BRAKE_DISENG = 0,
   PARKING_BRAKE_ENG,
   PARKING_BRAKE_ERR,
   PARKING_BRAKE_SNA
};


enum MediaTrackCommandTypes
{
   TrackCommand_Pause = 0,
   TrackCommand_Play = 2,
   TrackCommand_Next = 3,
   TrackCommand_Previous = 4,
   TrackCommand_FastForward = 5,
   TrackCommand_FastBackward  = 6,
   TrackCommand_RandomRepeatOFF = 9,
   TrackCommand_RepeatTrack = 10,
   TrackCommand_RepeatAll = 11,
   TrackCommand_RandomAll = 13,
   TrackCommand_NotAvailable = 15
};


struct SourcePrioDetails
{
   int sourceId;
   int sourceTag;
};


typedef struct
{
   std::string szTitleName;
   std::string szArtistName;
} media_TitleListInfo;

typedef struct
{
   std::string szTitleName;
   std::string szArtistName;
} media_AlbumSongListInfo;

typedef struct
{
   std::string szFirstText;
   std::string szSecondText;
} media_TwoTextListInfo;

typedef struct
{
   uint32_t m_u32ListHandle;
   std::string m_szFileInfo;
   uint32_t m_u32ListSize;
   uint32_t m_u32SrcListtype;
} trMPlay_FolderListItem;

typedef struct
{
   std::vector<trMPlay_FolderListItem, std::allocator<trMPlay_FolderListItem> > oFileList;
} trMplay_FolderList;
typedef struct
{
   tU8 u8DeviceHandle;
   std::string szDeviceName;
   bool bDeviceConnectedStatus;
   bool bOSDStatus;
} media_BTPairedDeviceInfo;

#define MPLAY_SLICE_INFO_LENGTH    256
// =========================================================================
enum TenBTMajorDeviceClass
{
   BTPHN_EN_MAJOR_DEVICE_CLASS_PHONE = 0,
   BTPHN_EN_MAJOR_DEVICE_CLASS_AUDIOVIDEO = 1,
   BTPHN_EN_MAJOR_DEVICE_CLASS_COMPUTER = 2,
   BTPHN_EN_MAJOR_DEVICE_CLASS_LANORNAP = 3
};


enum MediaGadgetIndex
{
   INTERNAL_GADGET_INDEX = 0,
   USBCAMPORT_GADGET_INDEX = 1,
   HDMI_GADGET_INDEX = 2,
   NO_MEDIA_DEVICE_GADGET_INDEX = 3,
   ROUTER_GADGET_INDEX = 4,
   RESTORATION_TEXT_INDEX = 5
};


enum enCANMediaSeekStates
{
   CAN_INACTIVE = 0,
   CAN_FAST_FORWARD = 1,
   CAN_FAST_REWIND = 2
};


typedef struct
{
   tU8 u8DeviceHandle;
   TenBTMajorDeviceClass enMajorDeviceClass;
   bool bHandsFreeSupport;
   bool bAudioStreamingSupport;
} media_BTDeviceSupportInfo;

typedef struct audioutility
{
   int srcid;
   int subsrcid;
} media_AudioUtility;
#define LIST_TYPE_FOLDER           (31)
#define LIST_TYPE_FILE             (32)
#define INVALID_VALUE_MEDIA        (255)
#define PLAY_SONG_IN_LIST		   (11)

#define META_DATA_TAG_UNKNOWN 0
#define META_DATA_TAG_ONE 1
#define META_DATA_TAG_TWO 2
#define META_DATA_TAG_THREE 3
#define META_DATA_TAG_FOUR 4

#define MAX_FOLDER_DEPTH_SUPPORTED (11+1)
#define MEDIA_LISTTYPE_INVALID		255
#define MEDIA_VIDEO "MEDIA_VIDEO"
#define NO_DEVICE 0
#define SOURCE_VISIBLE 1
#define SOURCE_INVISIBLE 0
#define SOURCE_AVAIL 1
#define SOURCE_UNAVAIL 0
#define EXTERNAL_SOURCE_SUBSRCID -1
#define NO_MEDIA_DEVICE 0
#define HDMI_KDS_AVAIL 1
#define DEFAULT_SPEED_VALUE 65535


#endif /* MEDIADEFINES_H_ */
