/**************************************************************************************
 * @file         : MediaListInterfaceClientHandler.cpp
 * @author       : RBEI/ECG5-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 *21.09.17 Rev. 0.1 Ruchi (RBEI/ECG5)
 * 		  			Initial Revision.
 **************************************************************************************/

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "hall_std_if.h"
#endif
#include "Core/MediaClientHandler/MediaClientHandler.h"
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "Core/Utils/MediaUtils.h"
#include "Core/MediaDefines.h"
#include "Core/StateTransitionHandler/StateTransitionHandler.h"
#include "Core/ApplicationSwitchClientHandler/ApplicationSwitchClientHandler.h"

using namespace MPlay_fi_types;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::tclMediaClientHandler::
#include "trcGenProj/Header/MediaListInterfaceClientHandler.cpp.trc.h"
#endif

#endif

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#include "utest/stubs/MPlay_fi_types.h"
#include "utest/stubs/EnumData.h"
using namespace MPlay_fi_types;
#endif

namespace App {
namespace Core {

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST

static const Courier::ViewId		IdScene_AlbumLoading = Courier::ViewId("Media#MediaPlayer_Pop_Up#Pfo_WaitScene");
static const Courier::Identifier	IdRotation_AlbumLoading = Courier::Identifier("AnimationWidget2D_Wait");
FeatStd::TextId id45("0x0004");//Browse TextMapping
/**
* onMediaPlayerListChangeError - function called whenever mediaplayer error while updating the list during indexing
*
* @param[in] proxy
* @param[in] error
* @return void
*/
void tclMediaClientHandler::onMediaPlayerListChangeError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerListChangeError >& /*error*/)
{
   ETG_TRACE_USR4(("tclMediaClientHandler::onMediaPlayerListChangeError"));
}


/**
* onMediaPlayerListChangeStatus - function called whenever mediaplayer updates the list during indexing
*
* @param[in] proxy
* @param[in] status
* @return void
*/
void tclMediaClientHandler::onMediaPlayerListChangeStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy, const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerListChangeStatus >& status)
{
   ETG_TRACE_USR4(("tclMediaClientHandler::onMediaPlayerListChangeStatus listhandle = %d listsize = %d and listchangeType %d", status->getU32ListHandle(), status->getU32ListSize(), status->getE8Change()));
   uint32 listHandle = 0xFFFFFFFF;
   uint32 listSize = 0;
   //int m_currentListType;
   if (_listMap.count(m_u32CurrentListType))
   {
      listHandle = _listMap[m_u32CurrentListType]->u32GetListHandle();
      listSize = _listMap[m_u32CurrentListType]->u32GetListSize();
      ETG_TRACE_USR4(("tclMediaClientHandler::onMediaPlayerListChangeStatus current listhandle = %d currentlistsize = %d currentListType = %d", listHandle, listSize, m_u32CurrentListType));
      if (listHandle == status->getU32ListHandle() && (status->getE8Change() == T_e8_MPlayChange__e8LCH_CONTENT_CHANGED))
      {
         _listMap[m_u32CurrentListType]->vSetListSize(status->getU32ListSize());
         HMIModelListImplementation::getInstance().UpdateCurrentListSize(status->getU32ListSize(), m_u32CurrentListType);
         ETG_TRACE_USR4(("tclMediaClientHandler::onMediaPlayerListChangeStatus current listsize after updation  %d", _listMap[m_u32CurrentListType]->u32GetListSize()));
         ETG_TRACE_USR4(("tclMediaClientHandler::onMediaPlayerListChangeStatus m_u32CurrentListType = %d,m_windowStartIndex =%d,m_windowSize = %d ", m_u32CurrentListType, m_windowStartIndex, m_windowSize));

         if ((m_u32CurrentListType == LIST_TYPE_FOLDER) || (m_u32CurrentListType == LIST_TYPE_FILE))
         {
            requestFolderSliceList(m_windowStartIndex, m_windowSize);
         }
         else
         {
            requestMediaPlayerSliceList(m_windowStartIndex, m_windowSize);
         }
      }
   }
}


/************************************************************************
*FUNCTION		: onCreateMediaPlayerIndexedListError
*DESCRIPTION	: called if CreateMediaPlayerIndexedList property is updated with error from media player
*PARAMETER		: proxy
*PARAMETER		: error
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::onCreateMediaPlayerIndexedListError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
      const boost::shared_ptr< ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedListError >& error)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::onCreateMediaPlayerIndexedListError"));
}


/************************************************************************
*FUNCTION		: onCreateMediaPlayerIndexedListResult
*DESCRIPTION	: called on getting result for CreateMediaPlayerIndexedList property from media player
*PARAMETER		: proxy
*PARAMETER		: result
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::onCreateMediaPlayerIndexedListResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
      const boost::shared_ptr< ::mplay_MediaPlayer_FI::CreateMediaPlayerIndexedListResult >& result)
{
   if (m_listReqAct != result->getAct())
   {
      ETG_TRACE_ERR(("Request and response does not match"));
      return;
   }
   createInstanceIfNull(m_u32CurrentListType);
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onCreateMediaPlayerIndexedListResult CurrentListType :%d", m_u32CurrentListType));

   if (_listMap.count(m_u32CurrentListType))
   {
      uint32 currentListHandle = result->getU32ListHandle();
      HMIModelListImplementation::getInstance().updateListHandle(currentListHandle);
      _listMap[m_u32CurrentListType]->vSetListHandle(result->getU32ListHandle());
      _listMap[m_u32CurrentListType]->vSetListSize(result->getU32ListSize());
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onCreateMediaPlayerIndexedListResult:CurrentListHandle = %d , CurrentListSize = %d"
                      , _listMap[m_u32CurrentListType]->u32GetListHandle(), _listMap[m_u32CurrentListType]->u32GetListSize()));

      HMIModelListImplementation::getInstance().UpdateCurrentListSize(_listMap[m_u32CurrentListType]->u32GetListSize(), m_u32CurrentListType);

      requestNewListEntry();

      if (_listMap[m_u32CurrentListType]->u32GetListSize() > 0)
      {
         vTriggertStatemachine();
      }
      else
      {
         /*initStatemachine();
         if (HMIModelListImplementation::getInstance().getIsNewList())
         {
            HMIModelListImplementation::getInstance().IsNewList(false);
            ::Courier::Message* poNewListEntry = NULL;
            poNewListEntry = COURIER_MESSAGE_NEW(::NewListEntryMsg)();
            poNewListEntry->Post();
         }*/
         vClearListDataOnSizeEmpty();
      }
   }
   else
   {
      ETG_TRACE_USR1(("MediaListInterfaceClientHandler::onCreateMediaPlayerIndexedListResult List is not added in _ListMap"));
   }
}


/************************************************************************
*FUNCTION		: onPlayItemFromListByTagError
*DESCRIPTION	: function called when mediaplayer gets a error during the method call of PlayItemFromListByTagStart.
*PARAMETER		: proxy,error
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::onPlayItemFromListByTagError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
      const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlayItemFromListByTagError >& error)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::onPlayItemFromListByTagError"));
}


/************************************************************************
*FUNCTION		: onPlayItemFromListByTagResult
*DESCRIPTION	: function called when mediaplayer gets a result during the method call of PlayItemFromListByTagStart.
*PARAMETER		: proxy,result
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::onPlayItemFromListByTagResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
      const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::PlayItemFromListByTagResult >& result)
{
   if (m_listReqAct != result->getAct())
   {
      ETG_TRACE_ERR(("Request and response does not match"));
      return;
   }
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onPlayItemFromListByTagResult CurrentListType: %d", m_u32CurrentListType));
   if (m_u32CurrentListType == SM_MEDIA_LISTTYPE_VIDEO_EPISODE)
   {
      StateTransitionHandler::getInstance().setStateTransitionReason(ST_TRANSITION_REASON_SONG_SELECT_IN_LIST);
   }
}


/************************************************************************
*FUNCTION		: onReleaseMediaPlayerListError
*DESCRIPTION	: function called when mediaplayer gets a error during the method call of ReleaseMediaPlayer.
*PARAMETER		: proxy,error
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::onReleaseMediaPlayerListError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::ReleaseMediaPlayerListError >& /*error*/)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::onReleaseMediaPlayerListError"));
}


/************************************************************************
*FUNCTION		: onReleaseMediaPlayerListResult
*DESCRIPTION	: function called when mediaplayer gets a result during the method call of ReleaseMediaPlayer.
*PARAMETER		: proxy,error
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::onReleaseMediaPlayerListResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
      const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::ReleaseMediaPlayerListResult >& result)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::onReleaseMediaPlayerListResult"));
}


/************************************************************************
*FUNCTION		: BrowseListReqMsg
*DESCRIPTION	: Is called when the ListButton Group is touched in the NowPlaying Screen
*PARAMETER		: oMsg
*RETURNVALUE	: bool
*SWFL			: [SYSFL-2758]
************************************************************************/
bool tclMediaClientHandler::onCourierMessage(const BrowseListReqMsg& oMsg)
{
   //vReleaseMediaplayerListHandle(m_u32ParentListType);
   g_SM_InitialTabLoading = 1;
   //vReleaseMediaplayerListHandle(m_u32CurrentListType);
   m_u32CurrentListType = oMsg.GetG_SM_ListType();
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onCourierMessage:BrowseListReqMsg CurrentListType:%d", m_u32CurrentListType));
   m_u32SelectedIndex = 0;
   initStatemachine();
   vTriggertStatemachine();
   return true;
}


/************************************************************************
*FUNCTION:		AnimationWidgetIndMsg
*DESCRIPTION:	This is a courier message to rotate the busy animation widget in the clockwise direction
*PARAMETER:		oMsg : oMsg value as obtained from courier message
* Bug:269262
*RETURNVALUE:	tVoid
*

************************************************************************/

bool tclMediaClientHandler::onCourierMessage(const AnimationWidgetIndMsg& oMsg)
{
   ETG_TRACE_USR4(("tclMediaClientHandler::AnimationWidgetIndMsg"));

   if (IdScene_AlbumLoading == oMsg.GetView())
   {
      ETG_TRACE_USR4(("tclMediaClientHandler::AnimationWidgetIndMsg : IdScene_AlbumLoading"));
      if (IdRotation_AlbumLoading == oMsg.GetSender())
      {
         ETG_TRACE_USR4(("tclMediaClientHandler::AnimationWidgetIndMsg : IdRotation_AlbumLoading"));
         POST_MSG((COURIER_MESSAGE_NEW(AnimationWidgetReqMsg)(Courier::AnimationAction::Start, IdScene_AlbumLoading, IdRotation_AlbumLoading)));
         return true;
      }
      else
      {
         ETG_TRACE_USR4(("tclMediaClientHandler::AnimationWidgetIndMsg calllist Widget not matching"));
      }
   }
   else
   {
      ETG_TRACE_USR4(("tclMediaClientHandler::AnimationWidgetIndMsg View not matching"));
   }
   return false;
}


/************************************************************************
*FUNCTION		: vTriggertStatemachine
*DESCRIPTION	: Sets the State of the List
*PARAMETER		: void
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::vTriggertStatemachine()
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vTriggertStatemachine CurrentState = %d ", m_currentListState));

   switch (m_currentListState)
   {
      case IDLE:
      {
         if ((m_u32CurrentListType == LIST_TYPE_FOLDER) || (m_u32CurrentListType == LIST_TYPE_FILE))
         {
            //clear the folderlist when Folder tab is selected.
            if (m_u32CurrentListType == LIST_TYPE_FOLDER)
            {
               m_oMPlayHistoryFolderList.oFileList.clear();
               m_oMPlayParentFolderList.oFileList.clear();
            }

            RequestFolderList(m_u32SelectedIndex);
         }
         else
         {
            RequestMediaPlayerIndexedList(m_u32CurrentListType, m_u32SelectedIndex);
         }

         m_currentListState = WAITING_PLAYERINDEX_METHODRESULT;
         break;
      }
      case WAITING_PLAYERINDEX_METHODRESULT:
      {
         if ((m_u32CurrentListType == LIST_TYPE_FOLDER) || (m_u32CurrentListType == LIST_TYPE_FILE))
         {
            requestFolderSliceList(m_windowStartIndex, m_windowSize);
         }
         else
         {
            requestMediaPlayerSliceList(m_windowStartIndex, m_windowSize);
         }

         m_currentListState = WAITING_PLAYERINDEXLISTSLICE_METHODRESULT;
         break;
      }
      case WAITING_PLAYERINDEXLISTSLICE_METHODRESULT:
      {
         m_currentListState = LIST_REQUEST_PROCESS_DONE;
         break;
      }
      default:
         break;
   }
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vTriggertStatemachine m_CurrentState = %d", m_currentListState));
}


/************************************************************************
*FUNCTION		: initStatemachine
*DESCRIPTION	: Clears the state of the List
*PARAMETER		: void
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::initStatemachine()
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::initStatemachine currentListState : %d", m_currentListState));
   if (m_currentListState == LIST_REQUEST_PROCESS_DONE)
   {
      m_currentListState = WAITING_PLAYERINDEX_METHODRESULT;
   }
   else if (m_currentListState != WAITING_PLAYERINDEXLISTSLICE_METHODRESULT)
   {
      m_currentListState = IDLE;
   }
}


/************************************************************************
*FUNCTION		: vClearListDataOnSizeEmpty
*DESCRIPTION	: Clears the data of the List based on the current listtype
*PARAMETER		: void
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::vClearListDataOnSizeEmpty()
{
   vClearListInModel(LISTID_MEDIA_TITLE);
}


/************************************************************************
*FUNCTION		: vClearListInModel
*DESCRIPTION	: Update the List in the model component with empty data
*PARAMETER		: u32CurrentListId
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::vClearListInModel(uint32_t u32CurrentListId)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vClearListInModel currentlistid:%d", u32CurrentListId));
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vClearListInModel CurrentListType:%d", m_u32CurrentListType));

   ListDataProviderBuilder listBuilder(u32CurrentListId);
   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   if ((m_u32CurrentListType == SM_MEDIA_LISTTYPE_SONG) || (m_u32CurrentListType == SM_MEDIA_LISTTYPE_ARTIST) || (m_u32CurrentListType == SM_MEDIA_LISTTYPE_ALBUM)
         || (m_u32CurrentListType == SM_MEDIA_LISTTYPE_GENRE) || (m_u32CurrentListType == SM_MEDIA_LISTTYPE_FOLDER) || (m_u32CurrentListType == SM_MEDIA_LISTTYPE_PLAYLIST)
         || (m_u32CurrentListType == SM_MEDIA_LISTTYPE_PODCAST) || (m_u32CurrentListType == SM_MEDIA_LISTTYPE_AUDIOBOOK) || (m_u32CurrentListType == SM_MEDIA_LISTTYPE_VIDEO))
   {
      HMIModelListImplementation::getInstance().populateEmptyList(false);
   }
   else
   {
      HMIModelListImplementation::getInstance().populateEmptyList(true);
   }
   POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
   HMIModelListImplementation::getInstance().setWaitAnimationState(ANIMATION_STOP);
}


void tclMediaClientHandler::vClearListHandle()
{
   vReleaseMediaplayerListHandle(m_u32CurrentListType);
}


/************************************************************************
*FUNCTION		: RequestMediaPlayerIndexedList
*DESCRIPTION	: Calls a sendCreateMediaPlayerIndexedListStart with ListType and DeviceTag to the service
*PARAMETER		: ListType
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::RequestMediaPlayerIndexedList(uint8 ListType, uint32 Index)
{
   uint32_t filterTag1 = 0;
   uint32_t filterTag2 = 0;
   uint32_t filterTag3 = 0;
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::RequestMediaPlayerIndexedList ListType:%d,index:%d", ListType, Index));

   switch (ListType)
   {
      /* case T_e8_MPlayListType__e8LTY_GENRE_ARTIST:
       {
          if (_listMap.count(T_e8_MPlayListType__e8LTY_GENRE))
          {
             filterTag1 = _listMap[T_e8_MPlayListType__e8LTY_GENRE]->u32GetActiveItemTag();
          }

          break;
       }
      case T_e8_MPlayListType__e8LTY_GENRE_ARTIST_ALBUM:
      {
         if (_listMap.count(T_e8_MPlayListType__e8LTY_GENRE))
         {
            filterTag1 = _listMap[T_e8_MPlayListType__e8LTY_GENRE]->u32GetActiveItemTag();
         }
         if (_listMap.count(T_e8_MPlayListType__e8LTY_GENRE_ARTIST))
         {
            filterTag2 = _listMap[T_e8_MPlayListType__e8LTY_ARTIST]->u32GetActiveItemTag();
         }

         break;
      }

      case T_e8_MPlayListType__e8LTY_GENRE_ARTIST_ALBUM_SONG:
      {
         //Tag2 = selectedArtistTag;
         if (_listMap.count(T_e8_MPlayListType__e8LTY_GENRE))
         {
            filterTag1 = _listMap[T_e8_MPlayListType__e8LTY_GENRE]->u32GetActiveItemTag();
         }
         if (_listMap.count(T_e8_MPlayListType__e8LTY_ARTIST))
         {
            filterTag2 = _listMap[T_e8_MPlayListType__e8LTY_ARTIST]->u32GetActiveItemTag();
         }
         if (_listMap.count(T_e8_MPlayListType__e8LTY_ALBUM))
         {
            filterTag3 = _listMap[T_e8_MPlayListType__e8LTY_ALBUM]->u32GetActiveItemTag();
         }

         break;
      }
      case T_e8_MPlayListType__e8LTY_GENRE_ARTIST_SONG:
      {
         //Tag2 = selectedArtistTag;
         if (_listMap.count(T_e8_MPlayListType__e8LTY_GENRE))
         {
            filterTag1 = _listMap[T_e8_MPlayListType__e8LTY_GENRE]->u32GetActiveItemTag();
         }
         if (_listMap.count(T_e8_MPlayListType__e8LTY_ARTIST))
         {
            filterTag2 = _listMap[T_e8_MPlayListType__e8LTY_ARTIST]->u32GetActiveItemTag();
         }

         break;
      }*/
      case T_e8_MPlayListType__e8LTY_GENRE_ALBUM:
      {
         if (_listMap.count(T_e8_MPlayListType__e8LTY_GENRE))
         {
            filterTag1 = _listMap[T_e8_MPlayListType__e8LTY_GENRE]->u32GetActiveItemTag();
         }

         break;
      }
      case T_e8_MPlayListType__e8LTY_GENRE_ALBUM_SONG:
      {
         //Tag2 = selectedArtistTag;
         if (_listMap.count(T_e8_MPlayListType__e8LTY_GENRE))
         {
            filterTag1 = _listMap[T_e8_MPlayListType__e8LTY_GENRE]->u32GetActiveItemTag();
         }
         if (_listMap.count(T_e8_MPlayListType__e8LTY_ALBUM))
         {
            filterTag3 = _listMap[T_e8_MPlayListType__e8LTY_ALBUM]->u32GetActiveItemTag();
         }
         break;
      }

      case T_e8_MPlayListType__e8LTY_GENRE_SONG:
      {
         //Tag2 = selectedArtistTag;
         if (_listMap.count(T_e8_MPlayListType__e8LTY_GENRE))
         {
            filterTag1 = _listMap[T_e8_MPlayListType__e8LTY_GENRE]->u32GetActiveItemTag();
         }
         break;
      }
      case T_e8_MPlayListType__e8LTY_ARTIST_ALBUM:
      {
         if (_listMap.count(T_e8_MPlayListType__e8LTY_ARTIST))
         {
            filterTag2 = _listMap[T_e8_MPlayListType__e8LTY_ARTIST]->u32GetActiveItemTag();
         }
         break;
      }
      case T_e8_MPlayListType__e8LTY_ARTIST_ALBUM_SONG:
      {
         //Tag2 = selectedArtistTag;
         if (_listMap.count(T_e8_MPlayListType__e8LTY_ARTIST))
         {
            filterTag2 = _listMap[T_e8_MPlayListType__e8LTY_ARTIST]->u32GetActiveItemTag();
         }
         if (_listMap.count(T_e8_MPlayListType__e8LTY_ALBUM))
         {
            filterTag3 = _listMap[T_e8_MPlayListType__e8LTY_ALBUM]->u32GetActiveItemTag();
         }

         break;
      }
      case T_e8_MPlayListType__e8LTY_ARTIST_SONG:
      {
         if (_listMap.count(T_e8_MPlayListType__e8LTY_ARTIST))
         {
            filterTag2 = _listMap[T_e8_MPlayListType__e8LTY_ARTIST]->u32GetActiveItemTag();
         }
         break;
      }

      case T_e8_MPlayListType__e8LTY_ALBUM_SONG:
      {
         if (_listMap.count(T_e8_MPlayListType__e8LTY_ALBUM))
         {
            filterTag2 = _listMap[T_e8_MPlayListType__e8LTY_ALBUM]->u32GetActiveItemTag();
         }
         break;
      }

      case T_e8_MPlayListType__e8LTY_BOOKTITLE_CHAPTER:
      {
         if (_listMap.count(T_e8_MPlayListType__e8LTY_AUDIOBOOK))
         {
            filterTag2 = _listMap[T_e8_MPlayListType__e8LTY_AUDIOBOOK]->u32GetActiveItemTag();
         }
         break;
      }

      case T_e8_MPlayListType__e8LTY_PLAYLIST_SONG:
      {
         if (_listMap.count(T_e8_MPlayListType__e8LTY_PLAYLIST))
         {
            filterTag1 = _listMap[T_e8_MPlayListType__e8LTY_PLAYLIST]->u32GetActiveItemTag();
         }
         break;
      }

      case T_e8_MPlayListType__e8LTY_VIDEO_EPISODE:
      {
         if (_listMap.count(T_e8_MPlayListType__e8LTY_VIDEO))
         {
            filterTag1 = _listMap[T_e8_MPlayListType__e8LTY_VIDEO]->u32GetActiveItemTag();
         }
         break;
      }

      case T_e8_MPlayListType__e8LTY_PODCAST_EPISODE:
      {
         if (_listMap.count(T_e8_MPlayListType__e8LTY_PODCAST))
         {
            filterTag1 = _listMap[T_e8_MPlayListType__e8LTY_PODCAST]->u32GetActiveItemTag();
         }
         break;
      }
      default:
         break;
   }
   SetFileInfoStr("Browse");
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::RequestMediaPlayerIndexed List->Tag1 = %d,Tag2 = %d,Tag3 = %d,ListType = %d m_u32DeviceTag = %d)", filterTag1, filterTag2, filterTag3, ListType, m_u8CurrentDeviceTag));
   m_listReqAct = _mediaPlayerProxy->sendCreateMediaPlayerIndexedListStart(*this, (::MPlay_fi_types::T_e8_MPlayListType)ListType, filterTag1, filterTag2, filterTag3, m_u8CurrentDeviceTag);
}


/************************************************************************
*FUNCTION		: RequestFolderList
*DESCRIPTION	: Calls a sendCreateMediaPlayerIndexedListStart with ListType and DeviceTag to the service
*PARAMETER		: m_u32SelectedIndex
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::RequestFolderList(uint32 m_u32SelectedIndex)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::RequestFolderList:SelectedIndex:%d", m_u32SelectedIndex));

   uint32 u32Size = m_oMPlayHistoryFolderList.oFileList.size();
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::RequestFolderList Size:%d", u32Size));
   std::string currentFolderPath;
   uint8 u8activeRegion = ApplicationSwitchClientHandler::poGetInstance()->getActiveRegion();

   if (u32Size > 0)
   {
      m_u8Filetype = _oFileListMediaObjects[m_u32SelectedIndex].getE8FileType();
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::RequestFolderList u8Filetype:%d", m_u8Filetype));
      SetFileInfoStr(m_oMPlayHistoryFolderList.oFileList[u32Size - 1].m_szFileInfo);

      if (m_u8Filetype == MPlay_fi_types::T_e8_MPlayFileType__e8FT_PLAYLIST)
      {
         currentFolderPath = m_oMPlayHistoryFolderList.oFileList[u32Size - 1].m_szFileInfo;
         ETG_TRACE_USR4(("MediaListInterfaceClientHandler::RequestFolderList u8Filename:%s", _oFileListMediaObjects[m_u32SelectedIndex].getSFilename().c_str()));
         ETG_TRACE_USR4(("MediaListInterfaceClientHandler::RequestFolderList u8Filepath:%s", m_oMPlayHistoryFolderList.oFileList[u32Size - 1].m_szFileInfo.c_str()));
         currentFolderPath = currentFolderPath.erase(currentFolderPath.size() - 1); /*path of the playlist should be without / */
         ETG_TRACE_USR4(("MediaListInterfaceClientHandler::RequestFolderList currentFolderPath:%s", currentFolderPath.c_str()));

         m_listReqAct = _mediaPlayerProxy->sendCreateMediaPlayerPlaylistListStart(*this, currentFolderPath);
      }
      else
      {
         if (u8activeRegion == REGION_COCKPIT)
         {
            m_listReqAct = _mediaPlayerProxy->sendCreateMediaPlayerFileListStart(*this, m_oMPlayHistoryFolderList.oFileList[u32Size - 1].m_szFileInfo, m_u8CurrentDeviceTag, T_e8_MPlayFileTypeSelection__e8FTS_AUDIO_VIDEO_PLAYLIST);
            ETG_TRACE_USR1(("MediaListInterfaceClientHandler::RequestFolderList Cockpit Update"));
         }
         else
         {
            m_listReqAct = _mediaPlayerProxy->sendCreateMediaPlayerFileListStart(*this, m_oMPlayHistoryFolderList.oFileList[u32Size - 1].m_szFileInfo, m_u8CurrentDeviceTag, T_e8_MPlayFileTypeSelection__e8FTS_AUDIO_PLAYLIST);
            ETG_TRACE_USR1(("MediaListInterfaceClientHandler::RequestFolderList Cabin Update"));
         }
      }
   }
   else
   {
      //make the root folder list visible and the sublist invisible

      //to set the text of the Browse page
      SetFileInfoStr("/");
      //First time request the root folder
      tCString strRootPath = "/";
      if (u8activeRegion == REGION_COCKPIT)
      {
         m_listReqAct = _mediaPlayerProxy->sendCreateMediaPlayerFileListStart(*this, strRootPath, m_u8CurrentDeviceTag, T_e8_MPlayFileTypeSelection__e8FTS_AUDIO_VIDEO_PLAYLIST);
         ETG_TRACE_USR1(("MediaListInterfaceClientHandler::RequestFolderList Cockpit Update"));
      }
      else
      {
         m_listReqAct = _mediaPlayerProxy->sendCreateMediaPlayerFileListStart(*this, strRootPath, m_u8CurrentDeviceTag, T_e8_MPlayFileTypeSelection__e8FTS_AUDIO_PLAYLIST);
         ETG_TRACE_USR1(("MediaListInterfaceClientHandler::RequestFolderList Cabin Update"));
      }
   }
}


/**
* onCreateMediaPlayerFileListError - function called when mediaplayer gets an error during the method call of CreateMediaPlayerFileList.
*
* @param[in] proxy
* @param[in] error
* @return void
*/
void tclMediaClientHandler::onCreateMediaPlayerFileListError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
      const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListError >& error)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::onCreateMediaPlayerFileListError"));
}


/**
* onCreateMediaPlayerFileListResult - function called when mediaplayer gets result during the method call of CreateMediaPlayerFileList.
*
* @param[in] proxy
* @param[in] result
* @return void
*/
void tclMediaClientHandler::onCreateMediaPlayerFileListResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
      const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::CreateMediaPlayerFileListResult >& result)
{
   if (m_listReqAct != result->getAct())
   {
      ETG_TRACE_ERR(("Request and response does not match"));
      return;
   }
   createInstanceIfNull(m_u32CurrentListType);
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onCreateMediaPlayerFileListResult CurrentListType %d", m_u32CurrentListType));

   if (_listMap.count(m_u32CurrentListType))
   {
      uint32 currentListHandle = result->getU32ListHandle();
      HMIModelListImplementation::getInstance().updateListHandle(currentListHandle);
      _listMap[m_u32CurrentListType]->vSetListHandle(result->getU32ListHandle());
      _listMap[m_u32CurrentListType]->vSetListSize(result->getU32ListSize());
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onCreateMediaPlayerFileListResult:CurrentListHandle = %d , CurrentListSize = %d"
                      , _listMap[m_u32CurrentListType]->u32GetListHandle(), _listMap[m_u32CurrentListType]->u32GetListSize()));
      HMIModelListImplementation::getInstance().UpdateCurrentListSize(_listMap[m_u32CurrentListType]->u32GetListSize(), m_u32CurrentListType);

      requestNewListEntry();
      updateFolderInfo();
      updateFolderBrowsingHistory();

      if (_listMap[m_u32CurrentListType]->u32GetListSize() > 0)
      {
         vTriggertStatemachine();
      }
      else
      {
         /*initStatemachine();
         if (HMIModelListImplementation::getInstance().getIsNewList())
         {
            HMIModelListImplementation::getInstance().IsNewList(false);
            ::Courier::Message* poNewListEntry = NULL;
            poNewListEntry = COURIER_MESSAGE_NEW(::NewListEntryMsg)();
            poNewListEntry->Post();
         }*/
         m_currentListState = LIST_REQUEST_PROCESS_DONE;
         vClearListDataOnSizeEmpty();
      }
   }
   else
   {
      ETG_TRACE_USR1(("MediaListInterfaceClientHandler::onCreateMediaPlayerFileListResult List is not added in _ListMap"));
   }
}


void tclMediaClientHandler::onCreateMediaPlayerPlaylistListError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::CreateMediaPlayerPlaylistListError >& /*error*/)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::onCreateMediaPlayerPlaylistListError"));
}


void tclMediaClientHandler::onCreateMediaPlayerPlaylistListResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/, const boost::shared_ptr< ::mplay_MediaPlayer_FI::CreateMediaPlayerPlaylistListResult >& result)
{
   if (m_listReqAct != result->getAct())
   {
      ETG_TRACE_ERR(("Request and response does not match"));
      return;
   }
   createInstanceIfNull(m_u32CurrentListType);
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onCreateMediaPlayerPlaylistListResult CurrentListType ::%d", m_u32CurrentListType));

   if (_listMap.count(m_u32CurrentListType))
   {
      uint32 currentListHandle = result->getU32ListHandle();
      HMIModelListImplementation::getInstance().updateListHandle(currentListHandle);
      _listMap[m_u32CurrentListType]->vSetListHandle(result->getU32ListHandle());
      _listMap[m_u32CurrentListType]->vSetListSize(result->getU32ListSize());
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onCreateMediaPlayerPlaylistListResult:CurrentListHandle = %d , CurrentListSize = %d"
                      , _listMap[m_u32CurrentListType]->u32GetListHandle(), _listMap[m_u32CurrentListType]->u32GetListSize()));
      HMIModelListImplementation::getInstance().UpdateCurrentListSize(_listMap[m_u32CurrentListType]->u32GetListSize(), m_u32CurrentListType);

      requestNewListEntry();
      updateFolderInfo();
      updateFolderBrowsingHistory();

      if (_listMap[m_u32CurrentListType]->u32GetListSize() > 0)
      {
         vTriggertStatemachine();
      }
      else
      {
         m_currentListState = LIST_REQUEST_PROCESS_DONE;

         vClearListDataOnSizeEmpty();
      }
   }
   else
   {
      ETG_TRACE_USR1(("MediaListInterfaceClientHandler::onCreateMediaPlayerPlaylistListResult List is not added in _ListMap"));
   }
}


/************************************************************************
*FUNCTION		: requestFolderSliceList
*DESCRIPTION	: Calls a sendRequestMediaPlayerFileListSliceStart with ListHandle, m_windowStartIndex and m_windowSize to the service
*PARAMETER		: void
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::requestFolderSliceList(uint32 windowStartIndex, uint32 windowSize)
{
   if (_mediaPlayerProxy)
   {
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::requestFolderSliceList m_windowStartIndex = %d, requestWindowSize = %d", windowStartIndex, windowSize));

      m_FolderFilewindowStartIndex = windowStartIndex;

      if (_listMap.count(m_u32CurrentListType))
      {
         ETG_TRACE_USR4(("MediaListInterfaceClientHandler::requestFolderSliceList u32GetListHandle = %d", _listMap[m_u32CurrentListType]->u32GetListHandle()));
         ETG_TRACE_USR4(("MediaListInterfaceClientHandler::requestFolderSliceList u32GetListSize = %d", _listMap[m_u32CurrentListType]->u32GetListSize()));
         m_listReqAct = _mediaPlayerProxy->sendRequestMediaPlayerFileListSliceStart(*this, _listMap[m_u32CurrentListType]->u32GetListHandle(), windowStartIndex, windowSize);
      }
   }
}


/************************************************************************
*FUNCTION		: onRequestMediaPlayerFileListSliceError
*DESCRIPTION	: called if RequestMediaPlayerFileListSlice property is updated with error from media player
*PARAMETER		: proxy
*PARAMETER		: error
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::onRequestMediaPlayerFileListSliceError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
      const boost::shared_ptr< ::mplay_MediaPlayer_FI::RequestMediaPlayerFileListSliceError >& /*error*/)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::onRequestMediaPlayerFileListSliceError"));
}


/************************************************************************
*FUNCTION		: onRequestMediaPlayerFileListSliceResult
*DESCRIPTION	: called on getting result for RequestMediaPlayerFileListSlice property from media player
*PARAMETER		: proxy
*PARAMETER		: result
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::onRequestMediaPlayerFileListSliceResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
      const boost::shared_ptr< ::mplay_MediaPlayer_FI::RequestMediaPlayerFileListSliceResult >& result)
{
   if (m_listReqAct != result->getAct())
   {
      ETG_TRACE_ERR(("Request and response does not match"));
      return;
   }
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onRequestMediaPlayerFileListSliceResult with file list size %d ", result->getOFileList().size()));
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onRequestMediaPlayerFileListSliceResult with m_u32CurrentListType %d ", m_u32CurrentListType));

   uint8 iCurrListIndex = 0;
   _sFolderListItemText.clear();

   _oFileListMediaObjects = result->getOFileList();
   for (; iCurrListIndex < result->getOFileList().size(); ++iCurrListIndex)
   {
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onRequestMediaPlayerFileListSliceResult _oFileListMediaObjects[iCurrListIndex].getSFilename().c_str() %s ", _oFileListMediaObjects[iCurrListIndex].getSFilename().c_str()));
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onRequestMediaPlayerFileListSliceResult _oFileListMediaObjects[iCurrListIndex].getE8FileType %d", _oFileListMediaObjects[iCurrListIndex].getE8FileType()));
      tU8 FileType = _oFileListMediaObjects[iCurrListIndex].getE8FileType();

      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onRequestMediaPlayerFileListSliceResult SM_VARIANT_TYPE_VIDEO %d", SM_VARIANT_TYPE_VIDEO));
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onRequestMediaPlayerFileListSliceResult MPlay_fi_types::T_e8_MPlayFileType__e8FT_VIDEO %d", MPlay_fi_types::T_e8_MPlayFileType__e8FT_VIDEO));

      _sFolderListItemText.push_back(_oFileListMediaObjects[iCurrListIndex].getSFilename().c_str());
   }

   if (m_u32CurrentListType == SM_MEDIA_LISTTYPE_FOLDER)
   {
      ETG_TRACE_USR4(("UpdateFolderList with SM_MEDIA_LISTTYPE_FOLDER "));
      HMIModelListImplementation::getInstance().UpdateFolderList(_sFolderListItemText);
   }
   else if (m_u32CurrentListType == SM_MEDIA_LISTTYPE_FOLDER_FILE)
   {
      ETG_TRACE_USR4(("UpdateFolderList with SM_MEDIA_LISTTYPE_FOLDER_FILE "));
      HMIModelListImplementation::getInstance().UpdateFolderFileList(_sFolderListItemText);
   }

   vTriggertStatemachine();

   /*if (HMIModelListImplementation::getInstance().getIsNewList())
   {
      HMIModelListImplementation::getInstance().IsNewList(false);
      HMIModelListImplementation::getInstance().updateIsNewListRequest(true);
      ::Courier::Message* poNewListEntry = NULL;
      poNewListEntry = COURIER_MESSAGE_NEW(::NewListEntryMsg)();
      poNewListEntry->Post();
   }
   else
   {
      if (m_u32CurrentListType == SM_MEDIA_LISTTYPE_FOLDER)
      {
         HMIModelListImplementation::getInstance().UpdateFolderList(_sFolderListItemText);
      }
      else if (m_u32CurrentListType == SM_MEDIA_LISTTYPE_FOLDER_FILE)
      {
         HMIModelListImplementation::getInstance().UpdateFolderFileList(_sFolderListItemText);
      }
      HMIModelListImplementation::getInstance().updateIsWaitingForListCompletion(false);
      vTriggertStatemachine();
   }*/
}


void tclMediaClientHandler::updateFolderInfo()
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::updateFolderInfo list count= %d", _listMap.count(m_u32CurrentListType)));
   if (_listMap.count(m_u32CurrentListType))
   {
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::updateFolderInfo with list handle= %d", _listMap[m_u32CurrentListType]->u32GetListHandle()));
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::updateFolderInfo with list size= %d", _listMap[m_u32CurrentListType]->u32GetListSize()));
      _folderListInfo._listHandle = _listMap[m_u32CurrentListType]->u32GetListHandle();
      _folderListInfo._listSize =  _listMap[m_u32CurrentListType]->u32GetListSize();
   }
}


void tclMediaClientHandler::updateFolderBrowsingHistory()
{
   bool isAvailableInHistory = false;
   std::vector<FolderListInfo>::iterator itr = _folderListBrowsingHistory.begin();
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::updateFolderBrowsingHistory browsing history updated with list size= %d", _folderListInfo._listSize));
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::updateFolderBrowsingHistory browsing history updated with list handle= %d", _folderListInfo._listHandle));

   while (itr != _folderListBrowsingHistory.end())
   {
      if (itr->_listHandle == _folderListInfo._listHandle)
      {
         isAvailableInHistory = true;
         itr = _folderListBrowsingHistory.end();
      }
      else
      {
         ++itr;
      }
   }

   if (!isAvailableInHistory)
   {
      _folderListBrowsingHistory.push_back(_folderListInfo);
   }
   else
   {
      ETG_TRACE_USR1(("MediaListInterfaceClientHandler::updateFolderBrowsingHistory browsing history already available in vector"));
   }
}


void tclMediaClientHandler::populateListFromHistory()
{
   if (!_folderListBrowsingHistory.empty())
   {
      FolderListInfo historyInfo = _folderListBrowsingHistory.back();
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::populateListFromHistory  listhandle: %d", historyInfo._listHandle));
      releaseListHandle(historyInfo._listHandle);
      _folderListBrowsingHistory.pop_back();
      updateFolderListParameters();
   }
}


void tclMediaClientHandler::updateFolderListParameters()
{
   FolderListInfo folderBrowsingHistoryInfo = _folderListBrowsingHistory.back();
   createInstanceIfNull(m_u32CurrentListType);
   if (_listMap.count(m_u32CurrentListType))
   {
      _listMap[m_u32CurrentListType]->vSetListHandle(folderBrowsingHistoryInfo._listHandle);
      _listMap[m_u32CurrentListType]->vSetListSize(folderBrowsingHistoryInfo._listSize);
      HMIModelListImplementation::getInstance().UpdateCurrentListSize(_listMap[m_u32CurrentListType]->u32GetListSize(), m_u32CurrentListType);
      HMIModelListImplementation::getInstance().updateListHandle(_listMap[m_u32CurrentListType]->u32GetListHandle());
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::updateFolderListParameters: m_u32CurrentListType: %d", m_u32CurrentListType));
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::updateFolderListParameters: listhandle: %d", _listMap[m_u32CurrentListType]->u32GetListHandle()));
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::updateFolderListParameters: listsize: %d", _listMap[m_u32CurrentListType]->u32GetListSize()));
   }
}


/**
 * ReleaseListHandle - Function to set the release the list handle for the list
 * @param[in] uint32 - listhandle
 * @parm[out] none
 * @return void
 */
void tclMediaClientHandler::releaseListHandle(uint32 listHandle)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::releaseListHandle:listhandle:%d", listHandle));

   if (listHandle != 0 && (_mediaPlayerProxy->getNowPlaying().getU32ListHandle() != listHandle))
   {
      _mediaPlayerProxy->sendReleaseMediaPlayerListStart(*this, listHandle);
   }
}


void tclMediaClientHandler::clearFolderBrowseHistory()
{
   ETG_TRACE_USR1(("MediaListInterfaceClientHandler::clearFolderBrowseHistory"));
   _folderListBrowsingHistory.clear();
}


#endif


uint32 tclMediaClientHandler::ListTypeToStoreMetadataTag()
{
   uint32 listType = INVALID_LIST_TYPE;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::ListTypeToStoreMetadataTag currentlistType:%d", m_u32CurrentListType));
#endif
   switch (m_u32CurrentListType)
   {
      case T_e8_MPlayListType__e8LTY_PODCAST:
      {
         listType = T_e8_MPlayListType__e8LTY_PODCAST;
         break;
      }

      case T_e8_MPlayListType__e8LTY_VIDEO:
      {
         listType = T_e8_MPlayListType__e8LTY_VIDEO;
         break;
      }

      case T_e8_MPlayListType__e8LTY_AUDIOBOOK:
      {
         listType = T_e8_MPlayListType__e8LTY_AUDIOBOOK;
         break;
      }

      case T_e8_MPlayListType__e8LTY_PLAYLIST:
      {
         listType = T_e8_MPlayListType__e8LTY_PLAYLIST;
         break;
      }

      case T_e8_MPlayListType__e8LTY_GENRE:
      {
         listType = T_e8_MPlayListType__e8LTY_GENRE;
         break;
      }

      case T_e8_MPlayListType__e8LTY_ARTIST_ALBUM:
      case T_e8_MPlayListType__e8LTY_GENRE_ARTIST_ALBUM:
      case T_e8_MPlayListType__e8LTY_ALBUM:
      case T_e8_MPlayListType__e8LTY_GENRE_ALBUM:
      {
         listType = T_e8_MPlayListType__e8LTY_ALBUM;
         break;
      }

      case T_e8_MPlayListType__e8LTY_ARTIST:
         // case T_e8_MPlayListType__e8LTY_GENRE_ARTIST:
      {
         listType = T_e8_MPlayListType__e8LTY_ARTIST;
         break;
      }

      case T_e8_MPlayListType__e8LTY_SONG:
      case T_e8_MPlayListType__e8LTY_ARTIST_SONG:
      case T_e8_MPlayListType__e8LTY_ARTIST_ALBUM_SONG:
      case T_e8_MPlayListType__e8LTY_ALBUM_SONG:
      case T_e8_MPlayListType__e8LTY_GENRE_ARTIST_ALBUM_SONG:
      case T_e8_MPlayListType__e8LTY_GENRE_ARTIST_SONG:
      case T_e8_MPlayListType__e8LTY_GENRE_ALBUM_SONG:
      case T_e8_MPlayListType__e8LTY_PODCAST_EPISODE:
      case T_e8_MPlayListType__e8LTY_VIDEO_EPISODE:
      case T_e8_MPlayListType__e8LTY_PLAYLIST_SONG:
      case T_e8_MPlayListType__e8LTY_BOOKTITLE_CHAPTER:
      case T_e8_MPlayListType__e8LTY_GENRE_SONG:

      {
         listType = T_e8_MPlayListType__e8LTY_SONG;
         break;
      }

      default:
         break;
   }
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::ListTypeToStoreMetadataTag listType:%d", listType));
#endif
   return listType;
}


uint32 tclMediaClientHandler::ListTypeToUpdateIndexDatabase(uint32 listType)
{
   uint32 returnListType = INVALID_LIST_TYPE;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::ListTypeToUpdateIndexDatabase:listType:%d", listType));
#endif
   switch (listType)
   {
      case T_e8_MPlayListType__e8LTY_GENRE_ALBUM:
      case T_e8_MPlayListType__e8LTY_GENRE_SONG:
      {
         returnListType = T_e8_MPlayListType__e8LTY_GENRE;
         break;
      }

      case T_e8_MPlayListType__e8LTY_ARTIST_ALBUM:
         //    case T_e8_MPlayListType__e8LTY_GENRE_ARTIST_ALBUM:
      {
         returnListType = T_e8_MPlayListType__e8LTY_ARTIST;
         break;
      }

      case T_e8_MPlayListType__e8LTY_ALBUM_SONG:
      //  case T_e8_MPlayListType__e8LTY_GENRE_ARTIST_ALBUM_SONG:
      case T_e8_MPlayListType__e8LTY_GENRE_ALBUM_SONG:
      case T_e8_MPlayListType__e8LTY_ARTIST_ALBUM_SONG:
      {
         returnListType = T_e8_MPlayListType__e8LTY_ALBUM;
         break;
      }

      case T_e8_MPlayListType__e8LTY_PLAYLIST_SONG:
      {
         returnListType = T_e8_MPlayListType__e8LTY_PLAYLIST;
         break;
      }

      case T_e8_MPlayListType__e8LTY_BOOKTITLE_CHAPTER:
      {
         returnListType = T_e8_MPlayListType__e8LTY_AUDIOBOOK;
         break;
      }

      case T_e8_MPlayListType__e8LTY_VIDEO_EPISODE:
      {
         returnListType = T_e8_MPlayListType__e8LTY_VIDEO;
         break;
      }

      case T_e8_MPlayListType__e8LTY_PODCAST_EPISODE:
      {
         returnListType = T_e8_MPlayListType__e8LTY_PODCAST;
         break;
      }

      default:
         break;
         //do nothing now.
   }
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::ListTypeToUpdateIndexDatabase returnlistType:%d", returnListType));
#endif
   return returnListType;
}


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
/************************************************************************
*FUNCTION		: bCheckFolder
*DESCRIPTION	: To check if the filetype is folder ir not
*PARAMETER		: u32CurrentIndex
*PARAMETER		:
*RETURNVALUE	: bool
************************************************************************/
bool tclMediaClientHandler::bCheckFolder(tU32 u32CurrentIndex)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bCheckFolder current index%d", u32CurrentIndex));
   bool bIsFolder = false;
   tU8 u8Filetype = _oFileListMediaObjects[u32CurrentIndex].getE8FileType();
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bCheckFolder currentindex:%d, u8Filetype:%d", u32CurrentIndex, u8Filetype));
   bIsFolder = (u8Filetype == MPlay_fi_types::T_e8_MPlayFileType__e8FT_FOLDER) ? true : false;
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bCheckFolder bIsFolder :%d", bIsFolder));

   return bIsFolder;
}


/***********************************************************************************
* Function     	: HandleBrowseFolderSubListRequest()
* Description   : Handle List Request for Folder Sub-level Lists
* Parameters    : u32DestListtype, u32SourceListtype, Index
* Return value  : None
************************************************************************************/
void tclMediaClientHandler::HandleBrowseFolderSubListRequest(uint32 SourcelistType, uint32 DestlistType, uint32 Index)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::HandleBrowseFolderSubListRequest::Index :%d", Index));
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::HandleBrowseFolderSubListRequest::SourcelistType :%d", SourcelistType));
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::HandleBrowseFolderSubListRequest::DestlistType :%d", DestlistType));

   if (true == bIsMaxFolderDepthReached())	/*Check Folder Depth reached or not. Folder Depth:11*/
   {
      ETG_TRACE_USR1(("MediaListInterfaceClientHandler::HandleBrowseFolderSubListRequest Folder Depth Reached"));
      // return;
   }
   if (true == bHandleFilePlay(Index, SourcelistType))
   {
      enListStatus = EN_LISTSTATUS_FORWARD;	/*Set the List Browsing Status Enum*/
      enListType = EN_LISTTYPE_FOLDERFILE;	/*Set the List Type Enum*/

      //request to mw
      HMIModelListImplementation::getInstance().updateListSize();
      vRequestSubList(DestlistType, Index);
   }
   else
   {
      HMIModelListImplementation::getInstance().IsNewList(false);
      /*update selected item is File so play it*/
   }
}


/****************************************************************************************************************************
*FUNCTION    : bHandleFilePlay
*DESCRIPTION : Handle the Folder list item selection
*				If selected item is File,Request service to play that item
*				If selected item is Folder,Get the selected folder's path and update the Structure trMPlay_FolderListItem
*				 and trigger the data request for selected folder
*PARAMETER   : Index,SourceListtype
*RETURNVALUE :  If selected item is File,Return value is false.
*			    If selected item is Folder,Return value is true.
*****************************************************************************************************************************/
bool tclMediaClientHandler::bHandleFilePlay(uint32 Index, uint32 SourceListtype)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay index:%d,sourcelisttype:%d", Index, SourceListtype));

   tU8 u8Filetype = (tU8)_oFileListMediaObjects[Index].getE8FileType();
   tU8 u8FilePlayableStatus = (tU8)_oFileListMediaObjects[Index].getE8PlayableStatus();
   tU32 u32Tag = (tU32)_oFileListMediaObjects[Index].getU32Tag();
   std::string currentFolderPath;

   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay FolderFilePlayableStatus:%d", u8FilePlayableStatus));

   //need to update

   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay filelist size %d ", m_oMPlayHistoryFolderList.oFileList.size()));
   //play the files

   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay u8Filetype:%d", u8Filetype));
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay u32SourceListtype:%d", SourceListtype));
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay Index:%d", Index));
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay u32Tag:%d", u32Tag));
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay m_u32CurrentListType:%d", m_u32CurrentListType));
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay _listMap.count(m_u32CurrentListType):%d", _listMap.count(m_u32CurrentListType)));

   if ((u8Filetype == T_e8_MPlayFileTypeSelection__e8FTS_AUDIO) || (u8Filetype == T_e8_MPlayFileTypeSelection__e8FTS_VIDEO))//check the filetype
   {
      if (_listMap.count(m_u32CurrentListType))
      {
         ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay FilePlayableStatus:%d", u8FilePlayableStatus));

         if (u8FilePlayableStatus == MPlay_fi_types::T_e8_MPlayPlayableStatus__e8FP_DRM_PROTECTED)
         {
            POST_MSG((COURIER_MESSAGE_NEW(Open_WMA_DRM_Popup)()));
         }
         else
         {
            HMIModelListImplementation::getInstance().IsSongPlayedFromFolder();
            m_listReqAct = _mediaPlayerProxy->sendPlayItemFromListByTagStart(*this, _listMap[m_u32CurrentListType]->u32GetListHandle(), u32Tag);
         }
         if (m_oMPlayHistoryFolderList.oFileList.size() == 0)
         {
            HMIModelListImplementation::getInstance().SetCurrentListType(SM_MEDIA_LISTTYPE_FOLDER);
         }
         else
         {
            HMIModelListImplementation::getInstance().SetCurrentListType(SM_MEDIA_LISTTYPE_FOLDER_FILE);
         }
      }
   }
   else
   {
      //show the subfolderlist and set the visibilty of the root folder list
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay m_oMPlayHistoryFolderList.oFileList.size  (%d)", m_oMPlayHistoryFolderList.oFileList.size()));
      if (m_oMPlayHistoryFolderList.oFileList.size() == 0)
      {
         currentFolderPath = "/";
         if (_oFileListMediaObjects[Index].getSFilename().c_str() != NULL)
         {
            MediaUtils::getInstance().AppendSelectedFolderInCurrFolderPath(currentFolderPath, _oFileListMediaObjects[Index].getSFilename());
            currentFolderPath = currentFolderPath + "/";
            ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay filepath %s", currentFolderPath.c_str()));
            ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay fileName %s", _oFileListMediaObjects[Index].getSFilename().c_str()));
         }
         else
         {
            ETG_TRACE_USR1(("MediaListInterfaceClientHandler::bHandleFilePlay _oFileListMediaObjects[Index].getSFilename().c_str() is empty"));
            return false;
         }
      }
      else
      {
         if (_oFileListMediaObjects[Index].getSFilename().c_str() != NULL)
         {
            currentFolderPath = "";
            trMPlay_FolderListItem m_oTemp = m_oMPlayHistoryFolderList.oFileList.back();

            //10 folders are not listed in Browse list view because folders are listing based on the file name.
            //And the filename appending was not proper because always appending only the last folder name due to improper usage of 'strncat' function
            //Corrected the same with appending proper folder name retriving from 'm_oTemp'
            MediaUtils::getInstance().AppendSelectedFolderInCurrFolderPath(currentFolderPath, m_oTemp.m_szFileInfo);
            MediaUtils::getInstance().AppendSelectedFolderInCurrFolderPath(currentFolderPath, _oFileListMediaObjects[Index].getSFilename());
            currentFolderPath = currentFolderPath + "/";
            ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay :filepath :%s", currentFolderPath.c_str()));
            ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay :m_oTemp.m_szFileInfo :%s", m_oTemp.m_szFileInfo.c_str()));
            ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay :_oFileListMediaObjects[Index].getSFilename() :%s", _oFileListMediaObjects[Index].getSFilename().c_str()));
         }
         else
         {
            ETG_TRACE_USR1(("MediaListInterfaceClientHandler::bHandleFilePlay _oFileListMediaObjects[Index].getSFilename().c_str() is empty"));
            return false;
         }
      }

      if (_listMap.count(m_u32CurrentListType))
      {
         uint32 iCurrentListSize = _listMap[m_u32CurrentListType]->u32GetListSize();//changed to avoid resets to uint32

         ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bHandleFilePlay  iCurrentListSize (%d)", iCurrentListSize));
         if (iCurrentListSize > 0)
         {
            m_oFolderListItem.m_u32ListHandle = 0;
            m_oFolderListItem.m_szFileInfo = currentFolderPath;
            m_oFolderListItem.m_u32SrcListtype = SourceListtype;
            m_oMPlayHistoryFolderList.oFileList.push_back(m_oFolderListItem);
            /*Handle to maintain folder hierarchy during BTN_Up */
            m_oMPlayParentFolderList.oFileList.push_back(m_oFolderListItem);  //Store same information in new vector
            HMIModelListImplementation::getInstance().SetCurrentListType(SM_MEDIA_LISTTYPE_FOLDER_FILE);
            //NOTE:To update the text on top of the scene
            //SetFileInfoStr(szFilePath);
            return true;
         }
      }
   }
   return false;
}


void tclMediaClientHandler::SetFileInfoStr(std::string _fileInfoStr)
{
   if (_fileInfoStr.compare("Browse") == 0)//check if the string is browse, map it to ID
   {
      (*_browseText).mBrowseText = Candera::String(id45);
   }
   else
   {
      (*_browseText).mBrowseText = _fileInfoStr.c_str();
   }

   _browseText.MarkAllItemsModified();
   _browseText.SendUpdate();
}


/*********************************************************************************************
* Function     	: vHandleParentLevelFolderListRequest()
* Description   : Handle Parent List Request for Folder Lists(enter through via BTN_UP)
* Parameters    : None
* Return value  : None
************************************************************************************************/
void tclMediaClientHandler::vHandleParentLevelFolderListRequest()
{
   ETG_TRACE_USR1(("MediaListInterfaceClientHandler::vHandleParentLevelFolderListRequest"));
   enListStatus = EN_LISTSTATUS_BACKWARD;	/*Set the List Browsing Status Enum*/
   tU32 u32DestListType = MEDIA_LISTTYPE_INVALID;
   tU32 u32ChildListType = LIST_TYPE_FILE;	/*For Folder and Folder_File, Folder_File is a child*/

   tU8 u8Size = m_oMPlayParentFolderList.oFileList.size();

   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vHandleParentLevelFolderListRequest m_oMPlayParentFolderList.oFileList.size():%d", u8Size));
   if (u8Size > MEDIA_C_VALUE_ZERO)
   {
      u32DestListType = m_oMPlayParentFolderList.oFileList[u8Size - MEDIA_C_VALUE_ONE].m_u32SrcListtype;	/*Get SrcListType from ListInterfaceHandler*/
   }

   vRequestParentfolderItems(); 	/*Request parent List data to List Interface Handler*/
}


/*****************************************************************************************
*FUNCTION		: vRequestParentfolderItems
*DESCRIPTION	: Requesting Parent folder files during BTN_Up
*PARAMETER		: None
*RETURNVALUE	: NA
*****************************************************************************************/
void tclMediaClientHandler::vRequestParentfolderItems()
{
   tU8 u8Size = m_oMPlayHistoryFolderList.oFileList.size();
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vRequestParentfolderItems u8Size:%d", u8Size));

   if (u8Size > 0)
   {
      // Release the ListHandle

      char szLastFilePath[MPLAY_SLICE_INFO_LENGTH] = "";
      char* findLastFile = NULL;
      char* LastFile = NULL;
      if ((u8Size - 2) >= 0)
      {
         //strcpy(szLastFilePath, m_oMPlayHistoryFolderList.oFileList[u8Size - 2].m_szFileInfo.c_str());
         //strncpy(szLastFilePath, m_oMPlayHistoryFolderList.oFileList[u8Size - 2].m_szFileInfo.c_str(), sizeof(m_oMPlayHistoryFolderList.oFileList[u8Size - 2].m_szFileInfo.c_str()));
         strncpy(szLastFilePath, m_oMPlayHistoryFolderList.oFileList[u8Size - 2].m_szFileInfo.c_str(), m_oMPlayHistoryFolderList.oFileList[u8Size - 2].m_szFileInfo.length());

         findLastFile = strtok(szLastFilePath, "/");

         while (findLastFile != NULL)
         {
            LastFile = findLastFile;
            ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vRequestParentfolderItems LastFile:%s", LastFile));
            findLastFile = strtok(NULL, "/");
         }
      }
      m_oMPlayHistoryFolderList.oFileList.pop_back();
   }

   uint32 u32Size = m_oMPlayHistoryFolderList.oFileList.size();
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vRequestParentfolderItems u32Size:%d", u32Size));

   if (u32Size > 0)
   {
      //to set the text of the Browse page
      SetFileInfoStr(m_oMPlayHistoryFolderList.oFileList[u32Size - 1].m_szFileInfo);
   }
   else
   {
      SetFileInfoStr("/");
      tCString strRootPath = "/";
   }

   initStatemachine();
   vTriggertStatemachine();
}


void tclMediaClientHandler::requestNewListEntry()
{
   HMIModelListImplementation::getInstance().setWaitAnimationState(ANIMATION_START);
   /* ::Courier::Message* poNewListEntry = NULL;
   poNewListEntry = COURIER_MESSAGE_NEW(::NewListEntryMsg)();
   if (poNewListEntry != NULL)
   {
      poNewListEntry->Post();
   } */
}


/*****************************************************************************************
*FUNCTION		: bIsMaxFolderDepthReached
*DESCRIPTION	: Check whether folder browsing reached Last Iteration(Depth Level:11 + 1)
*PARAMETER		: None
*RETURNVALUE	: bool
*****************************************************************************************/
bool tclMediaClientHandler::bIsMaxFolderDepthReached() const
{
   tBool bIsFolderDepthReached = FALSE;
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bIsMaxFolderDepthReached FOLDER DEPTH :%d", m_oMPlayHistoryFolderList.oFileList.size()));

   if (m_oMPlayHistoryFolderList.oFileList.size() > MAX_FOLDER_DEPTH_SUPPORTED)
   {
      bIsFolderDepthReached = TRUE;
   }
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::bIsMaxFolderDepthReached bIsFolderDepthReached :%d", bIsFolderDepthReached));

   return bIsFolderDepthReached;
}


/*****************************************************************************************
*FUNCTION		: onPlayItemFromListError
*DESCRIPTION	: function called when mediaplayer gets an error during the method call of PlayItemFromList.
*PARAMETER		: proxy,error
*RETURNVALUE	: void
*****************************************************************************************/
void tclMediaClientHandler::onPlayItemFromListError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
      const boost::shared_ptr< ::mplay_MediaPlayer_FI::PlayItemFromListError >& /*error*/)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::onPlayItemFromListError"));
}


/*****************************************************************************************
*FUNCTION		: onPlayItemFromListResult
*DESCRIPTION	: function called when mediaplayer gets result during the method call of PlayItemFromList.
*PARAMETER		: proxy,result
*RETURNVALUE	: void
*****************************************************************************************/
void tclMediaClientHandler::onPlayItemFromListResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
      const boost::shared_ptr< ::mplay_MediaPlayer_FI::PlayItemFromListResult >& /*result*/)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::onPlayItemFromListResult"));
   StateTransitionHandler::getInstance().setStateTransitionReason(ST_TRANSITION_REASON_SONG_SELECT_IN_LIST);
}


/************************************************************************
*FUNCTION		: requestMediaPlayerSliceList
*DESCRIPTION	: Calls a sendRequestMediaPlayerIndexedListSliceStart with ListHandle, m_windowStartIndex and m_windowSize to the service
*PARAMETER		: void
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::requestMediaPlayerSliceList(uint32 windowStartIndex, uint32 windowSize)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::requestMediaPlayerSliceLis sendRequestMediaPlayerIndexedListSliceStart->m_windowStartIndex = %d, requestWindowSize = %d", windowStartIndex, windowSize));
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::requestMediaPlayerSliceLis sendRequestMediaPlayerIndexedListSliceStart->count = %d", _listMap.count(m_u32CurrentListType)));
   if (_mediaPlayerProxy)
   {
      if (_listMap.count(m_u32CurrentListType))
      {
         m_listReqAct =  _mediaPlayerProxy->sendRequestMediaPlayerIndexedListSliceStart(*this, _listMap[m_u32CurrentListType]->u32GetListHandle(), windowStartIndex, windowSize);
      }
   }
}


/************************************************************************
*FUNCTION		: onRequestMediaPlayerIndexedListSliceError
*DESCRIPTION	: called if RequestMediaPlayerIndexedListSlice property is updated with error from media player
*PARAMETER		: proxy
*PARAMETER		: error
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::onRequestMediaPlayerIndexedListSliceError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
      const boost::shared_ptr< ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedListSliceError >& error)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::onRequestMediaPlayerIndexedListSliceError"));
}


/************************************************************************
*FUNCTION		: onRequestMediaPlayerIndexedListSliceResult
*DESCRIPTION	: called on getting result for RequestMediaPlayerIndexedListSlice property from media player
*PARAMETER		: proxy
*PARAMETER		: result
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::onRequestMediaPlayerIndexedListSliceResult(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
      const boost::shared_ptr< ::mplay_MediaPlayer_FI::RequestMediaPlayerIndexedListSliceResult >& result)
{
   if (m_listReqAct != result->getAct())
   {
      ETG_TRACE_ERR(("Request and response does not match"));
      return;
   }
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::onRequestMediaPlayerIndexedListSliceResult listSize = %d ", result->getOMediaObjects().size()));

   _oMediaObjects = result->getOMediaObjects();

   vUpdateMetadataTags(_oMediaObjects);
   vUpdatePlayableStatus(_oMediaObjects);
   vCreateListData(_oMediaObjects);
   /* if (HMIModelListImplementation::getInstance().getIsNewList())
    {
       HMIModelListImplementation::getInstance().IsNewList(false);
       ::Courier::Message* poNewListEntry = NULL;
       poNewListEntry = COURIER_MESSAGE_NEW(::NewListEntryMsg)();
       poNewListEntry->Post();
    }
    else
    {
       vCreateListData(_oMediaObjects);
    }*/
}


/********************************************************************************************
*FUNCTION		: vUpdateMetadataTags
*DESCRIPTION	: Store the Tag value for loading list items
*PARAMETER		: oFiDataObject
*RETURNVALUE	: NA
********************************************************************************************/
void tclMediaClientHandler::vUpdateMetadataTags(::MPlay_fi_types::T_MPlayMediaObjects _oMediaObjects)
{
   MPlay_fi_types::T_MPlayMediaObjects::iterator itr = _oMediaObjects.begin();
   uint32_t iCurrListIndex = 0;
   uint32_t u8MetaDataTag = m_ListTypetoMetaDataTagMap[m_u32CurrentListType];

   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vUpdateMetadataTags:u8MetaDataTag:%d", u8MetaDataTag));

   std::vector<uint32> vMetadataTag;
   vMetadataTag.clear();

   for (; iCurrListIndex < _oMediaObjects.size(); ++iCurrListIndex)
   {
      if (u8MetaDataTag == META_DATA_TAG_ONE)
      {
         vMetadataTag.push_back(_oMediaObjects[iCurrListIndex].getU32MetaDataTag1());
         ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vUpdateMetadataTags :META_DATA_TAG_ONE :%d", _oMediaObjects[iCurrListIndex].getU32MetaDataTag1()));
      }
      else if (u8MetaDataTag == META_DATA_TAG_TWO)
      {
         vMetadataTag.push_back(_oMediaObjects[iCurrListIndex].getU32MetaDataTag2());
         ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vUpdateMetadataTags :META_DATA_TAG_tWO :%d", _oMediaObjects[iCurrListIndex].getU32MetaDataTag2()));
      }
      else if (u8MetaDataTag == META_DATA_TAG_THREE)
      {
         vMetadataTag.push_back(_oMediaObjects[iCurrListIndex].getU32MetaDataTag3());
         ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vUpdateMetadataTags :META_DATA_TAG_THREE :%d", _oMediaObjects[iCurrListIndex].getU32MetaDataTag3()));
      }
      else if (u8MetaDataTag == META_DATA_TAG_FOUR)
      {
         vMetadataTag.push_back(_oMediaObjects[iCurrListIndex].getU32MetaDataTag4());
         ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vUpdateMetadataTags :META_DATA_TAG_FOUR :%d", _oMediaObjects[iCurrListIndex].getU32MetaDataTag4()));
      }
      else
      {
         ETG_TRACE_USR1(("MediaListInterfaceClientHandler::vUpdateMetadataTags :Not Supported ListType"));
      }
   }

   uint32 currentListType = ListTypeToStoreMetadataTag();
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vUpdateMetadataTags:currentListType:%d", currentListType));

   if (currentListType != INVALID_LIST_TYPE)
   {
      createInstanceIfNull(currentListType);
      if (_listMap.count(currentListType))
      {
         _listMap[currentListType]->vStoreIndexToTagData(vMetadataTag);
      }
   }
}


void tclMediaClientHandler::vCreateListData(::MPlay_fi_types::T_MPlayMediaObjects _oMediaObjects)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::vCreateListData"));

   if (_oMediaObjects.size() > MEDIA_C_VALUE_ZERO)
   {
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vCreateListData Category Type: %d", _oMediaObjects[0].getE8CategoryType()));
      switch (_oMediaObjects[0].getE8CategoryType())
      {
         /*Create one Field Information Lists*/
         case T_e8_MPlayCategoryType__e8CTY_ARTIST:
         case T_e8_MPlayCategoryType__e8CTY_GENRE:
         case T_e8_MPlayCategoryType__e8CTY_TITLE:
         case T_e8_MPlayCategoryType__e8CTY_PLAYLIST:
         case T_e8_MPlayCategoryType__e8CTY_CHAPTER:
         case T_e8_MPlayCategoryType__e8CTY_NAME:
         case T_e8_MPlayCategoryType__e8CTY_EPISODE:
         {
            vHandleOneFieldListCreation(m_u32CurrentListType, _oMediaObjects);
         }
         break;
         case T_e8_MPlayCategoryType__e8CTY_ALBUM:
         {
            if (T_e8_MPlayListType__e8LTY_ALBUM == m_u32CurrentListType)
            {
               vHandleOneFieldListCreation(m_u32CurrentListType, _oMediaObjects);
            }
            else
            {
               vHandleTwoFieldListCreation(m_u32CurrentListType, _oMediaObjects);
            }
         }
         break;
         /*Create Three Field Information Lists*/
         case T_e8_MPlayCategoryType__e8CTY_SONG:
         {
            vHandleTwoFieldListCreation(m_u32CurrentListType, _oMediaObjects);
         }
         break;
         default:
         {
            if ((T_e8_MPlayListType__e8LTY_PODCAST == m_u32CurrentListType) ||
                  (T_e8_MPlayListType__e8LTY_PODCAST_EPISODE == m_u32CurrentListType))
            {
               vHandleOneFieldListCreation(m_u32CurrentListType, _oMediaObjects);
            }
         }
         break;
      }
   }
   else
   {
      /*If list size is zero, set a blank string to song list*/
      /*vHandleOneFieldListCreation(m_u32CurrentListType, _oMediaObjects);
      vHandleTwoFieldListCreation(m_u32CurrentListType, _oMediaObjects);*/
   }
}


/************************************************************************
*FUNCTION		: vHandleOneFieldListCreation
*DESCRIPTION	: Updates the List data to the Model Component
*PARAMETER		: void
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::vHandleOneFieldListCreation(const uint32_t u32CurrentListType, ::MPlay_fi_types::T_MPlayMediaObjects _oMediaObjects)
{
   MPlay_fi_types::T_MPlayMediaObjects::iterator itr = _oMediaObjects.begin();
   uint8 iCurrListIndex = 0;
   _sOneItemListText.clear();
   uint32 u8MetadataTag = m_ListTypetoMetaDataTagMap[u32CurrentListType];
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vHandleOneFieldListCreation:MetadataTag:%d", u8MetadataTag));

   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vHandleOneFieldListCreation:_oMediaObjects.size():%d", _oMediaObjects.size()));

   if (_oMediaObjects.size() > MEDIA_C_VALUE_ZERO)
   {
      for (; iCurrListIndex < _oMediaObjects.size(); ++iCurrListIndex)
      {
         ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vHandleOneFieldListCreation:_oMediaObjects.size():%d", _oMediaObjects[iCurrListIndex].getE8CategoryType()));
         tU8 Filetype = _oMediaObjects[iCurrListIndex].getE8CategoryType();

         if (u8MetadataTag == META_DATA_TAG_ONE)
         {
            _sOneItemListText.push_back(_oMediaObjects[iCurrListIndex].getSMetaDataField1().c_str());
         }
         else if (u8MetadataTag == META_DATA_TAG_TWO)
         {
            _sOneItemListText.push_back(_oMediaObjects[iCurrListIndex].getSMetaDataField2().c_str());
         }
         else if (u8MetadataTag == META_DATA_TAG_THREE)
         {
            _sOneItemListText.push_back(_oMediaObjects[iCurrListIndex].getSMetaDataField3().c_str());
         }
         else
         {
            _sOneItemListText.push_back(_oMediaObjects[iCurrListIndex].getSMetaDataField4().c_str());
         }
      }
   }
   HMIModelListImplementation::getInstance().OneItemListDataProviderToGui(_sOneItemListText, u32CurrentListType);
   vTriggertStatemachine();
}


/************************************************************************
*FUNCTION		: vHandleTwoFieldListCreation
*DESCRIPTION	: Updates the List data to the Model Component
*PARAMETER		: void
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::vHandleTwoFieldListCreation(const uint32_t& u8CurrentListType, ::MPlay_fi_types::T_MPlayMediaObjects _oMediaObjects)
{
   MPlay_fi_types::T_MPlayMediaObjects::iterator itr = _oMediaObjects.begin();
   uint8 iCurrListIndex = 0;
   _sTwoItemListText.clear();
   uint32 u8MetadataTag = m_ListTypetoMetaDataTagMap[m_u32CurrentListType];
   media_TwoTextListInfo _titleListInfo;
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vHandleTwoFieldListCreation:MetadataTag:%d", u8MetadataTag));

   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vHandleTwoFieldsListCreation:_oMediaObjects.size():%d,u8MetadataTag: %d", _oMediaObjects.size(), u8MetadataTag));

   for (; iCurrListIndex < _oMediaObjects.size(); ++iCurrListIndex)
   {
      if (u8MetadataTag == META_DATA_TAG_ONE)
      {
         _titleListInfo.szFirstText = _oMediaObjects[iCurrListIndex].getSMetaDataField1().c_str();
      }
      else if (u8MetadataTag == META_DATA_TAG_TWO)
      {
         _titleListInfo.szFirstText = _oMediaObjects[iCurrListIndex].getSMetaDataField2().c_str();
      }
      else if (u8MetadataTag == META_DATA_TAG_THREE)
      {
         _titleListInfo.szFirstText = _oMediaObjects[iCurrListIndex].getSMetaDataField3().c_str();
      }
      else
      {
         _titleListInfo.szFirstText = _oMediaObjects[iCurrListIndex].getSMetaDataField4().c_str();
      }

      /* if ((_oMediaObjects[iCurrListIndex].getE8CategoryType() == T_e8_MPlayCategoryType__e8CTY_SONG) &&
             (m_u32CurrentListType == SM_MEDIA_LISTTYPE_PLAYLIST_SONG))
       {
          _titleListInfo.szSecondText = "";
       }
       else*/
      {
         _titleListInfo.szSecondText = _oMediaObjects[iCurrListIndex].getSMetaDataField2().c_str();
      }

      _sTwoItemListText.push_back(_titleListInfo);
   }
   HMIModelListImplementation::getInstance().TwoItemListDataProviderToGui(_sTwoItemListText, m_u32CurrentListType);
   vTriggertStatemachine();
}


/************************************************************************
*FUNCTION		: BrowseListItemSelect
*DESCRIPTION	: Plays the song from the list/Selects the sublist based on the ListType
*PARAMETER		: void
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::BrowseListItemSelect(uint32 DestlistType, uint32 Index)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::BrowseListItemSelect DestlistType = %d ,Index = %d" , DestlistType, Index));
   vRequestSubList(DestlistType, Index);
}


/************************************************************************
*FUNCTION		: vRequestSubList
*DESCRIPTION	: Populates the sublist based on the ListType
*PARAMETER		: void
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::vRequestSubList(uint32 DestlistType, uint32 Index)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vRequestSubList Index = %d", Index));
   m_u32CurrentListType = DestlistType;
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vRequestSubList DestlistType = %d", m_u32CurrentListType));
   m_u32SelectedIndex = Index;
   createInstanceIfNull(m_u32CurrentListType);
   vUpdateIndexDatabase(m_u32CurrentListType, Index);
   initStatemachine();
   vTriggertStatemachine();
}


/************************************************************************
*FUNCTION		: vPlayitemRequest
*DESCRIPTION	: Plays the item selected from the list
*PARAMETER		: void
*RETURNVALUE	: void
************************************************************************/
void tclMediaClientHandler::vPlayitemRequest(uint32 Index)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vPlayitemRequest Index = %d", Index));
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vPlayitemRequest m_u32CurrentListType = %d", m_u32CurrentListType));

   if (_listMap.count(m_u32CurrentListType))
   {
      uint32 u32Handle = _listMap[m_u32CurrentListType]->u32GetListHandle();
      uint32 u32Tag = _listMap[T_e8_MPlayListType__e8LTY_SONG]->u32GetTagbyIndex(Index);
      uint32 playableStatus = _listMap[m_u32CurrentListType]->u32GetPlayableStatusbyIndex(Index);
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vPlayitemRequest Handle = %d", u32Handle));
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vPlayitemRequest sendPlayItemFromListByTagStart = %d", u32Tag));
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vPlayitemRequest playableStatus: %d", playableStatus));

      if (_mediaPlayerProxy)
      {
         if (playableStatus == MPlay_fi_types::T_e8_MPlayPlayableStatus__e8FP_DRM_PROTECTED)
         {
            POST_MSG((COURIER_MESSAGE_NEW(Open_WMA_DRM_Popup)()));
         }
         else
         {
            m_listReqAct = _mediaPlayerProxy->sendPlayItemFromListByTagStart(*this, u32Handle, u32Tag);
         }
      }
      else
      {
         //do nothing
      }
   }
   else
   {
      //do nothing
   }
}


/**
* vCreateInstanceIfNull - Creats a new database for list type
* @param[in] u8ListType
* @parm[out] none
* @return void
*/
void tclMediaClientHandler::createInstanceIfNull(uint32 listType)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::createInstanceIfNull :listType %d", listType));

   std::map<uint32, ListUtilityDatabase*>::iterator Iter_DB = _listMap.find(listType);
   if (Iter_DB == _listMap.end())
   {
      ListUtilityDatabase* listUtilityDatabase = new ListUtilityDatabase();
      insertNewUtilityDatabaseToListMap(listType, listUtilityDatabase);
   }
   else
   {
      ETG_TRACE_USR1(("MediaListInterfaceClientHandler::vCreateInstanceIfNull ListUtilityDatabase is already created"));
   }
}


void tclMediaClientHandler::vReleaseMediaplayerListHandle(uint32 listType)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vReleaseMediaplayerListHandle :listType %d", listType));

   if (_listMap.count(listType))
   {
      if (_mediaPlayerProxy)
      {
         m_listReqAct =  _mediaPlayerProxy->sendReleaseMediaPlayerListStart(*this, _listMap[listType]->u32GetListHandle());
      }
      _listMap.erase(listType);
   }
   else
   {
      ETG_TRACE_USR1(("MediaListInterfaceClientHandler::vReleaseMediaplayerListHandle :List not found"));
   }
}


/**
*  insertNewUtilityDatabaseToListMap - inserts the listUtilityDatabase for a 'listType' to the '_listMap'
*  @param [in] listType
*  @param [in] listUtilityDatabase
*  @return void
*/
void tclMediaClientHandler::insertNewUtilityDatabaseToListMap(uint32 listType, ListUtilityDatabase* listUtilityDatabase)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::insertNewUtilityDatabaseToListMap :listType %d", listType));

   if (listUtilityDatabase)
   {
      _listMap.insert(std::pair<uint32, ListUtilityDatabase* >(listType, listUtilityDatabase));
   }
   else
   {
   }
}


/**************************************************************************************
*FUNCTION		: UpdateIndexDatabase
*DESCRIPTION	: updates user selected index value into the map database.
*PARAMETER		: u8ListType,u32Index
*RETURNVALUE	: NA
*HISTORY		:
**************************************************************************************/
void tclMediaClientHandler::vUpdateIndexDatabase(uint32_t u32ListType, uint32_t u32Index)
{
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vUpdateIndexDatabase u32ListType=%d, u32Index=%d", u32ListType, u32Index));
   uint32 currentListType = ListTypeToUpdateIndexDatabase(u32ListType);
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vUpdateIndexDatabase currentListType=%d", currentListType));

   if (currentListType != INVALID_LIST_TYPE)
   {
      createInstanceIfNull(currentListType);
      if (_listMap.count(currentListType))
      {
         _listMap[currentListType]->vSetActiveItemIndex(u32Index);
      }
   }
}


/********************************************************************************************
*FUNCTION		: vUpdatePlayableStatus
*DESCRIPTION	: Store the value of playable status for loading list items
*PARAMETER		: oFiDataObject
*RETURNVALUE	: NA
********************************************************************************************/
void tclMediaClientHandler::vUpdatePlayableStatus(::MPlay_fi_types::T_MPlayMediaObjects _oMediaObjects)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::vUpdatePlayableStatus"));
   MPlay_fi_types::T_MPlayMediaObjects::iterator itr = _oMediaObjects.begin();
   uint32_t iCurrListIndex = 0;

   std::vector<uint32> vPlayableStatus;
   vPlayableStatus.clear();

   for (; iCurrListIndex < _oMediaObjects.size(); ++iCurrListIndex)
   {
      vPlayableStatus.push_back(_oMediaObjects[iCurrListIndex].getE8PlayableStatus());
   }
   ETG_TRACE_USR4(("MediaListInterfaceClientHandler::vUpdatePlayableStatus CurrentListType : %d", m_u32CurrentListType));

   createInstanceIfNull(m_u32CurrentListType);
   if (_listMap.count(m_u32CurrentListType))
   {
      _listMap[m_u32CurrentListType]->vStoreIndexToPlayableStatus(vPlayableStatus);
   }
}


/************************************************************************
*FUNCTION		: onFolderBrowseStructureClearedError
*DESCRIPTION	: called if FolderBrowseStructureCleared property is updated with error from media player
*PARAMETER		: proxy
*PARAMETER		: result
*RETURNVALUE	: void
************************************************************************/

void tclMediaClientHandler::onFolderBrowseStructureClearedError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
      const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::FolderBrowseStructureClearedError >& error)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::FolderBrowseStructureClearedError received"));
}


/************************************************************************
*FUNCTION		: onFolderBrowseStructureClearedStatus
*DESCRIPTION	: Received this property update whenever the cache memeory of BT device get cleared
*PARAMETER		: proxy
*PARAMETER		: result
*RETURNVALUE	: void
************************************************************************/

void tclMediaClientHandler::onFolderBrowseStructureClearedStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
      const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::FolderBrowseStructureClearedStatus >& status)
{
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::onFolderBrowseStructureClearedStatus received"));
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::onFolderBrowseStructureClearedStatus g_SM_ActiveMediaSource :%d", g_SM_ActiveMediaSource));
   ETG_TRACE_COMP(("MediaListInterfaceClientHandler::onFolderBrowseStructureClearedStatus m_u32CurrentListType :%d", m_u32CurrentListType));

   if (g_SM_ActiveMediaSource == MPlay_fi_types::T_e8_MPlayDeviceType__e8DTY_BLUETOOTH && m_u32CurrentListType == LIST_TYPE_FILE)
   {
      HMIModelListImplementation::getInstance().setWaitAnimationState(ANIMATION_START);
      ::Courier::Message* poBTBrowsePressMsg = NULL;
      poBTBrowsePressMsg = COURIER_MESSAGE_NEW(::BTBrowsePressedUpdMsg)();
      if (poBTBrowsePressMsg != NULL)
      {
         poBTBrowsePressMsg->Post();
      }
   }
}


/**************************************************************************************
*FUNCTION		: vCreateMapListTypetoMetaDataTag
*DESCRIPTION	: creating the Map of listtype to Metadata
*PARAMETER		: NA
*RETURNVALUE	: NA
*HISTORY		:
**************************************************************************************/
void tclMediaClientHandler::vCreateMapListTypetoMetaDataTag()
{
   ETG_TRACE_USR1(("MediaListInterfaceClientHandler::vCreateMapListTypetoMetaDataTag received"));

   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_ALBUM] = META_DATA_TAG_THREE;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_ALBUM_SONG] = META_DATA_TAG_FOUR;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_ARTIST] = META_DATA_TAG_TWO;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_ARTIST_ALBUM] = META_DATA_TAG_THREE;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_ARTIST_SONG] = META_DATA_TAG_FOUR;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_ARTIST_ALBUM_SONG] = META_DATA_TAG_FOUR;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_AUDIOBOOK] = META_DATA_TAG_TWO;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_AUDIOBOOKTITLE_CHAPTER] = META_DATA_TAG_THREE;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_FOLDER] = META_DATA_TAG_UNKNOWN;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_FOLDER_FILE] = META_DATA_TAG_UNKNOWN;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_GENRE] = META_DATA_TAG_ONE;
//  m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_GENRE_ARTIST] = META_DATA_TAG_TWO;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_GENRE_ALBUM] = META_DATA_TAG_THREE;
//  m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_GENRE_ARTIST_ALBUM] = META_DATA_TAG_THREE;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_GENRE_ALBUM_SONG] = META_DATA_TAG_FOUR;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_GENRE_SONG] = META_DATA_TAG_FOUR;
//  m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_GENRE_ARTIST_SONG] = META_DATA_TAG_FOUR;
//  m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_GENRE_ARTIST_ALBUM_SONG] = META_DATA_TAG_FOUR;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_PLAYLIST] = META_DATA_TAG_ONE;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_PLAYLIST_SONG] = META_DATA_TAG_FOUR;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_PODCAST] = META_DATA_TAG_ONE;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_PODCAST_EPISODE] = META_DATA_TAG_TWO;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_SONG] = META_DATA_TAG_FOUR;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_VIDEO] = META_DATA_TAG_ONE;
   m_ListTypetoMetaDataTagMap[SM_MEDIA_LISTTYPE_VIDEO_EPISODE] = META_DATA_TAG_TWO;
}


void tclMediaClientHandler::getListHandle(uint32 listType)
{
   if (_mediaPlayerProxy)
   {
      ETG_TRACE_USR4(("MediaListInterfaceClientHandler::getListHandle count = %d", _listMap.count(listType)));
      if (_listMap.count(listType))
      {
         ETG_TRACE_USR4(("MediaListInterfaceClientHandler::getListHandle list handle = %d", _listMap[listType]->u32GetListHandle()));
         HMIModelListImplementation::getInstance().updateListHandle(_listMap[listType]->u32GetListHandle());
      }
   }
}


#endif
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
void tclMediaClientHandler::updateCurrentListType(uint32 listType)
{
   m_u32CurrentListType = listType;
}


#endif
}//end of namespace Core
}//end of namespace App
