/**************************************************************************************
* @file         : VerticalListManager.h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _VerticalListManager_H_
#define _VerticalListManager_H_

#include "AppBase/ServiceAvailableIF.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Core/ListHandling/ExternalMediaListDBManager/ExternalMediaListDBManager.h"
#include "Core/ListHandling/HorizontalListManager/HorizontalListManager.h"
#include "Core/ListHandling/ListInfoDatabaseHandler/ListInfoDatabaseHandler.h"
#include "Core/ListHandling/ListConfiguration/ListConfiguration.h"
#include "Core/ListHandling/ListSession/ListSession.h"
#include "Core/ListHandling/ListQueueHandler/ListQueueHandler.h"
#include "Core/ListHandling/ListGuiResponseHandler/VerticalListGuiResponseHandler.h"
#include "Core/ListHandling/EMPListInterfaceHandler/MockInterface/MockEMPListInterfaceHandler.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppHmi_MediaMessages.h"
#include "AvdeccPluginConstant.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Core/ExternalMediaDefines.h"
#include <bits/stdc++.h>
#include "DataModel/ListRegistry.h"

using namespace ::bosch::cm::di::HmiEmpListInterface;

namespace App {
namespace Core {

class EMPListInterfaceHandler;
class EMPListPlaybackHandler;
class EMPListFactory;

class VerticalListManager
   : public ListImplementation
   , public ::App::Core::ICategorySelectionUpdateObserver
{
   public:

      VerticalListManager(HorizontalListManager* horizontalListManagerObj, ExternalMediaSourceHandler* mediaSourceHandler
                          , EnumConst::entSourceType sourceType);
      virtual ~VerticalListManager();
      void initializeMemberVariables();
      void initializeInstances();
      void initVerticalListSize();
      void clearInstance();
      void registerObservors();
      void deregisterObservors();

      static void TraceCmd_InitiateMockClass(bool value);
      void onCategorySelection(EnumConst::entListType listType);

      void onListDataRequest(uint16 listId, uint16 startIndex, uint16 windowSize);
      void sendListRequest();
      void onListItemPressed(int selectedRow, int selectedColumn);
      void onListCreateResponse();
      void updateListSize();
      void updateListConfig(EnumConst::entListType listType);
      uint32 getVerticalStartindex();
      void onListLoadingComplete();
      void onListSliceResponse();
      void getListData(enListState listState);
      void requestToLoadSubList(EnumConst::entListType subListType);
      void onPlayableItemSelection(EnumConst::entListType subListType, uint16 absoluteIndex);
      EnumConst::entListType getActiveListType();
      void resetListState();
      void onAllButtonPressed();
      void onPreviousButtonPressed();
      void updateToQueue(int startIndex, int windowSize);
      void updateList(EnumConst::entListType requestedListType);
      void onSourceAllocationListUpdate();
      int getDeviceType();
      void onListErrorResponse();
      bool onCourierMessage(const CurrentMediaStateUpdMsg& msg);
      bool onCourierMessage(const MockCreateListandSliceListResMsg& msg);
      void updateAbsoluteIndex(EnumConst::entListType nextListType);
      int getListTypeWindowSize();
      void calculateAllLanguageButtonStatus();
      void onVideoLanguageListItemPressed(int32 Hdl, int32 subHdl);
      void onExternalBrowseScreenExit();
      std::string getNextFolderPath(std::string strPath);
      void setFileInfoStr(std::string _fileInfo);
      std::string getPreviousFolderPath(std::string strPath);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)

      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_OBJ(_mockEMPListInterfaceHandler)
      COURIER_MSG_MAP_DELEGATE_END();

   private:

      VerticalListManager(const VerticalListManager& obj);
      VerticalListManager& operator= (const VerticalListManager& obj);

      EMPListFactory* _empListFactory;
      ListContainer* _container;
      ListConfiguration* _listConfiguration;
      ListInfoDatabaseHandler* _listInfoDBHandler;
      ListSession* _listSession;
      ListQueueHandler* _queueHandler;
      EMPListInterfaceHandler* _empListInterfaceHandler;
      MockEMPListInterfaceHandler* _mockEMPListInterfaceHandler;
      EMPListPlaybackHandler* _empListPlaybackHandler;
      HorizontalListManager* _horizontalListManager;
      VerticalListGuiResponseHandler* _verticalListGuiResponseHandler;
      ExternalMediaSourceHandler* _externalMediaSourceHandler;

      static VerticalListManager* _verticalListManagerinstance;

      void setMockInterfaceState(bool state);
      void processQueuedListRequest();

      bool m_bMockActive;
      bool m_categorySelectionUpdateReceived;
      uint16 m_verticalStartIndex;
      uint16 m_CurrentWindowSize;
      uint16 _absoluteIndex1;
      uint16 _absoluteIndex2;
      int _selectedRow;
      EnumConst::entSourceType _currentSourceType;
      EnumConst::entListType _currentListType;
      EnumConst::entListType m_PrevListType;
      uint16 m_windowSize;
      uint8 m_mediaState;
      int _fileType;
      std::string _currentFolderPath;
      DataBindingItem<BrowserScreenListSizeDataBindingSource> m_BrowserScreenListSize;
      DataBindingItem<ExternalBrowseTextInfoDataBindingSource> _browseText;
};


} // namespace Core
} // namespace App


#endif  /* _VerticalListManager_H_ */
