/**************************************************************************************
* @file         : ListQueueHandler..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _ListQueueHandler_H_
#define _ListQueueHandler_H_

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "AvdeccPluginConstant.h"
#include "Core/ExternalMediaDefines.h"
#include <bits/stdc++.h>
#else
#include "utest/stubs/Apphmi_Media_Types_Common.h"
#include "Core/utest/stubs/Core/ListInfoDatabaseHandler.h"
#include "Core/utest/stubs/etg.h"
#endif

namespace App {
namespace Core {

class ListInfoDatabaseHandler;

class ListQueueHandler
{
   public:
      ListQueueHandler(ListInfoDatabaseHandler* _listInfoDBHandler);

      virtual ~ListQueueHandler();
      bool isRequestValid(EnumConst::entListType listType);
      void initializeQueuedInfo();
      bool isListRequestQueued();
      void queueListRequest(struct queueListInfo& queueListInfo);
      struct queueListInfo& getQueuedListInfo();
      void clearListQueue();
      void resetMembers();

   private:
      ListInfoDatabaseHandler* _listDBHandler;
      struct queueListInfo queuedListInfo;
      bool isRequestQueued;
};


} // namespace Core
} // namespace App


#endif  /* _ListQueueHandler_H_ */
